/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.event.client;

import com.benbenlaw.casting.config.EquipmentModifierConfig;
import com.benbenlaw.casting.item.CastingDataComponents;
import com.benbenlaw.casting.item.CastingItems;
import com.benbenlaw.casting.util.EquipmentModifierUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="casting", value={Dist.CLIENT})
public class EquipmentModifiersTooltip {
    @SubscribeEvent
    public static void addRepairingMoldTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.is((Item)CastingItems.REPAIRING_MOLD.get())) {
            if (Screen.hasShiftDown()) {
                event.getToolTip().add(Component.translatable((String)"tooltips.casting.stats.repairing_mold").withStyle(ChatFormatting.YELLOW));
            } else {
                event.getToolTip().add(Component.translatable((String)"tooltips.bblcore.shift").withStyle(ChatFormatting.YELLOW));
            }
        }
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        boolean hasEffects;
        ItemStack tool = event.getItemStack();
        List components = event.getToolTip();
        boolean hasEquipmentLevel = tool.getComponents().keySet().contains(CastingDataComponents.EQUIPMENT_LEVEL.get());
        boolean hasSilkTouch = Boolean.TRUE.equals(tool.getComponents().get((DataComponentType)CastingDataComponents.SILK_TOUCH.get()));
        boolean hasEfficiency = tool.getComponents().keySet().contains(CastingDataComponents.EFFICIENCY.get());
        boolean hasFortune = tool.getComponents().keySet().contains(CastingDataComponents.FORTUNE.get());
        boolean hasUnbreaking = tool.getComponents().keySet().contains(CastingDataComponents.UNBREAKING.get());
        boolean hasRepairing = tool.getComponents().keySet().contains(CastingDataComponents.REPAIRING.get());
        boolean hasTorchPlacing = tool.getComponents().keySet().contains(CastingDataComponents.TORCH_PLACING.get());
        boolean hasAutoSmelt = tool.getComponents().keySet().contains(CastingDataComponents.AUTO_SMELT.get());
        boolean hasLooting = tool.getComponents().keySet().contains(CastingDataComponents.LOOTING.get());
        boolean hasSharpness = tool.getComponents().keySet().contains(CastingDataComponents.SHARPNESS.get());
        boolean hasBeheading = tool.getComponents().keySet().contains(CastingDataComponents.BEHEADING.get());
        boolean hasLifesteal = tool.getComponents().keySet().contains(CastingDataComponents.LIFESTEAL.get());
        boolean hasKnockback = tool.getComponents().keySet().contains(CastingDataComponents.KNOCKBACK.get());
        boolean hasIgnite = tool.getComponents().keySet().contains(CastingDataComponents.IGNITE.get());
        boolean hasExcavation = tool.getComponents().keySet().contains(CastingDataComponents.EXCAVATION.get());
        boolean hasTeleporting = tool.getComponents().keySet().contains(CastingDataComponents.TELEPORTING.get());
        boolean hasMagnet = tool.getComponents().keySet().contains(CastingDataComponents.MAGNET.get());
        boolean hasProtection = tool.getComponents().keySet().contains(CastingDataComponents.PROTECTION.get());
        boolean hasStepAssist = tool.getComponents().keySet().contains(CastingDataComponents.STEP_ASSIST.get());
        boolean hasNightVision = tool.getComponents().keySet().contains(CastingDataComponents.NIGHT_VISION.get());
        boolean hasWaterBreathing = tool.getComponents().keySet().contains(CastingDataComponents.WATER_BREATHING.get());
        boolean hasWalterWalker = tool.getComponents().keySet().contains(CastingDataComponents.WATER_WALKER.get());
        boolean hasLavaWalker = tool.getComponents().keySet().contains(CastingDataComponents.LAVA_WALKER.get());
        boolean hasSpeed = tool.getComponents().keySet().contains(CastingDataComponents.SPEED.get());
        boolean hasFlight = tool.getComponents().keySet().contains(CastingDataComponents.FLIGHT.get());
        boolean bl = hasEffects = hasFlight || hasWalterWalker || hasLavaWalker || hasSpeed || hasWaterBreathing || hasNightVision || hasEquipmentLevel || hasStepAssist || hasProtection || hasMagnet || hasTeleporting || hasExcavation || hasIgnite || hasLifesteal || hasKnockback || hasBeheading || hasSharpness || hasLooting || hasAutoSmelt || hasTorchPlacing || hasRepairing || hasUnbreaking || hasFortune || hasEfficiency || hasSilkTouch;
        if (Screen.hasShiftDown() && hasEffects) {
            int index = 1;
            int toolLevel = Optional.ofNullable((Integer)tool.getComponents().get((DataComponentType)CastingDataComponents.EQUIPMENT_LEVEL.get())).orElse(0);
            if (hasEquipmentLevel) {
                int currentExperience = Optional.ofNullable((Integer)tool.getComponents().get((DataComponentType)CastingDataComponents.EQUIPMENT_EXPERIENCE.get())).orElse(0);
                double modifierLevel = EquipmentModifierUtils.getExperienceModifierLevel(toolLevel);
                int totalExperienceToNextLevel = (int)((double)((Integer)EquipmentModifierConfig.experiencePerLevelForEquipmentLevel.get()).intValue() + (double)((Integer)EquipmentModifierConfig.experiencePerLevelForEquipmentLevel.get()).intValue() * modifierLevel);
                components.add(index, Component.translatable((String)"tooltips.casting.stats.equipment_level", (Object[])new Object[]{toolLevel, currentExperience, totalExperienceToNextLevel}).withStyle(ChatFormatting.GOLD));
                ++index;
            }
            components.add(index, Component.empty());
            ++index;
            if (hasSilkTouch) {
                components.add(index, Component.translatable((String)"tooltips.casting.stats.silk_touch").withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasEfficiency) {
                int efficiencyLevel = Optional.ofNullable((Integer)tool.getComponents().get((DataComponentType)CastingDataComponents.EFFICIENCY.get())).orElse(0);
                components.add(index, Component.translatable((String)"tooltips.casting.stats.efficiency", (Object[])new Object[]{efficiencyLevel}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasFortune) {
                int fortuneLevel = Optional.ofNullable((Integer)tool.getComponents().get((DataComponentType)CastingDataComponents.FORTUNE.get())).orElse(0);
                components.add(index, Component.translatable((String)"tooltips.casting.stats.fortune", (Object[])new Object[]{fortuneLevel}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasUnbreaking) {
                int unbreakingLevel = Optional.ofNullable((Integer)tool.getComponents().get((DataComponentType)CastingDataComponents.UNBREAKING.get())).orElse(0);
                components.add(index, Component.translatable((String)"tooltips.casting.stats.unbreaking", (Object[])new Object[]{unbreakingLevel}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasRepairing) {
                int repairingLevel = Optional.ofNullable((Integer)tool.getComponents().get((DataComponentType)CastingDataComponents.REPAIRING.get())).orElse(0);
                components.add(index, Component.translatable((String)"tooltips.casting.stats.repairing", (Object[])new Object[]{repairingLevel}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasTorchPlacing) {
                components.add(index, Component.translatable((String)"tooltips.casting.stats.torch_placing").withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasAutoSmelt) {
                components.add(index, Component.translatable((String)"tooltips.casting.stats.auto_smelt").withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasLooting) {
                int lootingLevel = Optional.ofNullable((Integer)tool.getComponents().get((DataComponentType)CastingDataComponents.LOOTING.get())).orElse(0);
                components.add(index, Component.translatable((String)"tooltips.casting.stats.looting", (Object[])new Object[]{lootingLevel}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasSharpness) {
                int sharpnessLevel = Optional.ofNullable((Integer)tool.getComponents().get((DataComponentType)CastingDataComponents.SHARPNESS.get())).orElse(0);
                int totalAdditionalDamage = (int)(((Float)EquipmentModifierConfig.additionalMultiplierForSharpness.get()).floatValue() * (float)sharpnessLevel + ((Float)EquipmentModifierConfig.additionalAdditionForSharpness.get()).floatValue());
                components.add(index, Component.translatable((String)"tooltips.casting.stats.sharpness", (Object[])new Object[]{sharpnessLevel, totalAdditionalDamage}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasBeheading) {
                components.add(index, Component.translatable((String)"tooltips.casting.stats.beheading").withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasLifesteal) {
                int lifestealLevel = Optional.ofNullable((Integer)tool.getComponents().get((DataComponentType)CastingDataComponents.LIFESTEAL.get())).orElse(0);
                int percentageRestored = 10 * lifestealLevel;
                components.add(index, Component.translatable((String)"tooltips.casting.stats.lifesteal", (Object[])new Object[]{lifestealLevel, percentageRestored}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasKnockback) {
                int knockbackLevel = Optional.ofNullable((Integer)tool.getComponents().get((DataComponentType)CastingDataComponents.KNOCKBACK.get())).orElse(0);
                components.add(index, Component.translatable((String)"tooltips.casting.stats.knockback", (Object[])new Object[]{knockbackLevel}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasIgnite) {
                int igniteLevel = Optional.ofNullable((Integer)tool.getComponents().get((DataComponentType)CastingDataComponents.IGNITE.get())).orElse(0);
                components.add(index, Component.translatable((String)"tooltips.casting.stats.ignite", (Object[])new Object[]{igniteLevel}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasExcavation) {
                int excavationLevel = Optional.ofNullable((Integer)tool.getComponents().get((DataComponentType)CastingDataComponents.EXCAVATION.get())).orElse(0);
                int excavationArea = 1 + excavationLevel * 2;
                components.add(index, Component.translatable((String)"tooltips.casting.stats.excavation", (Object[])new Object[]{excavationLevel, excavationArea, excavationArea}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasTeleporting) {
                int teleportingLevel = Optional.ofNullable((Integer)tool.getComponents().get((DataComponentType)CastingDataComponents.TELEPORTING.get())).orElse(0);
                int blockAmount = (Integer)EquipmentModifierConfig.blocksPerLevelForTeleporting.get() * teleportingLevel;
                components.add(index, Component.translatable((String)"tooltips.casting.stats.teleporting", (Object[])new Object[]{teleportingLevel, blockAmount}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasMagnet) {
                int magnetLevel = Optional.ofNullable((Integer)tool.getComponents().get((DataComponentType)CastingDataComponents.MAGNET.get())).orElse(0);
                components.add(index, Component.translatable((String)"tooltips.casting.stats.magnet", (Object[])new Object[]{magnetLevel}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasProtection) {
                int protectionLevel = Optional.ofNullable((Integer)tool.getComponents().get((DataComponentType)CastingDataComponents.PROTECTION.get())).orElse(0);
                components.add(index, Component.translatable((String)"tooltips.casting.stats.protection", (Object[])new Object[]{protectionLevel}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasStepAssist) {
                int stepAssistLevel = Optional.ofNullable((Integer)tool.getComponents().get((DataComponentType)CastingDataComponents.STEP_ASSIST.get())).orElse(0);
                components.add(index, Component.translatable((String)"tooltips.casting.stats.step_assist", (Object[])new Object[]{stepAssistLevel}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasNightVision) {
                components.add(index, Component.translatable((String)"tooltips.casting.stats.night_vision").withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasWaterBreathing) {
                components.add(index, Component.translatable((String)"tooltips.casting.stats.water_breathing").withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasWalterWalker) {
                components.add(index, Component.translatable((String)"tooltips.casting.stats.water_walker").withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasLavaWalker) {
                components.add(index, Component.translatable((String)"tooltips.casting.stats.lava_walker").withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasSpeed) {
                int speedLevel = Optional.ofNullable((Integer)tool.getComponents().get((DataComponentType)CastingDataComponents.SPEED.get())).orElse(0);
                components.add(index, Component.translatable((String)"tooltips.casting.stats.speed", (Object[])new Object[]{speedLevel}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasFlight) {
                components.add(index, Component.translatable((String)"tooltips.casting.stats.flight").withStyle(ChatFormatting.BLUE));
                ++index;
            }
            components.add(1, Component.translatable((String)"tooltips.casting.stats.modifiers", (Object[])new Object[]{index - 3, toolLevel}).withStyle(ChatFormatting.GOLD));
        } else if (hasEffects) {
            components.add(1, Component.translatable((String)"tooltips.bblcore.shift").withStyle(ChatFormatting.YELLOW));
        }
    }
}

