/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.multiblock;

import com.benbenlaw.casting.multiblock.MultiblockData;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class CoreMultiblockDetector {
    public static MultiblockData findMultiblock(Level level, BlockPos controllerPos, Block controllerBlock, Predicate<BlockState> wallBlocks, Predicate<BlockState> floorBlocks, Predicate<BlockState> validExtraBlocks, boolean hollow, boolean optionalCorners, int maxVolume, int radius, int maxHeight) {
        List<BlockPos> notAirBlocks;
        BlockPos.MutableBlockPos top = controllerPos.mutable().move(Direction.UP);
        while (top.getY() < level.getMaxBuildHeight() && wallBlocks.test(level.getBlockState((BlockPos)top))) {
            top.move(Direction.UP);
        }
        top.move(Direction.DOWN);
        BlockState controllerState = level.getBlockState(controllerPos);
        if (controllerState.isAir()) {
            System.out.println("Controller block is not valid");
            return null;
        }
        Direction controllerFacing = (Direction)controllerState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        ArrayList<BlockPos> extraValidBlocks = new ArrayList<BlockPos>();
        Pair<BlockPos, BlockPos> topCorners = CoreMultiblockDetector.findEdges(level, controllerPos, controllerBlock, controllerFacing.getClockWise(), top.immutable(), wallBlocks, validExtraBlocks, optionalCorners, radius, extraValidBlocks);
        if (topCorners == null) {
            System.out.println("topCorners is null \u2014 aborting multiblock detection.");
            return null;
        }
        if (floorBlocks == null) {
            System.out.println("topCorners is null \u2014 aborting multiblock detection.");
            return null;
        }
        BlockPos.MutableBlockPos bottomCorner = ((BlockPos)topCorners.getFirst()).relative(controllerFacing.getOpposite()).relative(controllerFacing.getCounterClockWise()).mutable();
        int height = 0;
        while (height++ < maxHeight && !CoreMultiblockDetector.getPredicateOrWall(floorBlocks, wallBlocks).test(level.getBlockState((BlockPos)bottomCorner.move(Direction.DOWN)))) {
        }
        if (!floorBlocks.test(level.getBlockState((BlockPos)bottomCorner))) {
            System.out.println("Invalid bottom starting block at: " + String.valueOf(bottomCorner));
            return null;
        }
        List<BlockPos> notFloorBlocks = BlockPos.betweenClosedStream((BlockPos)((BlockPos)topCorners.getFirst()).relative(controllerFacing.getOpposite()).relative(controllerFacing.getCounterClockWise()).below(height), (BlockPos)((BlockPos)topCorners.getSecond()).relative(controllerFacing).relative(controllerFacing.getClockWise()).below(height)).filter(pos -> !floorBlocks.test(level.getBlockState(pos))).toList();
        if (!notFloorBlocks.isEmpty()) {
            System.out.println("Invalid floor blocks found at: " + String.valueOf(notFloorBlocks.getFirst()));
            return null;
        }
        for (int slice = 1; slice <= height; ++slice) {
            Pair<BlockPos, BlockPos> corners;
            if (optionalCorners && slice == height || (corners = CoreMultiblockDetector.findEdges(level, controllerPos, controllerBlock, controllerFacing.getClockWise(), top.immutable().below(slice), wallBlocks, validExtraBlocks, optionalCorners, radius, extraValidBlocks)) != null) continue;
            System.out.println("Wall slice at level " + slice + " is invalid.");
            return null;
        }
        int volume = (int)BlockPos.betweenClosedStream((BlockPos)((BlockPos)topCorners.getFirst()).relative(controllerFacing.getOpposite()).relative(controllerFacing.getCounterClockWise()), (BlockPos)((BlockPos)topCorners.getSecond()).relative(controllerFacing).relative(controllerFacing.getClockWise()).below(height - 1)).count();
        if (volume > maxVolume) {
            System.out.println("Structure volume exceeds limit: " + volume + " > " + maxVolume);
            return null;
        }
        if (hollow && !(notAirBlocks = BlockPos.betweenClosedStream((BlockPos)((BlockPos)topCorners.getFirst()).relative(controllerFacing.getOpposite()).relative(controllerFacing.getCounterClockWise()), (BlockPos)((BlockPos)topCorners.getSecond()).relative(controllerFacing).relative(controllerFacing.getClockWise()).below(height - 1)).filter(pos -> !level.getBlockState(pos).isAir()).toList()).isEmpty()) {
            System.out.println("Structure is not hollow. Block found at: " + String.valueOf(notAirBlocks.getFirst()));
            return null;
        }
        return new MultiblockData(controllerPos, topCorners, extraValidBlocks, height, volume);
    }

    private static Predicate<BlockState> getPredicateOrWall(Predicate<BlockState> floorBlocks, Predicate<BlockState> wallBlocks) {
        return floorBlocks != null ? floorBlocks : wallBlocks;
    }

    private static Pair<BlockPos, BlockPos> findEdges(Level level, BlockPos controllerPos, Block controllerBlock, Direction dir, BlockPos initialPosition, Predicate<BlockState> validBlocks, Predicate<BlockState> validExtraBlocks, boolean optionalCorners, int radius, List<BlockPos> extraValidBlocks) {
        BlockPos firstCorner = new BlockPos((Vec3i)initialPosition);
        BlockPos secondCorner = new BlockPos((Vec3i)initialPosition);
        BlockPos.MutableBlockPos pointer = new BlockPos.MutableBlockPos(initialPosition.getX(), initialPosition.getY(), initialPosition.getZ());
        int turns = 0;
        int maxSize = radius;
        while (turns <= 4 && maxSize-- > 0 && validBlocks.test(level.getBlockState((BlockPos)pointer)) && (turns == 0 || !pointer.equals((Object)initialPosition))) {
            BlockPos nextPos = pointer.relative(dir);
            BlockState nextBlockState = level.getBlockState(nextPos);
            if (turns < 4 && !validBlocks.test(nextBlockState)) {
                BlockPos cornerCheck = pointer.relative(dir.getClockWise());
                if (optionalCorners && !validBlocks.test(level.getBlockState(cornerCheck))) {
                    pointer.move(dir);
                }
                if (turns == 0) {
                    firstCorner = pointer.immutable();
                }
                if (turns == 2) {
                    secondCorner = pointer.immutable();
                }
                dir = dir.getClockWise();
                ++turns;
            }
            pointer.move(dir);
            BlockState targetState = level.getBlockState((BlockPos)pointer);
            if (validExtraBlocks.test(targetState)) {
                extraValidBlocks.add(pointer.immutable());
            }
            if (!targetState.is(controllerBlock) || pointer.equals((Object)controllerPos)) continue;
            System.out.println("Multiple controllers are not allowed");
            return null;
        }
        if (turns == 4 && pointer.immutable().equals((Object)initialPosition)) {
            return Pair.of((Object)firstCorner, (Object)secondCorner);
        }
        System.out.println("Structure did not form a valid closed loop");
        return null;
    }
}

