/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.screen.controller;

import com.benbenlaw.casting.screen.controller.ControllerMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ControllerScreen
extends AbstractContainerScreen<ControllerMenu> {
    Level level;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"textures/gui/controller_gui.png");

    public ControllerScreen(ControllerMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.level = menu.level;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        this.renderProgressBars(guiGraphics);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderProgressBars(GuiGraphics guiGraphics) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean handled = super.mouseClicked(mouseX, mouseY, mouseButton);
        ItemStack heldItem = ((ControllerMenu)this.menu).getCarried();
        int tankX_1 = this.leftPos + 136;
        int tankY_1 = this.topPos + 15;
        int tankX_2 = this.leftPos + 153;
        int tankY_2 = this.topPos + 15;
        int tankX_3 = this.leftPos + 136;
        int tankY_3 = this.topPos + 45;
        int tankX_4 = this.leftPos + 153;
        int tankY_4 = this.topPos + 45;
        int tankWidth = 14;
        int tankHeight = 26;
        return handled;
    }

    private void renderWarning(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int tankX_1 = this.leftPos + 136;
        int tankY_1 = this.topPos + 15;
        int tankX_2 = this.leftPos + 153;
        int tankY_2 = this.topPos + 15;
        int tankX_3 = this.leftPos + 136;
        int tankY_3 = this.topPos + 45;
        int tankX_4 = this.leftPos + 153;
        int tankY_4 = this.topPos + 45;
        int tankWidth = 14;
        int tankHeight = 26;
    }

    private int getSlotX(int slot) {
        return switch (slot) {
            case 0, 5, 10 -> 12;
            case 1, 6, 11 -> 31;
            case 2, 7, 12 -> 50;
            case 3, 8, 13 -> 69;
            case 4, 9, 14 -> 88;
            default -> 0;
        };
    }

    private int getSlotY(int slot) {
        if (slot >= 0 && slot <= 4) {
            return 20;
        }
        if (slot >= 5 && slot <= 9) {
            return 39;
        }
        if (slot >= 10 && slot <= 14) {
            return 58;
        }
        return 0;
    }
}

