/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.block.entity.client;

import com.benbenlaw.casting.block.entity.multiblock.MultiblockCoolantTankBlockEntity;
import com.benbenlaw.casting.util.SingleFluidTank;
import com.benbenlaw.core.util.RenderUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class MultiblockCoolantTankBlockEntityRenderer
implements BlockEntityRenderer<MultiblockCoolantTankBlockEntity> {
    public MultiblockCoolantTankBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(MultiblockCoolantTankBlockEntity entity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        SingleFluidTank fluidTank = entity.fluidHandler;
        if (!fluidTank.isEmpty()) {
            FluidStack fluidStack = fluidTank.getFluid();
            VertexConsumer buffer = pBufferSource.getBuffer(Sheets.translucentCullBlockSheet());
            PoseStack.Pose last = pPoseStack.last();
            MultiblockCoolantTankBlockEntityRenderer.renderFluid(last, buffer, (BlockEntity)entity, fluidStack.getFluid(), (float)fluidTank.getFluidAmount() / (float)fluidTank.getCapacity(), pPackedLight);
        }
    }

    private static void renderFluid(PoseStack.Pose pose, VertexConsumer consumer, BlockEntity entity, Fluid fluid, float fillAmount, int packedLight) {
        int color = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(fluid.defaultFluidState(), (BlockAndTintGetter)entity.getLevel(), entity.getBlockPos());
        MultiblockCoolantTankBlockEntityRenderer.renderFluid(pose, consumer, fluid, fillAmount, color, packedLight);
    }

    public static void renderFluid(PoseStack.Pose pose, VertexConsumer consumer, Fluid fluid, float fillAmount, int color, int packedLight) {
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluid);
        TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(props.getStillTexture());
        float fluidHeight = 14.0f * fillAmount / 16.0f;
        float inset = 0.0625f;
        float faceSize = 0.875f;
        RenderUtil.renderFace((Direction)Direction.SOUTH, (PoseStack.Pose)pose, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)inset, (float)inset, (float)inset, (float)faceSize, (float)fluidHeight, (int)color, (int)packedLight);
        RenderUtil.renderFace((Direction)Direction.NORTH, (PoseStack.Pose)pose, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)inset, (float)inset, (float)inset, (float)faceSize, (float)fluidHeight, (int)color, (int)packedLight);
        RenderUtil.renderFace((Direction)Direction.EAST, (PoseStack.Pose)pose, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)inset, (float)inset, (float)inset, (float)faceSize, (float)fluidHeight, (int)color, (int)packedLight);
        RenderUtil.renderFace((Direction)Direction.WEST, (PoseStack.Pose)pose, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)inset, (float)inset, (float)inset, (float)faceSize, (float)fluidHeight, (int)color, (int)packedLight);
        RenderUtil.renderFace((Direction)Direction.UP, (PoseStack.Pose)pose, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)inset, (float)inset, (float)(inset + fluidHeight), (float)faceSize, (float)faceSize, (int)color, (int)packedLight);
        RenderUtil.renderFace((Direction)Direction.DOWN, (PoseStack.Pose)pose, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)inset, (float)inset, (float)(1.0f - inset), (float)faceSize, (float)faceSize, (int)color, (int)packedLight);
    }
}

