/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.block.entity.multiblock;

import com.benbenlaw.casting.block.CastingBlocks;
import com.benbenlaw.casting.block.entity.CastingBlockEntities;
import com.benbenlaw.casting.block.multiblock.MultiblockCoolantTankBlock;
import com.benbenlaw.casting.item.CastingDataComponents;
import com.benbenlaw.casting.screen.multiblock.MultiblockCoolantTankMenu;
import com.benbenlaw.casting.util.SingleFluidTank;
import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import com.benbenlaw.core.block.entity.handler.IInventoryHandlingBlockEntity;
import com.benbenlaw.core.block.entity.handler.InputOutputItemHandler;
import com.benbenlaw.core.util.FakePlayerUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiblockCoolantTankBlockEntity
extends SyncableBlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            MultiblockCoolantTankBlockEntity.this.setChanged();
            MultiblockCoolantTankBlockEntity.this.sync();
        }
    };
    private final IItemHandler controllerTankItemHandler = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 1);
    public final SingleFluidTank fluidHandler = new SingleFluidTank(4000){

        protected void onContentsChanged() {
            MultiblockCoolantTankBlockEntity.this.setChanged();
            MultiblockCoolantTankBlockEntity.this.sync();
        }
    };
    public final ContainerData data = new ContainerData(this){

        public int get(int p_39284_) {
            return 0;
        }

        public void set(int p_39285_, int p_39286_) {
        }

        public int getCount() {
            return 0;
        }
    };
    private FakePlayer fakePlayer;

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        return this.controllerTankItemHandler;
    }

    public void setHandler(ItemStackHandler itemStackHandler) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, itemStackHandler.getStackInSlot(i));
        }
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public IFluidHandler getFluidHandlerCapability(Direction side) {
        return this.fluidHandler;
    }

    public MultiblockCoolantTankBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CastingBlockEntities.MULTIBLOCK_COOLANT_TANK_BLOCK_ENTITY.get(), pos, state);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.fakePlayer = FakePlayerUtil.createFakePlayer((ServerLevel)serverLevel, (String)"castingControllerTank");
        }
    }

    @NotNull
    public Component getDisplayName() {
        return ((Block)CastingBlocks.MULTIBLOCK_COOLANT_TANK.get()).getName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new MultiblockCoolantTankMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick() {
        Level level;
        if (this.fakePlayer == null && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.fakePlayer = FakePlayerUtil.createFakePlayer((ServerLevel)serverLevel, (String)"castingCoolantTank");
        }
        FluidStack fluidStack = this.fluidHandler.getFluid();
        int fluidLightLevel = this.fluidHandler.isEmpty() ? 0 : fluidStack.getFluid().getFluidType().getLightLevel();
        BlockState state = this.getBlockState();
        if ((Integer)state.getValue((Property)MultiblockCoolantTankBlock.LIGHT_LEVEL) != fluidLightLevel) {
            assert (this.level != null);
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)MultiblockCoolantTankBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(fluidLightLevel)), 3);
        }
        if (!this.itemHandler.getStackInSlot(0).isEmpty() && this.itemHandler.getStackInSlot(1).isEmpty() && this.fakePlayer != null) {
            ItemStack stack = this.itemHandler.getStackInSlot(0);
            Item item = stack.getItem();
            FluidStack fluidStackFromBucket = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
            if (fluidStackFromBucket.isEmpty()) {
                ItemStack filledBucket;
                FluidStack fluidInTank = this.fluidHandler.getFluid();
                if (!fluidInTank.isEmpty() && fluidInTank.getAmount() >= 1000 && !(filledBucket = FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)this.fluidHandler, (int)1000, null, (boolean)true).getResult()).isEmpty()) {
                    this.itemHandler.extractItem(0, 1, false);
                    this.itemHandler.insertItem(1, filledBucket.copy(), false);
                }
            } else if (item instanceof BucketItem && this.fluidHandler.fill(fluidStackFromBucket, IFluidHandler.FluidAction.SIMULATE) > 0) {
                ItemStack emptyBucket = BucketItem.getEmptySuccessItem((ItemStack)stack, (Player)this.fakePlayer);
                this.itemHandler.extractItem(0, 1, false);
                this.itemHandler.insertItem(1, emptyBucket.copy(), false);
                this.fluidHandler.fill(fluidStackFromBucket, IFluidHandler.FluidAction.EXECUTE);
            }
        }
        this.sync();
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        compoundTag.put("fluidTank", (Tag)this.fluidHandler.writeToNBT(provider, new CompoundTag()));
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        this.fluidHandler.readFromNBT(provider, compoundTag.getCompound("fluidTank"));
        super.loadAdditional(compoundTag, provider);
    }

    public boolean onPlayerUse(Player player, InteractionHand hand) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.fluidHandler);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        FluidStack fluid = this.fluidHandler.getFluid();
        if (!fluid.isEmpty()) {
            builder.set(CastingDataComponents.FLUIDS, List.of(fluid.copy()));
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        List fluids = (List)input.get(CastingDataComponents.FLUIDS);
        if (fluids != null && !fluids.isEmpty()) {
            this.fluidHandler.setFluid(((FluidStack)fluids.getFirst()).copy());
        }
    }
}

