/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.block.multiblock;

import com.benbenlaw.casting.block.CastingBlockStateProperties;
import com.benbenlaw.casting.block.entity.CastingBlockEntities;
import com.benbenlaw.casting.block.entity.multiblock.MultiblockMixerBlockEntity;
import com.benbenlaw.casting.screen.multiblock.MultiblockMixerMenu;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiblockMixerBlock
extends BaseEntityBlock {
    public static final MapCodec<MultiblockMixerBlock> CODEC = MultiblockMixerBlock.simpleCodec(MultiblockMixerBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WORKING = CastingBlockStateProperties.WORKING;
    public static final BooleanProperty ENABLED = CastingBlockStateProperties.ENABLED;

    public MultiblockMixerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite())).setValue((Property)WORKING, (Comparable)Boolean.valueOf(false))).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(false));
    }

    @NotNull
    public BlockState rotate(BlockState blockState, Rotation pRotation) {
        return (BlockState)((BlockState)((BlockState)blockState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)blockState.getValue((Property)FACING)))).setValue((Property)WORKING, (Comparable)((Boolean)blockState.getValue((Property)WORKING)))).setValue((Property)ENABLED, (Comparable)((Boolean)blockState.getValue((Property)ENABLED)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, WORKING, ENABLED});
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (!level.isClientSide()) {
            MultiblockMixerBlockEntity multiblockMixerBlockEntity = (MultiblockMixerBlockEntity)level.getBlockEntity(blockPos);
            if (multiblockMixerBlockEntity instanceof MultiblockMixerBlockEntity) {
                if (multiblockMixerBlockEntity.onPlayerUse(player, InteractionHand.MAIN_HAND)) {
                    return InteractionResult.SUCCESS;
                }
                ContainerData data = multiblockMixerBlockEntity.data;
                player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new MultiblockMixerMenu(windowId, playerInventory, blockPos, data), (Component)Component.translatable((String)"block.casting.multiblock_mixer")), buf -> buf.writeBlockPos(blockPos));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new MultiblockMixerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        return MultiblockMixerBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)CastingBlockEntities.MULTIBLOCK_MIXER_BLOCK_ENTITY.get()), (world, blockPos, thisBlockState, blockEntity) -> blockEntity.tick());
    }
}

