/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.data;

import com.benbenlaw.casting.fluid.CastingFluids;
import com.benbenlaw.core.fluid.FluidDeferredRegister;
import com.benbenlaw.core.fluid.FluidRegistryObject;
import java.util.Map;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.level.block.LiquidBlock;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;

public class CastingLangProvider
extends LanguageProvider {
    public CastingLangProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "casting", "en_us");
    }

    protected void addTranslations() {
        this.add("itemGroup.casting", "Casting");
        this.addKeyTranslation("category", "Casting");
        this.addKeyTranslation("helmet_hotkey", "Toggle Helmet Modifiers");
        this.addKeyTranslation("chestplate_hotkey", "Toggle Chestplate Modifiers");
        this.addKeyTranslation("leggings_hotkey", "Toggle Leggings Modifiers");
        this.addKeyTranslation("boots_hotkey", "Toggle Boots Modifiers");
        this.addItemTranslation("black_brick", "Black Brick");
        this.addItemTranslation("fluid_mover", "Fluid Mover");
        this.addBlockTranslation("multiblock_controller", "Multiblock Controller (BETA)");
        this.addBlockTranslation("multiblock_fuel_tank", "Multiblock Fuel Tank (BETA)");
        this.addBlockTranslation("multiblock_coolant_tank", "Multiblock Coolant Tank (BETA)");
        this.addBlockTranslation("multiblock_solidifier", "Multiblock Solidifier (BETA)");
        this.addBlockTranslation("black_bricks", "Black Bricks");
        this.addBlockTranslation("black_brick_glass", "Black Brick Glass (BETA)");
        this.addBlockTranslation("multiblock_valve", "Multiblock Valve (BETA)");
        this.addBlockTranslation("multiblock_mixer", "Multiblock Mixer  (BETA)");
        this.addBlockTranslation("multiblock_regulator", "Multiblock Regulator (BETA)");
        this.addBlockTranslation("controller", "Simple Controller");
        this.addBlockTranslation("solidifier", "Simple Solidifier");
        this.addBlockTranslation("mixer", "Simple Mixer");
        this.addBlockTranslation("equipment_modifier", "Simple Equipment Modifier");
        this.addBlockTranslation("tank", "Simple Tank");
        this.addBlockTranslation("mixer_whisk", "Simple Mixer Whisk");
        this.addChatTranslation("multiblock_controller.no_valid_block", "No valid blocks found, must be exactly 2");
        this.addChatTranslation("multiblock_controller.only_one_valid_block", "Only one valid block found, must be exactly 2");
        this.addChatTranslation("multiblock_controller.too_many_valid_blocks", "Too many valid blocks found, must be exactly 2");
        this.addChatTranslation("multiblock_controller.item_spill", "Items will spill out the controller in 3 seconds unless multiblock is formed!");
        this.addChatTranslation("multiblock_controller.items_dropped", "Items dropped from the controller, multiblock not formed!");
        this.addChatTranslation("information.helmet_toggle", "- Toggling Helmet Modifiers");
        this.addChatTranslation("information.chestplate_toggle", "- Toggling Chestplate Modifiers");
        this.addChatTranslation("information.leggings_toggle", "- Toggling Leggings Modifiers");
        this.addChatTranslation("information.boots_toggle", "- Toggling Boots Modifiers");
        this.addGUITranslation("multiblock_controller.off", "Turn on the Multiblock at the top left of the GUI! If you can't see the button decrease your GUI scale!");
        this.addGUITranslation("multiblock_controller.no_fuel_tank", "No Fuel Tank Found!");
        this.addGUITranslation("multiblock_controller.no_controller", "No Controller Found!");
        this.addGUITranslation("buttons.no_off", "On/Off Button");
        this.addGUITranslation("buttons.fluid", "Filter: Empty, Click to cycle fluids");
        this.addGUITranslation("buttons.remove_fluid", "Filter: %s, Shift Click to remove filter");
        this.addGUITranslation("buttons.no_alloy", "Filter: Empty, Click to cycle");
        this.addGUITranslation("buttons.cycle_valid_alloy", "Filter: %s, Click to cycle, Found %s Alloys");
        this.addGUITranslation("buttons.not_hot_enough", "Current fuel not hot enough for at least one item");
        this.addGUITranslation("buttons.no_fuel", "No fuel found in fuel tank");
        this.addGUITranslation("buttons.not_enough_space", "Not enough space in main tank");
        this.addGUITranslation("buttons.multiblock_not_found", "Multiblock not formed, are there gaps in the structure?");
        this.addGUITranslation("buttons.waiting_for_recipe", "Ready to work!");
        this.addGUITranslation("buttons.filtering_disabled", "Filter: Disabled, Click to enable");
        this.addGUITranslation("buttons.filtering_enabled", "Filter: Enabled, Click to disable");
        this.addGUITranslation("buttons.dump_fluid", "Click to Dump Fluid!");
        this.addGUITranslation("buttons.shift_dump_fluid", "Hold Shift to Dump Fluid!");
        this.addGUITranslation("buttons.not_high_enough_level", "Equipment not high enough level to add this modifier!");
        this.addGUITranslation("buttons.at_max_level", "Equipment at Max Level for this modifier!");
        this.addGUITranslation("buttons.wrong_fluid", "Wrong Fluid in Tank!");
        this.addGUITranslation("buttons.not_enough_fluid", "Not Enough Fluid in Tank!");
        this.addGUITranslation("buttons.no_regulators", "No Regulators detected, add for reserving space!");
        this.addGUITranslation("buttons.regulator_count", "Tank Partitioned: %smb for %s fluids");
        this.addGUITranslation("buttons.output_full_mixer", "The output tank is full, unable to craft mixer result!");
        this.addGUITranslation("buttons.remove_fluid_right_click", "Filter: %s, Right Click to remove");
        this.addGUITranslation("jei.melting", "Melting");
        this.addGUITranslation("jei.melting_temp", "%s Min Temp");
        this.addGUITranslation("jei.mixing", "Mixing");
        this.addGUITranslation("jei.solidifier", "Solidifier");
        this.addGUITranslation("jei.fuel", "Fuels");
        this.addGUITranslation("jei.fuel_temp", "%s Fuel Temp");
        this.addGUITranslation("jei.fuel_speed", "%s ticks per recipe");
        this.addGUITranslation("jei.coolant", "Coolants");
        this.addGUITranslation("jei.coolant_speed", "%s ticks per recipe");
        this.addGUITranslation("jei.multiblock_controller_output", "%smB in Multiblock Controller");
        this.addGUITranslation("jei.simple_controller_output", "%smB in Simple Controller");
        this.addGUITranslation("jei.information.solidifier", "The Solidifier is used to turn your molten resource into useful item! \n\nThis can use an optional Fuel Tank adjacent to it, cooler fluids (below 1000) in the tank will make the Solidifier faster\n\nFluid can be locked to prevent another fluids from going in, click the lock button next to the fluid tank.\n\nHolding Shift whilst above the tank and left clicking will remove the fluid from the tank!\n\nStores fluids when broken!");
        this.addGUITranslation("jei.information.mixer", "The Mixer can be used to mix molten fluids together! \n\nHolding Shift whilst above a certain tank and left clicking will remove the fluid from the that tank!\n\nStores fluids when broken!");
        this.addGUITranslation("jei.information.controller", "The Controller can be used to melt items into their molten variants! \n\nThis needs a Fuel Tank to work. The Fuel Tank must contain a Fuel that is hot enough to melt the item, Hotter fluids melt faster\n\nHolding Shift whilst above a certain tank and left clicking will remove the fluid from the that tank!\n\nStores fluids when broken!");
        this.addGUITranslation("jei.information.tank", "The Tank stores the fuel used in the Controller to melt items!\n\nCan also be used with the Solidifier colder fluids in the tank makes the Solidifier faster \n\nStores fluids when broken!");
        this.addGUITranslation("jei.information.equipment_modifier", "Used to apply modifiers to your equipment!, Your first modifier will add Level 1 to your equipment additional modifiers require an additional level. Use your tools to Level Up and get more modifier slots.\n\nUsing a Repairing Mold will allow you to repair Equipment using its molten variants! \n\nSearch Equipment Modifiers in JEI to view the modifiers!\n\nPlace the right items and or fluids in the Equipment Modifier then add a valid piece of Equipment to add that effect!\n\nHolding Shift whilst above the tank and left clicking will remove the fluid from the tank!\n\nStores fluids when broken!");
        this.addGUITranslation("jei.information.fluid_mover", "Used to move fluids between tanks, Holds up to 8000mb of a single fluid. \n\nClick on a tank to collect fluid and click on another tank to add!\n\nWill try to fill the selected tank before collecting fluids!");
        this.addGUITranslation("jei.information.mixer_whisk", "Used to speed up the mixer when placed above it. \n\nFor each whisk above the mixer the tick rate is decreased by 40 ticks!\n\nAdditional whisks placed after the tick rate is at its lowest (20) will have no effect!");
        this.addItemTranslation("block_mold", "Block Mold");
        this.addItemTranslation("gear_mold", "Gear Mold");
        this.addItemTranslation("ingot_mold", "Ingot Mold");
        this.addItemTranslation("nugget_mold", "Nugget Mold");
        this.addItemTranslation("plate_mold", "Plate Mold");
        this.addItemTranslation("rod_mold", "Rod Mold");
        this.addItemTranslation("gem_mold", "Gem Mold");
        this.addItemTranslation("dust_mold", "Dust Mold");
        this.addItemTranslation("ball_mold", "Ball Mold");
        this.addItemTranslation("wire_mold", "Wire Mold");
        this.addItemTranslation("repairing_mold", "Repairing Mold");
        this.addItemTranslation("auto_smelt", "Equipment Modifier: Auto Smelt");
        this.addItemTranslation("beheading", "Equipment Modifier: Beheading");
        this.addItemTranslation("efficiency", "Equipment Modifier: Efficiency");
        this.addItemTranslation("excavation", "Equipment Modifier: Excavation");
        this.addItemTranslation("fortune", "Equipment Modifier: Fortune");
        this.addItemTranslation("ignite", "Equipment Modifier: Ignite");
        this.addItemTranslation("knockback", "Equipment Modifier: Knockback");
        this.addItemTranslation("lifesteal", "Equipment Modifier: Lifesteal");
        this.addItemTranslation("looting", "Equipment Modifier: Looting");
        this.addItemTranslation("magnet", "Equipment Modifier: Magnet");
        this.addItemTranslation("protection", "Equipment Modifier: Protection");
        this.addItemTranslation("repairing", "Equipment Modifier: Repairing");
        this.addItemTranslation("sharpness", "Equipment Modifier: Sharpness");
        this.addItemTranslation("silk_touch", "Equipment Modifier: Silk Touch");
        this.addItemTranslation("step_assist", "Equipment Modifier: Step Assist");
        this.addItemTranslation("teleporting", "Equipment Modifier: Teleporting");
        this.addItemTranslation("torch_placing", "Equipment Modifier: Torch Placing");
        this.addItemTranslation("unbreaking", "Equipment Modifier: Unbreaking");
        this.addItemTranslation("water_walker", "Equipment Modifier: Water Walker");
        this.addItemTranslation("lava_walker", "Equipment Modifier: Lava Walker");
        this.addItemTranslation("speed", "Equipment Modifier: Speed");
        this.addItemTranslation("water_breathing", "Equipment Modifier: Water Breathing");
        this.addItemTranslation("night_vision", "Equipment Modifier: Night Vision");
        this.addItemTranslation("flight", "Equipment Modifier: Flight");
        this.addItemTranslation("feather_falling", "Equipment Modifier: Feather Falling");
        this.addItemTranslation("soulbound", "Equipment Modifier: Soulbound");
        this.addItemTranslation("jets", "Equipment Modifier: Jets");
        this.addItemTranslation("equipment_level", "Equipment Modifier: Level Up");
        this.addTooltipTranslation("information.repairing_mold", "When used in the Equipment Modifier, this will allow you to repair your equipment using its molten variant!");
        this.addTooltipTranslation("information.valid_tool_types", "Valid Equipment;");
        this.addTooltipTranslation("information.shift_to_disable", "- Hold SHIFT to disable this modifier");
        this.addTooltipTranslation("information.shift_to_toggle", "- Hold SHIFT and Right Click to disable or enable this modifier");
        this.addTooltipTranslation("information.keybind_to_toggle", "- Press chosen keybind (see controls) to disable or enable this modifier");
        this.addTooltipTranslation("information.modifiers", "Modifiers - %s/%s");
        this.addTooltipTranslation("information.equipment_level", "Level up a piece of Equipment to add a new modifier slot up to level %s");
        this.addTooltipTranslation("information.equipment_level_item", "Gives your equipment a level, each level adds an additional modifier slot, up to %s levels");
        this.addTooltipTranslation("information.auto_smelt", "Allows the tool to automatically smelt items it mines up to level %s");
        this.addTooltipTranslation("information.beheading", "Gives a tool Beheading, drops mob heads");
        this.addTooltipTranslation("information.efficiency", "Gives a tool Efficiency up to level %s");
        this.addTooltipTranslation("information.excavation", "Gives a tool Excavation, allows the tool to mine a bigger area up to level %s");
        this.addTooltipTranslation("information.fortune", "Gives a tool Fortune up to level %s");
        this.addTooltipTranslation("information.ignite", "Gives a tool Ignite, ignites enemies on hit up to level %s");
        this.addTooltipTranslation("information.knockback", "Gives a tool Knockback up to level %s");
        this.addTooltipTranslation("information.lifesteal", "Gives a tool Lifesteal, restores health when damaging enemies up to level %s");
        this.addTooltipTranslation("information.looting", "Gives a tool Looting up to level %s");
        this.addTooltipTranslation("information.magnet", "Gives armor Magnet, attracts items to the player up to level %s, block drops also enter the player's inventory");
        this.addTooltipTranslation("information.protection", "Gives armor Protection up to level %s");
        this.addTooltipTranslation("information.repairing", "Gives a tool Repairing up to level %s");
        this.addTooltipTranslation("information.sharpness", "Gives a tool Sharpness up to level %s");
        this.addTooltipTranslation("information.silk_touch", "Gives a tool Silk Touch up to level %s");
        this.addTooltipTranslation("information.step_assist", "Gives armor Step Assist, allows the player to step up blocks up to level %s");
        this.addTooltipTranslation("information.teleporting", "Gives a tool Teleporting, allows the tool to teleport you to far away blocks up to level %s. Costs 5 durability per teleport");
        this.addTooltipTranslation("information.torch_placing", "Allows the tool to place torches on right click up to level %s");
        this.addTooltipTranslation("information.unbreaking", "Gives a tool Unbreaking up to level %s");
        this.addTooltipTranslation("information.water_walker", "Gives armor Water Walker, allows the player to walk on water up to level %s");
        this.addTooltipTranslation("information.lava_walker", "Gives armor Lava Walker, allows the player to walk on lava up to level %s");
        this.addTooltipTranslation("information.speed", "Gives armor Speed, allows the player to move faster up to level %s");
        this.addTooltipTranslation("information.water_breathing", "Gives armor Water Breathing, allows the player to breathe underwater");
        this.addTooltipTranslation("information.night_vision", "Gives armor Night Vision, allows the player to see in the dark");
        this.addTooltipTranslation("information.flight", "Gives armor Creative Flight");
        this.addTooltipTranslation("information.feather_falling", "Gives armor Feather Falling, each level adds 10%% damage reduction from falling up to level %s");
        this.addTooltipTranslation("information.soulbound", "Returns the item to the player after death");
        this.addTooltipTranslation("information.jets", "Gives armor Jets, allows the player to jet up in the air, up to level %s");
        this.addTooltipTranslation("stats.modifiers", "Modifiers - %s/%s");
        this.addTooltipTranslation("stats.equipment_level", "Equipment Level %s XP: %s/%s");
        this.addTooltipTranslation("stats.repairing_mold", "When inside the Equipment Modifier, this will allow you to repair your equipment using its molten variant!");
        this.addTooltipTranslation("stats.auto_smelt", "- Auto Smelt");
        this.addTooltipTranslation("stats.beheading", "- Beheading");
        this.addTooltipTranslation("stats.efficiency", "- Efficiency - %s");
        this.addTooltipTranslation("stats.excavation", "- Excavation - %s (%sx%s Area)");
        this.addTooltipTranslation("stats.fortune", "- Fortune - %s");
        this.addTooltipTranslation("stats.ignite", "- Ignite - Burn for %s Second(s)");
        this.addTooltipTranslation("stats.knockback", "- Knockback - %s");
        this.addTooltipTranslation("stats.lifesteal", "- Lifesteal - %s%% Damage Restored");
        this.addTooltipTranslation("stats.looting", "- Looting - %s");
        this.addTooltipTranslation("stats.magnet", "- Magnet - %s");
        this.addTooltipTranslation("stats.protection", "- Protection - %s");
        this.addTooltipTranslation("stats.repairing", "- Repairing - %s");
        this.addTooltipTranslation("stats.sharpness", "- Sharpness - %s (+%s Attack Damage)");
        this.addTooltipTranslation("stats.silk_touch", "- Silk Touch");
        this.addTooltipTranslation("stats.step_assist", "- Step Assist - %s");
        this.addTooltipTranslation("stats.teleporting", "- Teleporting - %s (%s Blocks)");
        this.addTooltipTranslation("stats.torch_placing", "- Torch Placing");
        this.addTooltipTranslation("stats.unbreaking", "- Unbreaking - %s");
        this.addTooltipTranslation("stats.water_walker", "- Water Walker");
        this.addTooltipTranslation("stats.lava_walker", "- Lava Walker");
        this.addTooltipTranslation("stats.speed", "- Speed - %s");
        this.addTooltipTranslation("stats.water_breathing", "- Water Breathing");
        this.addTooltipTranslation("stats.night_vision", "- Night Vision");
        this.addTooltipTranslation("stats.flight", "- Flight");
        this.addTooltipTranslation("stats.feather_falling", "- Feather Falling - %s");
        this.addTooltipTranslation("stats.soulbound", "- Soulbound");
        this.addTooltipTranslation("stats.jets", "- Jets - %s");
        this.addTooltipTranslation("all_modifiers", "- All");
        this.addTooltipTranslation("pickaxe_modifiers", "- Pickaxes");
        this.addTooltipTranslation("shovel_modifiers", "- Shovels");
        this.addTooltipTranslation("axe_modifiers", "- Axes");
        this.addTooltipTranslation("hoe_modifiers", "- Hoes");
        this.addTooltipTranslation("sword_modifiers", "- Swords");
        this.addTooltipTranslation("shear_modifiers", "- Shears");
        this.addTooltipTranslation("paxel_modifiers", "- Paxels");
        this.addTooltipTranslation("chestplate_modifiers", "- Chestplates");
        this.addTooltipTranslation("helmet_modifiers", "- Helmets");
        this.addTooltipTranslation("leggings_modifiers", "- Leggings");
        this.addTooltipTranslation("boots_modifiers", "- Boots");
        for (Map.Entry<String, FluidRegistryObject<FluidDeferredRegister.CoreFluidTypes, BaseFlowingFluid.Source, BaseFlowingFluid.Flowing, LiquidBlock, BucketItem>> entry : CastingFluids.FLUIDS_MAP.entrySet()) {
            String fluidName = entry.getKey();
            String fluidDisplayName = CastingLangProvider.capitalizeFirstLetterOfEachWord(fluidName);
            this.addBlockTranslation(fluidName, fluidDisplayName);
            this.addItemTranslation(fluidName + "_bucket", fluidDisplayName + " Bucket");
        }
    }

    private void addItemTranslation(String name, String translation) {
        this.add("item.casting." + name, translation);
    }

    private void addBlockTranslation(String name, String translation) {
        this.add("block.casting." + name, translation);
    }

    private void addChatTranslation(String name, String translation) {
        this.add("chat.casting." + name, translation);
    }

    private void addGUITranslation(String name, String translation) {
        this.add("gui.casting." + name, translation);
    }

    private void addTooltipTranslation(String name, String translation) {
        this.add("tooltips.casting." + name, translation);
    }

    private void addKeyTranslation(String name, String translation) {
        this.add("key.casting." + name, translation);
    }

    public static String capitalizeFirstLetterOfEachWord(String input) {
        String[] words = input.split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            result.append(word.substring(0, 1).toUpperCase()).append(word.substring(1).toLowerCase()).append(" ");
        }
        return result.toString().trim();
    }
}

