/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.event;

import com.benbenlaw.casting.config.EquipmentModifierConfig;
import com.benbenlaw.casting.item.EquipmentModifier;
import com.benbenlaw.casting.util.CastingTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="casting")
public class ArmorEvents {
    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        boolean isWaterBreathing;
        Player player = event.getEntity();
        Level level = player.level();
        if (level.isClientSide()) {
            return;
        }
        boolean isStepAssist = player.getItemBySlot(EquipmentSlot.FEET).getComponents().keySet().contains(EquipmentModifier.STEP_ASSIST.dataComponent.get());
        int totalSpeedLevel = 0;
        if (player.getItemBySlot(EquipmentSlot.FEET).getComponents().keySet().contains(EquipmentModifier.SPEED.dataComponent.get()) && ArmorEvents.isToggleableModifierActive(player.getItemBySlot(EquipmentSlot.FEET))) {
            totalSpeedLevel += ((Integer)player.getItemBySlot(EquipmentSlot.FEET).getComponents().getOrDefault((DataComponentType)EquipmentModifier.SPEED.dataComponent.get(), (Object)0)).intValue();
        }
        if (player.getItemBySlot(EquipmentSlot.LEGS).getComponents().keySet().contains(EquipmentModifier.SPEED.dataComponent.get()) && ArmorEvents.isToggleableModifierActive(player.getItemBySlot(EquipmentSlot.LEGS))) {
            totalSpeedLevel += ((Integer)player.getItemBySlot(EquipmentSlot.LEGS).getComponents().getOrDefault((DataComponentType)EquipmentModifier.SPEED.dataComponent.get(), (Object)0)).intValue();
        }
        if (totalSpeedLevel > 0) {
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 22, totalSpeedLevel, false, false));
        }
        if (isStepAssist && !player.isShiftKeyDown() && ArmorEvents.isToggleableModifierActive(player.getItemBySlot(EquipmentSlot.FEET))) {
            int stepAssistLevel = (Integer)player.getItemBySlot(EquipmentSlot.FEET).getComponents().getOrDefault((DataComponentType)EquipmentModifier.STEP_ASSIST.dataComponent.get(), (Object)0);
            Objects.requireNonNull(player.getAttribute(Attributes.STEP_HEIGHT)).setBaseValue((double)stepAssistLevel);
        } else {
            Objects.requireNonNull(player.getAttribute(Attributes.STEP_HEIGHT)).setBaseValue(0.6);
        }
        for (ItemStack armorItem : player.getArmorSlots()) {
            if (!armorItem.getComponents().keySet().contains(EquipmentModifier.MAGNET.dataComponent.get()) || !ArmorEvents.isToggleableModifierActive(armorItem)) continue;
            int range = (Integer)armorItem.getComponents().getOrDefault((DataComponentType)EquipmentModifier.MAGNET.dataComponent.get(), (Object)0);
            AABB box = player.getBoundingBox().inflate((double)range);
            List items = level.getEntitiesOfClass(ItemEntity.class, box, item -> !item.hasPickUpDelay() && item.getItem().getCount() > 0);
            for (ItemEntity itemEntity : items) {
                if (itemEntity.hasPickUpDelay()) continue;
                ItemStack stack = itemEntity.getItem();
                boolean success = player.getInventory().add(stack);
                if (success) {
                    itemEntity.remove(Entity.RemovalReason.DISCARDED);
                    if (!(level instanceof ServerLevel)) continue;
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), 10, 0.1, 0.1, 0.1, 0.1);
                    continue;
                }
                itemEntity.setItem(stack);
            }
        }
        boolean isNightVision = (Boolean)player.getItemBySlot(EquipmentSlot.HEAD).getOrDefault((DataComponentType)EquipmentModifier.NIGHT_VISION.dataComponent.get(), (Object)false);
        if (isNightVision && ArmorEvents.isToggleableModifierActive(player.getItemBySlot(EquipmentSlot.HEAD))) {
            player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 22, 0, false, false));
            int damageInterval = (Integer)EquipmentModifierConfig.timeForDamageOnNightVision.get();
            if (damageInterval > 0 && player.tickCount % damageInterval == 0) {
                player.getItemBySlot(EquipmentSlot.HEAD).hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.HEAD);
            }
        }
        if ((isWaterBreathing = ((Boolean)player.getItemBySlot(EquipmentSlot.HEAD).getOrDefault((DataComponentType)EquipmentModifier.WATER_BREATHING.dataComponent.get(), (Object)false)).booleanValue()) && player.isUnderWater()) {
            player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 22, 0, false, false));
            int damageInterval = (Integer)EquipmentModifierConfig.timeForDamageOnWaterBreathing.get();
            if (damageInterval > 0 && player.tickCount % damageInterval == 0) {
                player.getItemBySlot(EquipmentSlot.HEAD).hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.HEAD);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        boolean isLavaWalker;
        Player player = event.getEntity();
        Level level = player.level();
        if (!player.level().isClientSide()) {
            boolean isFlight = (Boolean)player.getItemBySlot(EquipmentSlot.CHEST).getOrDefault((DataComponentType)EquipmentModifier.FLIGHT.dataComponent.get(), (Object)false);
            if (isFlight && ArmorEvents.isToggleableModifierActive(player.getItemBySlot(EquipmentSlot.CHEST))) {
                if (!(player.isCreative() || player.isSpectator() || player.getAbilities().mayfly)) {
                    player.addTag("casting_flight");
                    player.getAbilities().mayfly = true;
                    player.onUpdateAbilities();
                }
            } else if (!player.isCreative() && !player.isSpectator() && player.getAbilities().mayfly && player.getTags().contains("casting_flight")) {
                player.removeTag("casting_flight");
                player.getAbilities().mayfly = false;
                player.onUpdateAbilities();
            }
        }
        boolean isWaterWalker = (Boolean)player.getItemBySlot(EquipmentSlot.FEET).getComponents().getOrDefault((DataComponentType)EquipmentModifier.WATER_WALKER.dataComponent.get(), (Object)false);
        float playerBob = player.bob;
        if (isWaterWalker && !player.isShiftKeyDown() && ArmorEvents.isToggleableModifierActive(player.getItemBySlot(EquipmentSlot.FEET))) {
            boolean isAtWaterSurface;
            BlockPos pos = player.blockPosition();
            BlockState currentBlock = level.getBlockState(pos);
            BlockState aboveBlock = level.getBlockState(pos.above());
            boolean bl = isAtWaterSurface = currentBlock.is(CastingTags.Blocks.EFFECTED_BY_WATER_WALKER) && !aboveBlock.is(CastingTags.Blocks.EFFECTED_BY_WATER_WALKER);
            if (isAtWaterSurface) {
                double surfaceY = (double)pos.getY() + 1.0;
                double playerY = player.getY();
                double desiredNewY = playerY + (surfaceY - playerY) * 0.1;
                AABB futureBox = player.getBoundingBox().move(0.0, desiredNewY - playerY, 0.0);
                if (!level.noCollision(futureBox)) {
                    AABB testBox;
                    double step = 0.05;
                    double maxSafeY = playerY;
                    for (double testY = playerY; testY <= surfaceY && level.noCollision(testBox = player.getBoundingBox().move(0.0, testY - playerY, 0.0)); testY += step) {
                        maxSafeY = testY;
                    }
                    player.setPos(player.getX(), maxSafeY, player.getZ());
                    player.setDeltaMovement(player.getDeltaMovement().x, 0.0, player.getDeltaMovement().z);
                    if (maxSafeY >= surfaceY - 0.5) {
                        player.setOnGround(true);
                    }
                    return;
                }
                player.setPos(player.getX(), desiredNewY, player.getZ());
                boolean isBob = false;
                if (desiredNewY >= surfaceY - 0.5 && desiredNewY < surfaceY) {
                    isBob = true;
                    player.setDeltaMovement(player.getDeltaMovement().x, 0.0, player.getDeltaMovement().z);
                    player.setOnGround(true);
                }
                if (isBob) {
                    float f = Math.min(0.1f, (float)player.getDeltaMovement().horizontalDistance());
                    playerBob += (f - playerBob) * 0.7f;
                    player.bob = playerBob;
                }
            }
        }
        if ((isLavaWalker = ((Boolean)player.getItemBySlot(EquipmentSlot.FEET).getComponents().getOrDefault((DataComponentType)EquipmentModifier.LAVA_WALKER.dataComponent.get(), (Object)false)).booleanValue()) && !player.isShiftKeyDown() && ArmorEvents.isToggleableModifierActive(player.getItemBySlot(EquipmentSlot.FEET))) {
            boolean isAtLavaSurface;
            BlockPos pos = player.blockPosition();
            EquipmentSlot[] currentBlock = level.getBlockState(pos);
            BlockState aboveBlock = level.getBlockState(pos.above());
            boolean bl = isAtLavaSurface = currentBlock.is(CastingTags.Blocks.EFFECTED_BY_LAVA_WALKER) && !aboveBlock.is(CastingTags.Blocks.EFFECTED_BY_LAVA_WALKER);
            if (isAtLavaSurface) {
                double surfaceY = (double)pos.getY() + 1.0;
                double playerY = player.getY();
                double desiredNewY = playerY + (surfaceY - playerY) * 0.1;
                AABB futureBox = player.getBoundingBox().move(0.0, desiredNewY - playerY, 0.0);
                if (!level.noCollision(futureBox)) {
                    AABB testBox;
                    double step = 0.05;
                    double maxSafeY = playerY;
                    for (double testY = playerY; testY <= surfaceY && level.noCollision(testBox = player.getBoundingBox().move(0.0, testY - playerY, 0.0)); testY += step) {
                        maxSafeY = testY;
                    }
                    player.setPos(player.getX(), maxSafeY, player.getZ());
                    player.setDeltaMovement(player.getDeltaMovement().x, 0.0, player.getDeltaMovement().z);
                    if (maxSafeY >= surfaceY - 0.5) {
                        player.setOnGround(true);
                    }
                    return;
                }
                player.setPos(player.getX(), desiredNewY, player.getZ());
                boolean isBob = false;
                if (desiredNewY >= surfaceY - 0.5 && desiredNewY < surfaceY) {
                    isBob = true;
                    player.setDeltaMovement(player.getDeltaMovement().x, 0.0, player.getDeltaMovement().z);
                    player.setOnGround(true);
                }
                if (isBob) {
                    float f = Math.min(0.1f, (float)player.getDeltaMovement().horizontalDistance());
                    playerBob += (f - playerBob) * 0.7f;
                    player.bob = playerBob;
                }
            }
        }
        int totalJetLevel = 0;
        for (EquipmentSlot slot : new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD}) {
            ItemStack armorPiece = player.getItemBySlot(slot);
            if (!armorPiece.getComponents().has((DataComponentType)EquipmentModifier.JETS.dataComponent.get()) || !ArmorEvents.isToggleableModifierActive(armorPiece)) continue;
            totalJetLevel += ((Integer)armorPiece.getComponents().getOrDefault((DataComponentType)EquipmentModifier.JETS.dataComponent.get(), (Object)0)).intValue();
        }
        boolean jumpHeld = player.getPersistentData().getBoolean("casting_is_jumping");
        if (totalJetLevel > 0 && jumpHeld && !player.isInWaterOrBubble()) {
            int damageInterval;
            player.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 1, totalJetLevel, false, false));
            player.setOnGround(false);
            player.fallDistance = 0.0f;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, player.getX(), player.getY() + 0.25, player.getZ(), 5, 0.2, 0.2, 0.2, 0.001);
            }
            if ((damageInterval = ((Integer)EquipmentModifierConfig.timeForDamageOnJets.get()).intValue()) > 0 && player.tickCount % damageInterval == 0) {
                ArrayList<EquipmentSlot> damagedSlots = new ArrayList<EquipmentSlot>();
                for (EquipmentSlot slot : new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD}) {
                    ItemStack armorPiece = player.getItemBySlot(slot);
                    if (!armorPiece.getComponents().has((DataComponentType)EquipmentModifier.JETS.dataComponent.get()) || !ArmorEvents.isToggleableModifierActive(armorPiece)) continue;
                    damagedSlots.add(slot);
                }
                if (!damagedSlots.isEmpty()) {
                    EquipmentSlot slotToDamage = (EquipmentSlot)damagedSlots.get(player.getRandom().nextInt(damagedSlots.size()));
                    ItemStack armorPiece = player.getItemBySlot(slotToDamage);
                    armorPiece.hurtAndBreak(1, (LivingEntity)player, slotToDamage);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDamage(LivingDamageEvent.Pre event) {
        ItemStack boots;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.level().isClientSide()) {
            return;
        }
        float originalDamage = event.getOriginalDamage();
        DamageSource source = event.getSource();
        int armorValue = player.getArmorValue();
        float armorToughness = (float)player.getAttributeValue(Attributes.ARMOR_TOUGHNESS);
        float damageAfterArmor = CombatRules.getDamageAfterAbsorb((LivingEntity)player, (float)originalDamage, (DamageSource)source, (float)armorValue, (float)armorToughness);
        float totalCustomReduction = 0.0f;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack armor;
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR || (armor = player.getItemBySlot(slot)).isEmpty() || !armor.getComponents().has((DataComponentType)EquipmentModifier.PROTECTION.dataComponent.get())) continue;
            int protectionLevel = (Integer)armor.getComponents().getOrDefault((DataComponentType)EquipmentModifier.PROTECTION.dataComponent.get(), (Object)0);
            totalCustomReduction += (float)protectionLevel * ((Float)EquipmentModifierConfig.percentageOfProtectionDamagePerProtectionLevel.get()).floatValue();
        }
        totalCustomReduction = Math.min(totalCustomReduction, 0.8f);
        float finalDamage = damageAfterArmor * (1.0f - totalCustomReduction);
        if (event.getSource().is(DamageTypes.FALL) && !(boots = player.getItemBySlot(EquipmentSlot.FEET)).isEmpty() && boots.getComponents().keySet().contains(EquipmentModifier.FEATHER_FALLING.dataComponent.get())) {
            int featherFallingLevel = (Integer)boots.getComponents().getOrDefault((DataComponentType)EquipmentModifier.FEATHER_FALLING.dataComponent.get(), (Object)0);
            float fallReduction = (float)featherFallingLevel * 0.1f;
            fallReduction = Math.min(fallReduction, 0.8f);
            finalDamage *= 1.0f - fallReduction;
            boots.hurtAndBreak(featherFallingLevel, (LivingEntity)player, EquipmentSlot.FEET);
        }
        event.setNewDamage(finalDamage);
    }

    public static boolean isToggleableModifierActive(ItemStack tool) {
        if (!tool.getComponents().has((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get())) {
            return true;
        }
        if (tool.getComponents().keySet().contains(EquipmentModifier.TOGGLEABLE_MODIFIERS.get())) {
            if (Boolean.TRUE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                return true;
            }
            if (Boolean.FALSE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                return false;
            }
        }
        return false;
    }
}

