/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.integration.jei;

import com.benbenlaw.casting.block.CastingBlocks;
import com.benbenlaw.casting.integration.jei.JEICastingPlugin;
import com.benbenlaw.casting.recipe.MixingRecipe;
import com.benbenlaw.core.recipe.NoInventoryRecipe;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MixingRecipeCategory
implements IRecipeCategory<MixingRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"mixing");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"textures/gui/jei_mixer.png");
    public static final RecipeType<MixingRecipe> RECIPE_TYPE = RecipeType.create((String)"casting", (String)"mixing", MixingRecipe.class);
    private IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper helper;

    public MixingRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(TEXTURE, 0, 0, 159, 38);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CastingBlocks.MULTIBLOCK_MIXER.get()));
    }

    @NotNull
    public RecipeType<MixingRecipe> getRecipeType() {
        return JEICastingPlugin.MIXER_RECIPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"gui.casting.jei.mixing");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nullable
    public ResourceLocation getRegistryName(MixingRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)MixingRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((MixingRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, MixingRecipe recipe, @NotNull IFocusGroup focusGroup) {
        ClientLevel level = Minecraft.getInstance().level;
        List recipeHolder = level.getRecipeManager().getRecipesFor((net.minecraft.world.item.crafting.RecipeType)MixingRecipe.Type.INSTANCE, (RecipeInput)NoInventoryRecipe.INSTANCE, (Level)level);
        int size = recipe.fluids().size();
        int centerX = size > 0 ? 1 : 10;
        int centerY = size > 6 ? 2 : 11;
        int xOffset = 0;
        int yOffset = 0;
        int index = 0;
        for (int i = 0; i < size; ++i) {
            xOffset = centerX + i % 6 * 18;
            yOffset = centerY + i / 6 * 18;
            int finalIndex = index = i;
            builder.addSlot(RecipeIngredientRole.INPUT, 3 + xOffset, yOffset).addFluidStack(recipe.getAllFluids().get(i).getFluid(), (long)recipe.getAllFluids().get(finalIndex).getAmount()).addRichTooltipCallback((slot, tooltip) -> tooltip.add((FormattedText)Component.literal((String)(recipe.getAllFluids().get(finalIndex).getAmount() + " mB")).withStyle(ChatFormatting.GOLD))).setBackground((IDrawable)JEICastingPlugin.slotDrawable, -1, -1);
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 3 + xOffset, yOffset).addFluidStack(recipe.getAllFluids().get(i).getFluid(), 1000L);
        }
        FluidStack output = recipe.outputFluid().copy();
        if (!output.isEmpty()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 140, 11).addFluidStack(output.getFluid(), (long)output.getAmount()).addRichTooltipCallback((slot, tooltip) -> tooltip.add((FormattedText)Component.literal((String)(output.getAmount() + " mB")).withStyle(ChatFormatting.GOLD)));
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 140, 11).addFluidStack(output.getFluid(), 1000L);
        }
    }
}

