/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public record MeltingRecipe(SizedIngredient input, FluidStack output, int meltingTemp) implements Recipe<RecipeInput>
{
    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.createWithCapacity((int)1);
        ingredients.add((Object)this.input.ingredient());
        return ingredients;
    }

    public boolean matches(@NotNull RecipeInput container, @NotNull Level level) {
        for (int i = 0; i < 15; ++i) {
            if (!this.input.test(container.getItem(i))) continue;
            return true;
        }
        return false;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput container, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public int getMeltingTemp() {
        return this.meltingTemp;
    }

    public int getIngredientStackCount() {
        return this.input.count();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<MeltingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<MeltingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SizedIngredient.FLAT_CODEC.fieldOf("input").forGetter(MeltingRecipe::input), (App)FluidStack.CODEC.fieldOf("output").forGetter(MeltingRecipe::output), (App)Codec.INT.fieldOf("meltingTemp").forGetter(MeltingRecipe::meltingTemp)).apply((Applicative)instance, Serializer::createMeltingRecipe));
        private static final StreamCodec<RegistryFriendlyByteBuf, MeltingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<MeltingRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, MeltingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static MeltingRecipe read(RegistryFriendlyByteBuf buffer) {
            SizedIngredient input = (SizedIngredient)SizedIngredient.STREAM_CODEC.decode((Object)buffer);
            FluidStack output = (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buffer);
            int meltingTemp = buffer.readInt();
            return new MeltingRecipe(input, output, meltingTemp);
        }

        private static void write(RegistryFriendlyByteBuf buffer, MeltingRecipe recipe) {
            SizedIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            FluidStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            buffer.writeInt(recipe.meltingTemp);
        }

        static MeltingRecipe createMeltingRecipe(SizedIngredient input, FluidStack output, int duration) {
            return new MeltingRecipe(input, output, duration);
        }
    }

    public static class Type
    implements RecipeType<MeltingRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

