/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.screen.multiblock;

import com.benbenlaw.casting.block.multiblock.MultiblockMixerBlock;
import com.benbenlaw.casting.network.payload.MixerSelectedFluidPayload;
import com.benbenlaw.casting.network.payload.OnOffButtonPayload;
import com.benbenlaw.casting.screen.multiblock.MultiblockMixerMenu;
import com.benbenlaw.casting.screen.util.MultiFluidStackWidget;
import com.benbenlaw.core.screen.util.CoreButtons;
import com.benbenlaw.core.util.MouseUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.network.PacketDistributor;

public class MultiblockMixerScreen
extends AbstractContainerScreen<MultiblockMixerMenu> {
    private Level level;
    private BlockEntity mixerEntity;
    private int selectedFluidIndex = 0;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"textures/gui/multiblock_mixer_gui.png");

    public MultiblockMixerScreen(MultiblockMixerMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.level = menu.level;
    }

    protected void init() {
        super.init();
        this.addFluidWidgets();
        this.addMenuButtons();
    }

    protected void containerTick() {
        this.clearWidgets();
        this.addFluidWidgets();
        this.addMenuButtons();
    }

    private void addFluidWidgets() {
        if (((MultiblockMixerMenu)this.getMenu()).blockEntity.controller != null) {
            this.addRenderableOnly((Renderable)new MultiFluidStackWidget((Screen)this, ((MultiblockMixerMenu)this.getMenu()).blockEntity.controller.fluidHandler, this.leftPos + 71, this.topPos + 21, 34, 45));
        }
    }

    private void renderNoControllerTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (((MultiblockMixerMenu)this.menu).blockEntity.controller == null && MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)(this.leftPos + 71), (int)(this.topPos + 21), (int)0, (int)-1, (int)34, (int)45)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.casting.multiblock_controller.no_controller"), mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = this.leftPos;
        int y = this.topPos;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.renderBucket(guiGraphics, mouseX, mouseY, x, y);
        guiGraphics.blit(TEXTURE, x + 21, y - 17, 177, 53, 20, 18);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderNoControllerTooltip(guiGraphics, mouseX, mouseY, x, y);
        this.renderSlotTooltips(guiGraphics, mouseX, mouseY, x, y);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean handled = super.mouseClicked(mouseX, mouseY, mouseButton);
        int widgetWidth = 34;
        int widgetHeight = 46;
        if (((MultiblockMixerMenu)this.menu).blockEntity.controller != null && MouseUtil.isMouseAboveArea((int)((int)mouseX), (int)((int)mouseY), (int)(this.leftPos + 20), (int)(this.topPos - 17), (int)0, (int)0, (int)widgetWidth, (int)widgetHeight)) {
            List<String> availableAlloys = ((MultiblockMixerMenu)this.menu).blockEntity.availableAlloys;
            if (MultiblockMixerScreen.hasShiftDown()) {
                this.selectedFluidIndex = 0;
                PacketDistributor.sendToServer((CustomPacketPayload)new MixerSelectedFluidPayload("minecraft:empty", ((MultiblockMixerMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (!availableAlloys.isEmpty()) {
                if (mouseButton == 0) {
                    this.selectedFluidIndex = (this.selectedFluidIndex + 1) % availableAlloys.size();
                    String selectedFluid = availableAlloys.get(this.selectedFluidIndex);
                    PacketDistributor.sendToServer((CustomPacketPayload)new MixerSelectedFluidPayload(selectedFluid, ((MultiblockMixerMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else if (mouseButton == 1) {
                    this.selectedFluidIndex = (this.selectedFluidIndex - 1 + availableAlloys.size()) % availableAlloys.size();
                    String selectedFluid = availableAlloys.get(this.selectedFluidIndex);
                    PacketDistributor.sendToServer((CustomPacketPayload)new MixerSelectedFluidPayload(selectedFluid, ((MultiblockMixerMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
        return handled;
    }

    private void renderBucket(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        String selectedFluid = ((MultiblockMixerMenu)this.menu).blockEntity.selectedFluidString;
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)selectedFluid));
        ItemStack bucketOfFluid = new ItemStack((ItemLike)fluid.getBucket());
        if (bucketOfFluid.isEmpty()) {
            guiGraphics.renderItem(new ItemStack((ItemLike)Items.BUCKET), x + 22, y - 16);
        } else {
            guiGraphics.renderItem(bucketOfFluid, x + 22, y - 16);
        }
    }

    private void renderSlotTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)0, (int)-17, (int)19, (int)18)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.casting.buttons.no_off"), mouseX, mouseY);
        }
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)20, (int)-17, (int)19, (int)18)) {
            String selectedFluid = ((MultiblockMixerMenu)this.menu).blockEntity.selectedFluidString;
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)selectedFluid));
            ItemStack bucketOfFluid = new ItemStack((ItemLike)fluid.getBucket());
            String bucketName = bucketOfFluid.getHoverName().getString();
            Component fluidName = Component.nullToEmpty((String)bucketName.replace(" Bucket", ""));
            if (fluidName.contains(Component.nullToEmpty((String)"Air"))) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.casting.buttons.no_alloy"), mouseX, mouseY);
            } else {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.casting.buttons.cycle_valid_alloy", (Object[])new Object[]{fluidName, ((MultiblockMixerMenu)this.menu).blockEntity.availableAlloys.size()}), mouseX, mouseY);
            }
        }
    }

    private void addMenuButtons() {
        int buttonX = this.leftPos;
        int buttonY = this.topPos - 17;
        if (((MultiblockMixerMenu)this.menu).blockEntity != null) {
            WidgetSprites buttonTexture = (Boolean)((MultiblockMixerMenu)this.menu).blockEntity.getBlockState().getValue((Property)MultiblockMixerBlock.ENABLED) != false ? CoreButtons.ON_BUTTONS : CoreButtons.OFF_BUTTONS;
            this.addRenderableWidget((GuiEventListener)new ImageButton(buttonX, buttonY, 20, 18, buttonTexture, pressed -> PacketDistributor.sendToServer((CustomPacketPayload)new OnOffButtonPayload(((MultiblockMixerMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0])));
        }
    }
}

