/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.screen.multiblock;

import com.benbenlaw.casting.block.multiblock.MultiblockSolidifierBlock;
import com.benbenlaw.casting.network.payload.OnOffButtonPayload;
import com.benbenlaw.casting.network.payload.SolidifierSelectedFluidPayload;
import com.benbenlaw.casting.screen.multiblock.MultiblockSolidifierMenu;
import com.benbenlaw.casting.screen.util.FluidStackStackWidget;
import com.benbenlaw.casting.screen.util.MultiFluidStackWidget;
import com.benbenlaw.core.screen.util.CoreButtons;
import com.benbenlaw.core.util.MouseUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class MultiblockSolidifierScreen
extends AbstractContainerScreen<MultiblockSolidifierMenu> {
    private Level level;
    private BlockEntity fuelTankEntity;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"textures/gui/multiblock_solidifier_gui.png");
    private int selectedFluidIndex = 0;

    public MultiblockSolidifierScreen(MultiblockSolidifierMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.level = menu.level;
    }

    protected void init() {
        super.init();
        this.addFluidWidgets();
        this.addMenuButtons();
    }

    protected void containerTick() {
        this.clearWidgets();
        this.addFluidWidgets();
        this.addMenuButtons();
    }

    private void addFluidWidgets() {
        if (((MultiblockSolidifierMenu)this.getMenu()).blockEntity.controller != null) {
            this.addRenderableOnly((Renderable)new MultiFluidStackWidget((Screen)this, ((MultiblockSolidifierMenu)this.getMenu()).blockEntity.controller.fluidHandler, this.leftPos + 35, this.topPos + 21, 34, 45));
        }
        if (((MultiblockSolidifierMenu)this.getMenu()).blockEntity.coolantTank != null) {
            this.addRenderableOnly((Renderable)new FluidStackStackWidget((Screen)this, ((MultiblockSolidifierMenu)this.getMenu()).blockEntity.coolantTank, this.leftPos + 8, this.topPos + 21, 16, 45));
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        this.renderProgressBars(guiGraphics);
        int x = this.leftPos;
        int y = this.topPos;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        guiGraphics.blit(TEXTURE, x + 21, y - 17, 177, 35, 20, 18);
        this.renderBucket(guiGraphics, mouseX, mouseY, x, y);
        guiGraphics.blit(TEXTURE, x + 41, y - 17, 177, 53, 20, 18);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderProgressBars(guiGraphics);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderNoControllerTooltip(guiGraphics, mouseX, mouseY, x, y);
        this.renderSlotTooltips(guiGraphics, mouseX, mouseY, x, y);
    }

    private void renderNoControllerTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (((MultiblockSolidifierMenu)this.menu).blockEntity.controller == null && MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)(this.leftPos + 35), (int)(this.topPos + 21), (int)0, (int)-1, (int)34, (int)45)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.casting.multiblock_controller.no_controller"), mouseX, mouseY);
        }
    }

    private void renderProgressBars(GuiGraphics guiGraphics) {
        int x = this.leftPos;
        int y = this.topPos;
        guiGraphics.blit(TEXTURE, x + 121, y + 35, 176, 0, ((MultiblockSolidifierMenu)this.menu).getScaledProgress(), 16);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean handled = super.mouseClicked(mouseX, mouseY, mouseButton);
        int widgetWidth = 34;
        int widgetHeight = 45;
        if (MouseUtil.isMouseAboveArea((int)((int)mouseX), (int)((int)mouseY), (int)(this.leftPos + 41), (int)(this.topPos - 17), (int)0, (int)0, (int)widgetWidth, (int)widgetHeight)) {
            List<FluidStack> fluids = ((MultiblockSolidifierMenu)this.menu).blockEntity.controller.fluidHandler.getFluids();
            if (MultiblockSolidifierScreen.hasShiftDown()) {
                this.selectedFluidIndex = 0;
                PacketDistributor.sendToServer((CustomPacketPayload)new SolidifierSelectedFluidPayload("minecraft:empty", ((MultiblockSolidifierMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (!fluids.isEmpty()) {
                if (mouseButton == 0) {
                    this.selectedFluidIndex = (this.selectedFluidIndex + 1) % fluids.size();
                    String selectedFluid = fluids.get(this.selectedFluidIndex).getFluid().toString();
                    PacketDistributor.sendToServer((CustomPacketPayload)new SolidifierSelectedFluidPayload(selectedFluid, ((MultiblockSolidifierMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else if (mouseButton == 1) {
                    this.selectedFluidIndex = (this.selectedFluidIndex - 1 + fluids.size()) % fluids.size();
                    String selectedFluid = fluids.get(this.selectedFluidIndex).getFluid().toString();
                    PacketDistributor.sendToServer((CustomPacketPayload)new SolidifierSelectedFluidPayload(selectedFluid, ((MultiblockSolidifierMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
        return handled;
    }

    private void renderSlotTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)0, (int)-17, (int)19, (int)18)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.casting.buttons.no_off"), mouseX, mouseY);
        }
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)20, (int)-17, (int)19, (int)18)) {
            String progressInfo = ((MultiblockSolidifierMenu)this.menu).blockEntity.progress + "/" + ((MultiblockSolidifierMenu)this.menu).blockEntity.maxProgress;
            if (progressInfo.equals("0/0")) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.casting.buttons.waiting_for_recipe"), mouseX, mouseY);
            } else {
                guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)(((MultiblockSolidifierMenu)this.menu).blockEntity.progress + "/" + ((MultiblockSolidifierMenu)this.menu).blockEntity.maxProgress)), mouseX, mouseY);
            }
        }
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)40, (int)-17, (int)19, (int)18)) {
            String selectedFluid = ((MultiblockSolidifierMenu)this.menu).blockEntity.selectedFluidString;
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)selectedFluid));
            ItemStack bucketOfFluid = new ItemStack((ItemLike)fluid.getBucket());
            String bucketName = bucketOfFluid.getHoverName().getString();
            Component fluidName = Component.nullToEmpty((String)bucketName.replace(" Bucket", ""));
            if (fluidName.contains(Component.nullToEmpty((String)"Air"))) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.casting.buttons.fluid"), mouseX, mouseY);
            } else {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.casting.buttons.remove_fluid_right_click", (Object[])new Object[]{fluidName}), mouseX, mouseY);
            }
        }
    }

    private void renderBucket(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        String selectedFluid = ((MultiblockSolidifierMenu)this.menu).blockEntity.selectedFluidString;
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)selectedFluid));
        ItemStack bucketOfFluid = new ItemStack((ItemLike)fluid.getBucket());
        if (bucketOfFluid.isEmpty()) {
            guiGraphics.renderItem(new ItemStack((ItemLike)Items.BUCKET), x + 42, y - 16);
        } else {
            guiGraphics.renderItem(bucketOfFluid, x + 42, y - 16);
        }
    }

    private void addMenuButtons() {
        int buttonX = this.leftPos;
        int buttonY = this.topPos - 17;
        if (((MultiblockSolidifierMenu)this.menu).blockEntity != null) {
            WidgetSprites buttonTexture = (Boolean)((MultiblockSolidifierMenu)this.menu).blockEntity.getBlockState().getValue((Property)MultiblockSolidifierBlock.ENABLED) != false ? CoreButtons.ON_BUTTONS : CoreButtons.OFF_BUTTONS;
            this.addRenderableWidget((GuiEventListener)new ImageButton(buttonX, buttonY, 20, 18, buttonTexture, pressed -> PacketDistributor.sendToServer((CustomPacketPayload)new OnOffButtonPayload(((MultiblockSolidifierMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0])));
        }
    }
}

