/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.config;

import com.benbenlaw.casting.item.EquipmentModifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ModifierSetsConfig {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static ModConfigSpec.ConfigValue<List<? extends String>> CUSTOM_MODIFIER_SETS;
    public static ModConfigSpec.ConfigValue<Boolean> DISABLE_ALL_DEFAULT_MODIFIER_SETS;
    private static final Map<String, String> GROUP_DISPLAY_NAMES;
    public static final Map<String, List<String>> GROUP_ITEMS_OR_TAGS;

    public static Map<String, List<EquipmentModifier>> getCustomModifierGroups() {
        HashMap<String, List<EquipmentModifier>> groups = new HashMap<String, List<EquipmentModifier>>();
        GROUP_DISPLAY_NAMES.clear();
        GROUP_ITEMS_OR_TAGS.clear();
        for (String entry : (List)CUSTOM_MODIFIER_SETS.get()) {
            String[] parts = entry.split("=", 2);
            if (parts.length != 2) {
                System.err.println("[ModifierSetsConfig] Invalid entry: " + entry);
                continue;
            }
            String[] groupAndName = parts[0].split("\\|", 2);
            String groupKey = groupAndName[0].trim();
            String displayName = groupAndName.length > 1 ? groupAndName[1].trim() : groupKey;
            String[] modifierAndItems = parts[1].split(";", 2);
            String modifierPart = modifierAndItems[0].trim();
            String itemsPart = modifierAndItems.length > 1 ? modifierAndItems[1].trim() : "";
            String[] modifierNames = modifierPart.split(",");
            List modifiers = Arrays.stream(modifierNames).map(String::trim).map(ModifierSetsConfig::getModifierByName).filter(Objects::nonNull).collect(Collectors.toList());
            List applicableItemsOrTags = itemsPart.isEmpty() ? Collections.emptyList() : Arrays.stream(itemsPart.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            groups.put(groupKey, modifiers);
            GROUP_DISPLAY_NAMES.put(groupKey, displayName);
            GROUP_ITEMS_OR_TAGS.put(groupKey, applicableItemsOrTags);
        }
        return groups;
    }

    public static String getDisplayNameForGroup(String groupKey) {
        return GROUP_DISPLAY_NAMES.getOrDefault(groupKey, groupKey);
    }

    public static List<String> getItemsOrTagsForGroup(String groupKey) {
        return GROUP_ITEMS_OR_TAGS.getOrDefault(groupKey, Collections.emptyList());
    }

    private static EquipmentModifier getModifierByName(String name) {
        try {
            return EquipmentModifier.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            System.err.println("[ModifierSetsConfig] Unknown modifier name: " + name);
            return null;
        }
    }

    static {
        GROUP_DISPLAY_NAMES = new HashMap<String, String>();
        GROUP_ITEMS_OR_TAGS = new HashMap<String, List<String>>();
        BUILDER.comment("Custom Modifier Sets Config").push("Modifier Sets");
        DISABLE_ALL_DEFAULT_MODIFIER_SETS = BUILDER.comment("Disable all default modifier sets,...\nIf enabled, only custom modifier sets defined below will be used.").define("disable_all_default_modifier_sets", false);
        CUSTOM_MODIFIER_SETS = BUILDER.comment("Define custom modifier groups as groupKey|displayName=MODIFIER1,MODIFIER2,...;item1,item2,#tag1,...\nExample: diamond|Diamond Tools=EFFICIENCY,SILK_TOUCH,TORCH_PLACING;minecraft:diamond,#minecraft:planks \nThis defines a group 'diamond' with display name 'Diamond Tools' containing modifiers EFFICIENCY, SILK_TOUCH, TORCH_PLACING\nand applicable items 'minecraft:diamond' and all items with tag 'minecraft:planks'").defineListAllowEmpty(List.of("modifier_groups"), Collections.emptyList(), obj -> obj instanceof String && ((String)obj).contains("="));
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

