/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.event.client;

import com.benbenlaw.casting.config.EquipmentModifierConfig;
import com.benbenlaw.casting.item.CastingItems;
import com.benbenlaw.casting.item.EquipmentModifier;
import com.benbenlaw.casting.util.EquipmentModifierUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="casting", value={Dist.CLIENT})
public class EquipmentModifiersTooltip {
    @SubscribeEvent
    public static void addRepairingMoldTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.is((Item)CastingItems.REPAIRING_MOLD.get())) {
            if (Screen.hasShiftDown()) {
                event.getToolTip().add(Component.translatable((String)"tooltips.casting.stats.repairing_mold").withStyle(ChatFormatting.YELLOW));
            } else {
                event.getToolTip().add(Component.translatable((String)"tooltips.bblcore.shift").withStyle(ChatFormatting.YELLOW));
            }
        }
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        boolean hasEffects;
        ItemStack tool = event.getItemStack();
        List components = event.getToolTip();
        boolean hasEquipmentLevel = tool.getComponents().keySet().contains(EquipmentModifier.EQUIPMENT_LEVEL.dataComponent.get());
        boolean hasSilkTouch = tool.getComponents().keySet().contains(EquipmentModifier.SILK_TOUCH.dataComponent.get());
        boolean hasEfficiency = tool.getComponents().keySet().contains(EquipmentModifier.EFFICIENCY.dataComponent.get());
        boolean hasFortune = tool.getComponents().keySet().contains(EquipmentModifier.FORTUNE.dataComponent.get());
        boolean hasUnbreaking = tool.getComponents().keySet().contains(EquipmentModifier.UNBREAKING.dataComponent.get());
        boolean hasRepairing = tool.getComponents().keySet().contains(EquipmentModifier.REPAIRING.dataComponent.get());
        boolean hasTorchPlacing = tool.getComponents().keySet().contains(EquipmentModifier.TORCH_PLACING.dataComponent.get());
        boolean hasAutoSmelt = tool.getComponents().keySet().contains(EquipmentModifier.AUTO_SMELT.dataComponent.get());
        boolean hasLooting = tool.getComponents().keySet().contains(EquipmentModifier.LOOTING.dataComponent.get());
        boolean hasSharpness = tool.getComponents().keySet().contains(EquipmentModifier.SHARPNESS.dataComponent.get());
        boolean hasBeheading = tool.getComponents().keySet().contains(EquipmentModifier.BEHEADING.dataComponent.get());
        boolean hasLifesteal = tool.getComponents().keySet().contains(EquipmentModifier.LIFESTEAL.dataComponent.get());
        boolean hasKnockback = tool.getComponents().keySet().contains(EquipmentModifier.KNOCKBACK.dataComponent.get());
        boolean hasIgnite = tool.getComponents().keySet().contains(EquipmentModifier.IGNITE.dataComponent.get());
        boolean hasExcavation = tool.getComponents().keySet().contains(EquipmentModifier.EXCAVATION.dataComponent.get());
        boolean hasTeleporting = tool.getComponents().keySet().contains(EquipmentModifier.TELEPORTING.dataComponent.get());
        boolean hasMagnet = tool.getComponents().keySet().contains(EquipmentModifier.MAGNET.dataComponent.get());
        boolean hasProtection = tool.getComponents().keySet().contains(EquipmentModifier.PROTECTION.dataComponent.get());
        boolean hasStepAssist = tool.getComponents().keySet().contains(EquipmentModifier.STEP_ASSIST.dataComponent.get());
        boolean hasNightVision = tool.getComponents().keySet().contains(EquipmentModifier.NIGHT_VISION.dataComponent.get());
        boolean hasWaterBreathing = tool.getComponents().keySet().contains(EquipmentModifier.WATER_BREATHING.dataComponent.get());
        boolean hasWalterWalker = tool.getComponents().keySet().contains(EquipmentModifier.WATER_WALKER.dataComponent.get());
        boolean hasLavaWalker = tool.getComponents().keySet().contains(EquipmentModifier.LAVA_WALKER.dataComponent.get());
        boolean hasSpeed = tool.getComponents().keySet().contains(EquipmentModifier.SPEED.dataComponent.get());
        boolean hasFlight = tool.getComponents().keySet().contains(EquipmentModifier.FLIGHT.dataComponent.get());
        boolean hasFeatherFalling = tool.getComponents().keySet().contains(EquipmentModifier.FEATHER_FALLING.dataComponent.get());
        boolean hasSoulbound = tool.getComponents().keySet().contains(EquipmentModifier.SOULBOUND.dataComponent.get());
        boolean hasJets = tool.getComponents().keySet().contains(EquipmentModifier.JETS.dataComponent.get());
        boolean hasToggleableModifiers = tool.getComponents().keySet().contains(EquipmentModifier.TOGGLEABLE_MODIFIERS.get());
        boolean bl = hasEffects = hasJets || hasSoulbound || hasFeatherFalling || hasFlight || hasWalterWalker || hasLavaWalker || hasSpeed || hasWaterBreathing || hasNightVision || hasEquipmentLevel || hasStepAssist || hasProtection || hasMagnet || hasTeleporting || hasExcavation || hasIgnite || hasLifesteal || hasKnockback || hasBeheading || hasSharpness || hasLooting || hasAutoSmelt || hasTorchPlacing || hasRepairing || hasUnbreaking || hasFortune || hasEfficiency || hasSilkTouch;
        if (Screen.hasShiftDown() && hasEffects) {
            int index = 1;
            int toolLevel = (Integer)tool.getComponents().getOrDefault((DataComponentType)EquipmentModifier.EQUIPMENT_LEVEL.dataComponent.get(), (Object)0);
            if (hasEquipmentLevel) {
                int currentExperience = Optional.ofNullable((Integer)tool.getComponents().get((DataComponentType)EquipmentModifier.EQUIPMENT_EXPERIENCE.get())).orElse(0);
                double modifierLevel = EquipmentModifierUtils.getExperienceModifierLevel(toolLevel);
                int totalExperienceToNextLevel = (int)((double)((Integer)EquipmentModifierConfig.experiencePerLevelForEquipmentLevel.get()).intValue() + (double)((Integer)EquipmentModifierConfig.experiencePerLevelForEquipmentLevel.get()).intValue() * modifierLevel);
                components.add(index, Component.translatable((String)"tooltips.casting.stats.equipment_level", (Object[])new Object[]{toolLevel, currentExperience, totalExperienceToNextLevel}).withStyle(ChatFormatting.GOLD));
                ++index;
            }
            components.add(index, Component.empty());
            ++index;
            if (hasSilkTouch) {
                if (hasToggleableModifiers && Boolean.TRUE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.silk_touch").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)" (\u2714)").withStyle(ChatFormatting.GREEN)));
                } else if (hasToggleableModifiers && Boolean.FALSE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.silk_touch").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)" (\u274c)").withStyle(ChatFormatting.RED)));
                } else {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.silk_touch").withStyle(ChatFormatting.BLUE));
                }
                ++index;
            }
            if (hasEfficiency) {
                int efficiencyLevel = Optional.ofNullable(Integer.valueOf((Integer)tool.getComponents().get((DataComponentType)EquipmentModifier.EFFICIENCY.dataComponent.get()))).orElse(0);
                components.add(index, Component.translatable((String)"tooltips.casting.stats.efficiency", (Object[])new Object[]{efficiencyLevel}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasFortune) {
                int fortuneLevel = Optional.ofNullable(Integer.valueOf((Integer)tool.getComponents().get((DataComponentType)EquipmentModifier.FORTUNE.dataComponent.get()))).orElse(0);
                components.add(index, Component.translatable((String)"tooltips.casting.stats.fortune", (Object[])new Object[]{fortuneLevel}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasUnbreaking) {
                int unbreakingLevel = Optional.ofNullable(Integer.valueOf((Integer)tool.getComponents().get((DataComponentType)EquipmentModifier.UNBREAKING.dataComponent.get()))).orElse(0);
                components.add(index, Component.translatable((String)"tooltips.casting.stats.unbreaking", (Object[])new Object[]{unbreakingLevel}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasRepairing) {
                int repairingLevel = Optional.ofNullable(Integer.valueOf((Integer)tool.getComponents().get((DataComponentType)EquipmentModifier.REPAIRING.dataComponent.get()))).orElse(0);
                components.add(index, Component.translatable((String)"tooltips.casting.stats.repairing", (Object[])new Object[]{repairingLevel}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasTorchPlacing) {
                components.add(index, Component.translatable((String)"tooltips.casting.stats.torch_placing").withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasAutoSmelt) {
                if (hasToggleableModifiers && Boolean.TRUE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.auto_smelt").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)" (\u2714)").withStyle(ChatFormatting.GREEN)));
                } else if (hasToggleableModifiers && Boolean.FALSE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.auto_smelt").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)" (\u274c)").withStyle(ChatFormatting.RED)));
                } else {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.auto_smelt").withStyle(ChatFormatting.BLUE));
                }
                ++index;
            }
            if (hasLooting) {
                int lootingLevel = Optional.ofNullable(Integer.valueOf((Integer)tool.getComponents().get((DataComponentType)EquipmentModifier.LOOTING.dataComponent.get()))).orElse(0);
                components.add(index, Component.translatable((String)"tooltips.casting.stats.looting", (Object[])new Object[]{lootingLevel}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasSharpness) {
                int sharpnessLevel = Optional.ofNullable(Integer.valueOf((Integer)tool.getComponents().get((DataComponentType)EquipmentModifier.SHARPNESS.dataComponent.get()))).orElse(0);
                int totalAdditionalDamage = (int)(((Float)EquipmentModifierConfig.additionalMultiplierForSharpness.get()).floatValue() * (float)sharpnessLevel + ((Float)EquipmentModifierConfig.additionalAdditionForSharpness.get()).floatValue());
                components.add(index, Component.translatable((String)"tooltips.casting.stats.sharpness", (Object[])new Object[]{sharpnessLevel, totalAdditionalDamage}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasBeheading) {
                components.add(index, Component.translatable((String)"tooltips.casting.stats.beheading").withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasLifesteal) {
                int lifestealLevel = Optional.ofNullable(Integer.valueOf((Integer)tool.getComponents().get((DataComponentType)EquipmentModifier.LIFESTEAL.dataComponent.get()))).orElse(0);
                int percentageRestored = 10 * lifestealLevel;
                components.add(index, Component.translatable((String)"tooltips.casting.stats.lifesteal", (Object[])new Object[]{lifestealLevel, percentageRestored}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasKnockback) {
                int knockbackLevel = Optional.ofNullable(Integer.valueOf((Integer)tool.getComponents().get((DataComponentType)EquipmentModifier.KNOCKBACK.dataComponent.get()))).orElse(0);
                components.add(index, Component.translatable((String)"tooltips.casting.stats.knockback", (Object[])new Object[]{knockbackLevel}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasIgnite) {
                int igniteLevel = Optional.ofNullable(Integer.valueOf((Integer)tool.getComponents().get((DataComponentType)EquipmentModifier.IGNITE.dataComponent.get()))).orElse(0);
                components.add(index, Component.translatable((String)"tooltips.casting.stats.ignite", (Object[])new Object[]{igniteLevel}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasExcavation) {
                int excavationLevel = Optional.ofNullable(Integer.valueOf((Integer)tool.getComponents().get((DataComponentType)EquipmentModifier.EXCAVATION.dataComponent.get()))).orElse(0);
                int excavationArea = 1 + excavationLevel * 2;
                if (hasToggleableModifiers && Boolean.TRUE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.excavation", (Object[])new Object[]{excavationLevel, excavationArea, excavationArea}).withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)" (\u2714)").withStyle(ChatFormatting.GREEN)));
                } else if (hasToggleableModifiers && Boolean.FALSE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.excavation", (Object[])new Object[]{excavationLevel, excavationArea, excavationArea}).withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)" (\u274c)").withStyle(ChatFormatting.RED)));
                } else {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.excavation", (Object[])new Object[]{excavationLevel, excavationArea, excavationArea}).withStyle(ChatFormatting.BLUE));
                }
                ++index;
            }
            if (hasTeleporting) {
                int teleportingLevel = Optional.ofNullable(Integer.valueOf((Integer)tool.getComponents().get((DataComponentType)EquipmentModifier.TELEPORTING.dataComponent.get()))).orElse(0);
                int blockAmount = (Integer)EquipmentModifierConfig.blocksPerLevelForTeleporting.get() * teleportingLevel;
                components.add(index, Component.translatable((String)"tooltips.casting.stats.teleporting", (Object[])new Object[]{teleportingLevel, blockAmount}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasMagnet) {
                int magnetLevel = Optional.ofNullable(Integer.valueOf((Integer)tool.getComponents().get((DataComponentType)EquipmentModifier.MAGNET.dataComponent.get()))).orElse(0);
                if (hasToggleableModifiers && Boolean.TRUE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.magnet", (Object[])new Object[]{magnetLevel}).withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)" (\u2714)").withStyle(ChatFormatting.GREEN)));
                } else if (hasToggleableModifiers && Boolean.FALSE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.magnet", (Object[])new Object[]{magnetLevel}).withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)" (\u274c)").withStyle(ChatFormatting.RED)));
                } else {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.magnet", (Object[])new Object[]{magnetLevel}).withStyle(ChatFormatting.BLUE));
                }
                ++index;
            }
            if (hasProtection) {
                int protectionLevel = Optional.ofNullable(Integer.valueOf((Integer)tool.getComponents().get((DataComponentType)EquipmentModifier.PROTECTION.dataComponent.get()))).orElse(0);
                components.add(index, Component.translatable((String)"tooltips.casting.stats.protection", (Object[])new Object[]{protectionLevel}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasStepAssist) {
                int stepAssistLevel = Optional.ofNullable(Integer.valueOf((Integer)tool.getComponents().get((DataComponentType)EquipmentModifier.STEP_ASSIST.dataComponent.get()))).orElse(0);
                if (hasToggleableModifiers && Boolean.TRUE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.step_assist", (Object[])new Object[]{stepAssistLevel}).withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)" (\u2714)").withStyle(ChatFormatting.GREEN)));
                } else if (hasToggleableModifiers && Boolean.FALSE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.step_assist", (Object[])new Object[]{stepAssistLevel}).withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)" (\u274c)").withStyle(ChatFormatting.RED)));
                } else {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.step_assist", (Object[])new Object[]{stepAssistLevel}).withStyle(ChatFormatting.BLUE));
                }
                ++index;
            }
            if (hasNightVision) {
                if (hasToggleableModifiers && Boolean.TRUE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.night_vision").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)" (\u2714)").withStyle(ChatFormatting.GREEN)));
                } else if (hasToggleableModifiers && Boolean.FALSE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.night_vision").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)" (\u274c)").withStyle(ChatFormatting.RED)));
                } else {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.night_vision").withStyle(ChatFormatting.BLUE));
                }
                ++index;
            }
            if (hasWaterBreathing) {
                components.add(index, Component.translatable((String)"tooltips.casting.stats.water_breathing").withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasWalterWalker) {
                if (hasToggleableModifiers && Boolean.TRUE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.water_walker").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)" (\u2714)").withStyle(ChatFormatting.GREEN)));
                } else if (hasToggleableModifiers && Boolean.FALSE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.water_walker").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)" (\u274c)").withStyle(ChatFormatting.RED)));
                } else {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.water_walker").withStyle(ChatFormatting.BLUE));
                }
                ++index;
            }
            if (hasLavaWalker) {
                if (hasToggleableModifiers && Boolean.TRUE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.lava_walker").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)" (\u2714)").withStyle(ChatFormatting.GREEN)));
                } else if (hasToggleableModifiers && Boolean.FALSE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.lava_walker").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)" (\u274c)").withStyle(ChatFormatting.RED)));
                } else {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.lava_walker").withStyle(ChatFormatting.BLUE));
                }
                ++index;
            }
            if (hasSpeed) {
                int speedLevel = Optional.ofNullable(Integer.valueOf((Integer)tool.getComponents().get((DataComponentType)EquipmentModifier.SPEED.dataComponent.get()))).orElse(0);
                if (hasToggleableModifiers && Boolean.TRUE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.speed", (Object[])new Object[]{speedLevel}).withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)" (\u2714)").withStyle(ChatFormatting.GREEN)));
                } else if (hasToggleableModifiers && Boolean.FALSE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.speed", (Object[])new Object[]{speedLevel}).withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)" (\u274c)").withStyle(ChatFormatting.RED)));
                } else {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.speed", (Object[])new Object[]{speedLevel}).withStyle(ChatFormatting.BLUE));
                }
                ++index;
            }
            if (hasFlight) {
                if (hasToggleableModifiers && Boolean.TRUE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.flight").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)" (\u2714)").withStyle(ChatFormatting.GREEN)));
                } else if (hasToggleableModifiers && Boolean.FALSE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.flight").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)" (\u274c)").withStyle(ChatFormatting.RED)));
                } else {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.flight").withStyle(ChatFormatting.BLUE));
                }
                ++index;
            }
            if (hasFeatherFalling) {
                int featherFallingLevel = Optional.ofNullable(Integer.valueOf((Integer)tool.getComponents().get((DataComponentType)EquipmentModifier.FEATHER_FALLING.dataComponent.get()))).orElse(0);
                components.add(index, Component.translatable((String)"tooltips.casting.stats.feather_falling", (Object[])new Object[]{featherFallingLevel}).withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasSoulbound) {
                components.add(index, Component.translatable((String)"tooltips.casting.stats.soulbound").withStyle(ChatFormatting.BLUE));
                ++index;
            }
            if (hasJets) {
                int jetsLevel = Optional.ofNullable(Integer.valueOf((Integer)tool.getComponents().get((DataComponentType)EquipmentModifier.JETS.dataComponent.get()))).orElse(0);
                if (hasToggleableModifiers && Boolean.TRUE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.jets", (Object[])new Object[]{jetsLevel}).withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)" (\u2714)").withStyle(ChatFormatting.GREEN)));
                } else if (hasToggleableModifiers && Boolean.FALSE.equals(tool.getComponents().get((DataComponentType)EquipmentModifier.TOGGLEABLE_MODIFIERS.get()))) {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.jets", (Object[])new Object[]{jetsLevel}).withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)" (\u274c)").withStyle(ChatFormatting.RED)));
                } else {
                    components.add(index, Component.translatable((String)"tooltips.casting.stats.jets", (Object[])new Object[]{jetsLevel}).withStyle(ChatFormatting.BLUE));
                }
                ++index;
            }
            components.add(1, Component.translatable((String)"tooltips.casting.stats.modifiers", (Object[])new Object[]{index - 3, toolLevel}).withStyle(ChatFormatting.GOLD));
        } else if (hasEffects) {
            components.add(1, Component.translatable((String)"tooltips.bblcore.shift").withStyle(ChatFormatting.YELLOW));
        }
    }
}

