/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.event.client;

import com.benbenlaw.casting.event.ToolEvents;
import com.benbenlaw.casting.item.EquipmentModifier;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="casting", value={Dist.CLIENT})
public class ExcavationOutlineRenderer {
    @SubscribeEvent
    public static void onBlockHighlight(RenderHighlightEvent.Block event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        ItemStack tool = mc.player.getMainHandItem();
        if (!ExcavationOutlineRenderer.isExcavationTool(tool)) {
            return;
        }
        BlockHitResult target = event.getTarget();
        if (!(target instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHit = target;
        BlockPos origin = blockHit.getBlockPos();
        Direction face = blockHit.getDirection();
        int excavationLevel = (Integer)tool.getComponents().getOrDefault((DataComponentType)EquipmentModifier.EXCAVATION.dataComponent.get(), (Object)0);
        List<BlockPos> excavationPlane = ToolEvents.getExcavationPlane(origin, face, excavationLevel);
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource buffer = event.getMultiBufferSource();
        Vec3 cameraPos = event.getCamera().getPosition();
        for (BlockPos pos : excavationPlane) {
            BlockState state = mc.level.getBlockState(pos);
            if (state.isAir()) continue;
            AABB aabb = new AABB(pos).move(-cameraPos.x, -cameraPos.y, -cameraPos.z);
            LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)buffer.getBuffer(RenderType.lines()), (AABB)aabb, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
        }
        event.setCanceled(true);
    }

    private static boolean isExcavationTool(ItemStack stack) {
        return stack.getComponents().has((DataComponentType)EquipmentModifier.EXCAVATION.dataComponent.get()) && ToolEvents.isToggleableModifierActive(stack);
    }
}

