/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public record CoolantRecipe(FluidStack fluid, int duration) implements Recipe<RecipeInput>
{
    public boolean matches(@NotNull RecipeInput container, @NotNull Level level) {
        return true;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput container, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public FluidStack getFluidStack() {
        return this.fluid.copy();
    }

    public Fluid getFluid() {
        return this.fluid.getFluid();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<CoolantRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<CoolantRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidStack.CODEC.fieldOf("fluid").forGetter(CoolantRecipe::fluid), (App)Codec.INT.fieldOf("duration").forGetter(CoolantRecipe::duration)).apply((Applicative)instance, Serializer::createCoolantRecipe));
        private static final StreamCodec<RegistryFriendlyByteBuf, CoolantRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<CoolantRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, CoolantRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static CoolantRecipe read(RegistryFriendlyByteBuf buffer) {
            FluidStack fluid = (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buffer);
            int duration = buffer.readInt();
            return new CoolantRecipe(fluid, duration);
        }

        private static void write(RegistryFriendlyByteBuf buffer, CoolantRecipe recipe) {
            FluidStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.fluid);
            buffer.writeInt(recipe.duration);
        }

        static CoolantRecipe createCoolantRecipe(FluidStack fluid, int duration) {
            return new CoolantRecipe(fluid, duration);
        }
    }

    public static class Type
    implements RecipeType<CoolantRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

