/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.recipe;

import com.benbenlaw.core.recipe.NoInventoryRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public record MixingRecipe(NonNullList<FluidStack> fluids, FluidStack outputFluid) implements Recipe<NoInventoryRecipe>
{
    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.create();
    }

    public boolean matches(NoInventoryRecipe recipe, Level level) {
        return true;
    }

    public ItemStack assemble(NoInventoryRecipe p_345149_, HolderLookup.Provider p_346030_) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public boolean isSpecial() {
        return true;
    }

    public List<FluidStack> getAllFluids() {
        NonNullList<FluidStack> allFluids = this.fluids;
        allFluids.removeIf(FluidStack::isEmpty);
        return allFluids;
    }

    public static class Serializer
    implements RecipeSerializer<MixingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<MixingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.list((Codec)FluidStack.CODEC).fieldOf("inputs").flatXmap(inputFluids -> {
            NonNullList nonNullList = NonNullList.create();
            nonNullList.addAll((Collection)inputFluids);
            return DataResult.success((Object)nonNullList);
        }, DataResult::success).forGetter(MixingRecipe::fluids), (App)FluidStack.CODEC.fieldOf("output").forGetter(MixingRecipe::outputFluid)).apply((Applicative)instance, Serializer::createSolidifierRecipe));
        private static final StreamCodec<RegistryFriendlyByteBuf, MixingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<MixingRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, MixingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static MixingRecipe read(RegistryFriendlyByteBuf buffer) {
            int fluidCount = buffer.readInt();
            NonNullList fluids = NonNullList.create();
            for (int i = 0; i < fluidCount; ++i) {
                FluidStack fluid = (FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
                if (fluid.isEmpty()) continue;
                fluids.add((Object)fluid);
            }
            FluidStack output = (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buffer);
            return new MixingRecipe((NonNullList<FluidStack>)fluids, output);
        }

        private static void write(RegistryFriendlyByteBuf buffer, MixingRecipe recipe) {
            buffer.writeInt(recipe.fluids.size());
            for (FluidStack fluid : recipe.fluids) {
                FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)fluid);
            }
            FluidStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.outputFluid);
        }

        static MixingRecipe createSolidifierRecipe(NonNullList<FluidStack> fluids, FluidStack output) {
            return new MixingRecipe(fluids, output);
        }
    }

    public static class Type
    implements RecipeType<MixingRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

