/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.screen.multiblock;

import com.benbenlaw.casting.screen.multiblock.MultiblockCoolantTankMenu;
import com.benbenlaw.casting.screen.util.FluidStackStackWidget;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class MultiblockCoolantTankScreen
extends AbstractContainerScreen<MultiblockCoolantTankMenu> {
    private Level level;
    private BlockEntity coolantTankEntity;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"textures/gui/controller_tank_gui.png");

    public MultiblockCoolantTankScreen(MultiblockCoolantTankMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.level = menu.level;
    }

    protected void init() {
        super.init();
        this.addFluidWidgets();
    }

    private void addFluidWidgets() {
        this.addRenderableOnly((Renderable)new FluidStackStackWidget((Screen)this, ((MultiblockCoolantTankMenu)this.getMenu()).blockEntity.fluidHandler, this.leftPos + 62, this.topPos + 21, 16, 45));
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = this.leftPos;
        int y = this.topPos;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }
}

