/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.screen.util;

import com.benbenlaw.core.screen.util.CoreWidget;
import com.benbenlaw.core.util.MouseUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

@Deprecated(since="2.0.0")
public class FluidStackWidgetBigTank
extends CoreWidget {
    private final Screen screen;
    private final FluidTank getFluid;

    public FluidStackWidgetBigTank(Screen screen, FluidTank getFluid, int pX, int pY, int pWidth, int pHeight) {
        super(pX, pY, pWidth, pHeight);
        this.screen = screen;
        this.getFluid = getFluid;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        FluidTank fluidTank = this.getFluid;
        this.renderToolTip(guiGraphics, mouseX, mouseY);
        if (!fluidTank.getFluid().isEmpty()) {
            FluidStack fluidStack = fluidTank.getFluid();
            IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            ResourceLocation still = props.getStillTexture(fluidStack);
            AbstractTexture texture = minecraft.getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS);
            if (texture instanceof TextureAtlas) {
                TextureAtlas atlas = (TextureAtlas)texture;
                TextureAtlasSprite sprite = atlas.getSprite(still);
                int color = props.getTintColor();
                RenderSystem.setShaderColor((float)((float)FastColor.ARGB32.red((int)color) / 255.0f), (float)((float)FastColor.ARGB32.green((int)color) / 255.0f), (float)((float)FastColor.ARGB32.blue((int)color) / 255.0f), (float)((float)FastColor.ARGB32.alpha((int)color) / 255.0f));
                RenderSystem.enableBlend();
                int stored = fluidTank.getFluidAmount();
                float capacity = fluidTank.getCapacity();
                float filledVolume = (float)stored / capacity;
                int renderableHeight = (int)(filledVolume * (float)this.height);
                int atlasWidth = (int)((float)sprite.contents().width() / (sprite.getU1() - sprite.getU0()));
                int atlasHeight = (int)((float)sprite.contents().height() / (sprite.getV1() - sprite.getV0()));
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0f, (float)(this.height - 16), 0.0f);
                int i = 0;
                while ((double)i < Math.ceil((float)renderableHeight / 16.0f)) {
                    int drawingHeight = Math.min(16, renderableHeight - 16 * i);
                    int notDrawingHeight = 16 - drawingHeight;
                    guiGraphics.blit(TextureAtlas.LOCATION_BLOCKS, this.x, this.y + notDrawingHeight, 0, sprite.getU0() * (float)atlasWidth, sprite.getV0() * (float)atlasHeight + (float)notDrawingHeight, this.width, drawingHeight, atlasWidth, atlasHeight);
                    guiGraphics.pose().translate(0.0f, -16.0f, 0.0f);
                    ++i;
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.pose().popPose();
            }
        }
        RenderSystem.disableDepthTest();
    }

    protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }

    public void renderToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)this.x, (int)this.y, (int)0, (int)0, (int)14, (int)52)) {
            int fluidAmount;
            Font font = this.screen.getMinecraft().font;
            FormattedCharSequence[] tooltipText = new FormattedCharSequence[2];
            if (!this.getFluid.getFluid().isEmpty()) {
                tooltipText[0] = this.getFluid.getFluid().getHoverName().getVisualOrderText();
                fluidAmount = this.getFluid.getFluidAmount();
            } else {
                tooltipText[0] = Component.literal((String)"Air").getVisualOrderText();
                fluidAmount = 0;
            }
            tooltipText[1] = Component.literal((String)(fluidAmount + "mB / " + this.getFluid.getCapacity() + "mB")).getVisualOrderText();
            guiGraphics.renderTooltip(font, Arrays.asList(tooltipText), mouseX, mouseY);
        }
    }
}

