/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.integration.jei;

import com.benbenlaw.casting.block.CastingBlocks;
import com.benbenlaw.casting.integration.jei.JEICastingPlugin;
import com.benbenlaw.casting.recipe.CoolantRecipe;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoolantRecipeCategory
implements IRecipeCategory<CoolantRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"coolant");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"textures/gui/jei_dynamic.png");
    public static final RecipeType<CoolantRecipe> RECIPE_TYPE = RecipeType.create((String)"casting", (String)"coolant", CoolantRecipe.class);
    private IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper helper;
    private int tabs_used = 0;
    private final Map<Point, CoolantRecipe> slotRecipes = new HashMap<Point, CoolantRecipe>();
    private int backgroundWidth;

    public CoolantRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(TEXTURE, 0, 0, 159, 104);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CastingBlocks.MULTIBLOCK_COOLANT_TANK.get()));
    }

    @NotNull
    public RecipeType<CoolantRecipe> getRecipeType() {
        return JEICastingPlugin.COOLANT_RECIPE;
    }

    public boolean isHandled(CoolantRecipe recipe) {
        return this.tabs_used == 0;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"gui.casting.jei.coolant");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nullable
    public ResourceLocation getRegistryName(CoolantRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)CoolantRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((CoolantRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CoolantRecipe recipe, IFocusGroup focusGroup) {
        ++this.tabs_used;
        List<CoolantRecipe> recipes = new ArrayList(Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)CoolantRecipe.Type.INSTANCE)).stream().map(RecipeHolder::value).toList();
        ArrayList<CoolantRecipe> mutableRecipes = new ArrayList<CoolantRecipe>(recipes);
        mutableRecipes.sort(Comparator.comparingInt(CoolantRecipe::duration).reversed());
        int yOffset = 1;
        int numRows = (int)Math.ceil((double)mutableRecipes.size() / 9.0);
        int numCols = 8;
        int backgroundHeight = 2 + numRows * 18 + yOffset;
        this.background = this.helper.createDrawable(TEXTURE, 0, 0, 148, backgroundHeight);
        this.slotRecipes.clear();
        for (int i = 0; i < mutableRecipes.size(); ++i) {
            int slotX = 3 + i % 8 * 18;
            int slotY = yOffset + 2 + i / 8 * 18;
            CoolantRecipe coolant = (CoolantRecipe)mutableRecipes.get(i);
            builder.addSlot(RecipeIngredientRole.INPUT, slotX, slotY).addFluidStack(coolant.getFluid(), 1000L).addRichTooltipCallback((slot, tooltip) -> tooltip.add((FormattedText)Component.literal((String)(coolant.getFluidStack().getAmount() + "mB")).withStyle(ChatFormatting.GOLD))).addRichTooltipCallback((slot, tooltip) -> tooltip.add((FormattedText)Component.translatable((String)"gui.casting.jei.coolant_speed", (Object[])new Object[]{coolant.duration()}).withStyle(ChatFormatting.GOLD))).setBackground((IDrawable)JEICastingPlugin.slotDrawable, slotX - i % 8 * 18 - 4, slotY - (yOffset + 2 + i / 8 * 18) - 1);
            this.slotRecipes.put(new Point(slotX, slotY), (CoolantRecipe)mutableRecipes.get(i));
        }
    }
}

