/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.integration.jei;

import com.benbenlaw.casting.block.CastingBlocks;
import com.benbenlaw.casting.integration.jei.JEICastingPlugin;
import com.benbenlaw.casting.recipe.FuelRecipe;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FuelRecipeCategory
implements IRecipeCategory<FuelRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"fuel");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"textures/gui/jei_dynamic.png");
    public static final RecipeType<FuelRecipe> RECIPE_TYPE = RecipeType.create((String)"casting", (String)"fuel", FuelRecipe.class);
    private IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper helper;
    private int tabs_used = 0;
    private final Map<Point, FuelRecipe> slotRecipes = new HashMap<Point, FuelRecipe>();
    private int backgroundWidth;

    public FuelRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(TEXTURE, 0, 0, 159, 104);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CastingBlocks.MULTIBLOCK_FUEL_TANK.get()));
    }

    @NotNull
    public RecipeType<FuelRecipe> getRecipeType() {
        return JEICastingPlugin.FUEL_RECIPE;
    }

    public boolean isHandled(FuelRecipe recipe) {
        return this.tabs_used == 0;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"gui.casting.jei.fuel");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nullable
    public ResourceLocation getRegistryName(FuelRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)FuelRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((FuelRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FuelRecipe recipe, IFocusGroup focusGroup) {
        ++this.tabs_used;
        List<FuelRecipe> recipes = new ArrayList(Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)FuelRecipe.Type.INSTANCE)).stream().map(RecipeHolder::value).toList();
        ArrayList<FuelRecipe> mutableRecipes = new ArrayList<FuelRecipe>(recipes);
        mutableRecipes.sort(Comparator.comparingInt(FuelRecipe::temp).reversed());
        int yOffset = 1;
        int numRows = (int)Math.ceil((double)mutableRecipes.size() / 9.0);
        int numCols = 8;
        int backgroundHeight = 2 + numRows * 18 + yOffset;
        this.background = this.helper.createDrawable(TEXTURE, 0, 0, 148, backgroundHeight);
        this.slotRecipes.clear();
        for (int i = 0; i < mutableRecipes.size(); ++i) {
            int slotX = 3 + i % 8 * 18;
            int slotY = yOffset + 2 + i / 8 * 18;
            FuelRecipe coolant = (FuelRecipe)mutableRecipes.get(i);
            builder.addSlot(RecipeIngredientRole.INPUT, slotX, slotY).addFluidStack(((FuelRecipe)mutableRecipes.get(i)).getFluid(), 1000L).addRichTooltipCallback((slot, tooltip) -> tooltip.add((FormattedText)Component.literal((String)(coolant.fluid().getAmount() + "mB")).withStyle(ChatFormatting.GOLD))).addRichTooltipCallback((slot, tooltip) -> tooltip.add((FormattedText)Component.translatable((String)"gui.casting.jei.fuel_temp", (Object[])new Object[]{coolant.temp()}).withStyle(ChatFormatting.GOLD))).addRichTooltipCallback((slot, tooltip) -> tooltip.add((FormattedText)Component.translatable((String)"gui.casting.jei.fuel_speed", (Object[])new Object[]{coolant.duration()}).withStyle(ChatFormatting.GOLD))).setBackground((IDrawable)JEICastingPlugin.slotDrawable, slotX - i % 8 * 18 - 4, slotY - (yOffset + 2 + i / 8 * 18) - 1);
            this.slotRecipes.put(new Point(slotX, slotY), (FuelRecipe)mutableRecipes.get(i));
        }
    }
}

