/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.network.packet;

import com.benbenlaw.casting.block.entity.ControllerBlockEntity;
import com.benbenlaw.casting.block.entity.EquipmentModifierBlockEntity;
import com.benbenlaw.casting.block.entity.MixerBlockEntity;
import com.benbenlaw.casting.block.entity.SolidifierBlockEntity;
import com.benbenlaw.casting.item.CastingDataComponents;
import com.benbenlaw.casting.network.payload.FluidMoverPayload;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@Deprecated(since="2.0.0")
public record FluidMoverPacket() {
    public static final FluidMoverPacket INSTANCE = new FluidMoverPacket();

    public static FluidMoverPacket get() {
        return INSTANCE;
    }

    public void handle(FluidMoverPayload payload, IPayloadContext context) {
        boolean isOutputTank;
        FluidTank selectedTank;
        Player player = context.player();
        Level level = player.level();
        BlockPos blockPos = payload.blockPos();
        BlockState blockState = level.getBlockState(blockPos);
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        int tankNumber = payload.tankID();
        ItemStack carriedItem = player.containerMenu.getCarried();
        int maxItemFluidCap = 8000;
        if (blockEntity instanceof MixerBlockEntity) {
            MixerBlockEntity mixerBlockEntity = (MixerBlockEntity)blockEntity;
            selectedTank = null;
            isOutputTank = false;
            switch (tankNumber) {
                case 1: {
                    selectedTank = mixerBlockEntity.TANK_1;
                    break;
                }
                case 2: {
                    selectedTank = mixerBlockEntity.TANK_2;
                    break;
                }
                case 3: {
                    selectedTank = mixerBlockEntity.TANK_3;
                    break;
                }
                case 4: {
                    selectedTank = mixerBlockEntity.TANK_4;
                    break;
                }
                case 5: {
                    selectedTank = mixerBlockEntity.TANK_5;
                    break;
                }
                case 6: {
                    selectedTank = mixerBlockEntity.TANK_6;
                    break;
                }
                case 7: {
                    selectedTank = mixerBlockEntity.OUTPUT_TANK;
                    isOutputTank = true;
                    break;
                }
                default: {
                    player.sendSystemMessage((Component)Component.literal((String)"Invalid tank number!"));
                    return;
                }
            }
            this.transferFluidBetweenTankAndItem(selectedTank, carriedItem, player, isOutputTank);
            mixerBlockEntity.sync();
        }
        if (blockEntity instanceof ControllerBlockEntity) {
            ControllerBlockEntity controllerBlockEntity = (ControllerBlockEntity)blockEntity;
            selectedTank = null;
            isOutputTank = true;
            switch (tankNumber) {
                case 1: {
                    selectedTank = controllerBlockEntity.TANK_1;
                    break;
                }
                case 2: {
                    selectedTank = controllerBlockEntity.TANK_2;
                    break;
                }
                case 3: {
                    selectedTank = controllerBlockEntity.TANK_3;
                    break;
                }
                case 4: {
                    selectedTank = controllerBlockEntity.TANK_4;
                    break;
                }
                default: {
                    player.sendSystemMessage((Component)Component.literal((String)"Invalid tank number!"));
                    return;
                }
            }
            this.transferFluidBetweenTankAndItem(selectedTank, carriedItem, player, isOutputTank);
            controllerBlockEntity.sync();
        }
        if (blockEntity instanceof SolidifierBlockEntity) {
            SolidifierBlockEntity solidifierBlockEntity = (SolidifierBlockEntity)blockEntity;
            selectedTank = null;
            isOutputTank = false;
            if (tankNumber != 1) {
                player.sendSystemMessage((Component)Component.literal((String)"Invalid tank number!"));
                return;
            }
            selectedTank = solidifierBlockEntity.TANK;
            solidifierBlockEntity.sync();
            this.transferFluidBetweenTankAndItem(selectedTank, carriedItem, player, isOutputTank);
        }
        if (blockEntity instanceof EquipmentModifierBlockEntity) {
            EquipmentModifierBlockEntity equipmentModifierBlockEntity = (EquipmentModifierBlockEntity)blockEntity;
            selectedTank = null;
            isOutputTank = false;
            if (tankNumber != 1) {
                player.sendSystemMessage((Component)Component.literal((String)"Invalid tank number!"));
                return;
            }
            selectedTank = equipmentModifierBlockEntity.TANK;
            this.transferFluidBetweenTankAndItem(selectedTank, carriedItem, player, isOutputTank);
            equipmentModifierBlockEntity.sync();
        }
    }

    private void transferFluidBetweenTankAndItem(FluidTank tank, ItemStack carriedItem, Player player, boolean isOutputTank) {
        int itemMaxCapacity = 8000;
        if (carriedItem.get(CastingDataComponents.FLUIDS) != null) {
            List fluids = (List)carriedItem.get(CastingDataComponents.FLUIDS);
            assert (fluids != null);
            Fluid carriedFluid = ((FluidStack)fluids.getFirst()).getFluid();
            int carriedAmount = ((FluidStack)fluids.getFirst()).getAmount();
            if (!isOutputTank) {
                if (tank.isEmpty() || tank.getFluid().getFluid().equals(carriedFluid)) {
                    int availableTankSpace = tank.getCapacity() - tank.getFluidAmount();
                    int amountToTransfer = Math.min(carriedAmount, availableTankSpace);
                    if (amountToTransfer > 0) {
                        tank.fill(new FluidStack(carriedFluid, amountToTransfer), IFluidHandler.FluidAction.EXECUTE);
                        int remainingAmount = carriedAmount - amountToTransfer;
                        carriedItem.set(CastingDataComponents.FLUIDS, List.of(new FluidStack(carriedFluid, remainingAmount)));
                        if (((FluidStack)((List)carriedItem.get((DataComponentType)CastingDataComponents.FLUIDS.get())).getFirst()).isEmpty()) {
                            carriedItem.remove(CastingDataComponents.FLUIDS);
                        }
                        return;
                    }
                } else {
                    player.sendSystemMessage((Component)Component.literal((String)"Fluid types don't match!"));
                }
            } else {
                player.sendSystemMessage((Component)Component.literal((String)"Cannot add fluids to the output tank!"));
            }
        }
        if (!tank.isEmpty()) {
            FluidStack currentFluidInTank = tank.getFluid();
            if (carriedItem.get(CastingDataComponents.FLUIDS) == null) {
                int transferAmount = Math.min(currentFluidInTank.getAmount(), itemMaxCapacity);
                carriedItem.set(CastingDataComponents.FLUIDS, List.of(new FluidStack(currentFluidInTank.getFluid(), transferAmount)));
                tank.setFluid(new FluidStack(currentFluidInTank.getFluid(), currentFluidInTank.getAmount() - transferAmount));
            } else if (carriedItem.get(CastingDataComponents.FLUIDS) != null) {
                List fluids = (List)carriedItem.get(CastingDataComponents.FLUIDS);
                assert (fluids != null);
                Fluid carriedFluid = ((FluidStack)fluids.getFirst()).getFluid();
                int carriedAmount = ((FluidStack)fluids.getFirst()).getAmount();
                if (carriedFluid.equals(currentFluidInTank.getFluid())) {
                    int remainingCapacity = itemMaxCapacity - carriedAmount;
                    int currentTankAmount = currentFluidInTank.getAmount();
                    int amountToTransfer = Math.min(currentTankAmount, remainingCapacity);
                    if (amountToTransfer > 0) {
                        int newCarriedAmount = carriedAmount + amountToTransfer;
                        carriedItem.set(CastingDataComponents.FLUIDS, List.of(new FluidStack(carriedFluid, newCarriedAmount)));
                        tank.setFluid(new FluidStack(currentFluidInTank.getFluid(), currentTankAmount - amountToTransfer));
                    }
                } else {
                    player.sendSystemMessage((Component)Component.literal((String)"Fluid types don't match!"));
                }
            }
        }
    }
}

