/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.screen.multiblock;

import com.benbenlaw.casting.block.CastingBlocks;
import com.benbenlaw.casting.block.entity.multiblock.MultiblockControllerBlockEntity;
import com.benbenlaw.casting.screen.CastingMenuTypes;
import com.benbenlaw.casting.util.ConditionalSlotItemHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class MultiblockControllerMenu
extends AbstractContainerMenu {
    protected MultiblockControllerBlockEntity blockEntity;
    protected Level level;
    protected ContainerData data;
    protected Player player;
    protected BlockPos blockPos;
    public int inventorySlots = 60;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;

    public MultiblockControllerMenu(int containerID, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerID, inventory, extraData.readBlockPos(), (ContainerData)new SimpleContainerData(120));
    }

    public MultiblockControllerMenu(int containerID, Inventory inventory, BlockPos blockPos, ContainerData data) {
        super((MenuType)CastingMenuTypes.MULTIBLOCK_CONTROLLER_MENU.get(), containerID);
        int i;
        this.player = inventory.player;
        this.blockPos = blockPos;
        this.level = inventory.player.level();
        this.data = data;
        this.blockEntity = (MultiblockControllerBlockEntity)this.level.getBlockEntity(blockPos);
        assert (this.blockEntity != null);
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        int totalSlots = Math.min(60, this.blockEntity.getItemStackHandler().getSlots());
        for (i = 0; i < Math.min(45, totalSlots); ++i) {
            int xPos = 8 + i % 9 * 18;
            int yPos = 17 + i / 9 * 18;
            this.addSlot((Slot)new ConditionalSlotItemHandler(this.blockEntity, (IItemHandler)this.blockEntity.getItemStackHandler(), i, xPos, yPos));
        }
        for (i = 45; i < totalSlots; ++i) {
            int relativeIndex = i - 45;
            int xPos = 8 + relativeIndex % 5 * 18;
            int yPos = 107 + relativeIndex / 5 * 18;
            this.addSlot((Slot)new ConditionalSlotItemHandler(this.blockEntity, (IItemHandler)this.blockEntity.getItemStackHandler(), i, xPos, yPos));
        }
        this.addDataSlots(data);
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public int getScaledProgress(int slotIndex) {
        int progress = this.data.get(slotIndex);
        int maxProgress = this.blockEntity.maxProgress[slotIndex];
        int progressBarWidth = 19;
        return maxProgress != 0 && progress != 0 ? progress * progressBarWidth / maxProgress : 0;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 36 + this.inventorySlots, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 36 + this.inventorySlots) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(@NotNull Player player) {
        return MultiblockControllerMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.blockPos), (Player)player, (Block)((Block)CastingBlocks.MULTIBLOCK_CONTROLLER.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 86 + i * 18 + 88));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 232));
        }
    }
}

