/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.config;

import com.benbenlaw.casting.util.BeheadingHeadMap;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.ModConfigSpec;

public class BeheadingConfig {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static ModConfigSpec.ConfigValue<List<? extends String>> HEAD_MAPPINGS;

    public static void applyToHeadMap() {
        for (String entry : (List)HEAD_MAPPINGS.get()) {
            String[] parts = entry.split("=");
            if (parts.length == 2) {
                ResourceLocation entityId = ResourceLocation.parse((String)parts[0].trim());
                ResourceLocation itemId = ResourceLocation.parse((String)parts[1].trim());
                Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
                BeheadingHeadMap.register(entityId, () -> item);
                continue;
            }
            System.err.println("[BeheadingConfig] Invalid entry: " + entry);
        }
    }

    static {
        BUILDER.comment("Beheading Config for Casting").push("Beheading Config");
        HEAD_MAPPINGS = BUILDER.comment("Mappings in the form: entity_id=item_id").defineListAllowEmpty(List.of("heads"), () -> List.of("minecraft:zombie=minecraft:zombie_head", "minecraft:skeleton=minecraft:skeleton_skull", "minecraft:creeper=minecraft:creeper_head", "minecraft:wither_skeleton=minecraft:wither_skeleton_skull", "minecraft:player=minecraft:player_head", "minecraft:enderman=enderio:enderman_head"), obj -> obj instanceof String && ((String)obj).contains("="));
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

