/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.util;

import com.benbenlaw.casting.config.EquipmentModifierConfig;
import com.benbenlaw.casting.item.CastingDataComponents;
import com.benbenlaw.casting.util.ValidToolTypesForToolModifiers;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;

public class EquipmentModifierUtils {
    public static boolean isEffectAtMax(ItemStack stack, String effect) {
        boolean hasSilkTouch = (Boolean)stack.getOrDefault(CastingDataComponents.SILK_TOUCH, (Object)false);
        int currentFortune = (Integer)stack.getOrDefault(CastingDataComponents.FORTUNE, (Object)0);
        if (effect.contains("fortune")) {
            return hasSilkTouch || currentFortune >= (Integer)EquipmentModifierConfig.maxFortuneAmount.get();
        }
        if (effect.contains("efficiency")) {
            int currentEfficiency = (Integer)stack.getOrDefault(CastingDataComponents.EFFICIENCY, (Object)0);
            return currentEfficiency >= (Integer)EquipmentModifierConfig.maxEfficiencyAmount.get();
        }
        if (effect.contains("silk_touch")) {
            return currentFortune > 0 || hasSilkTouch;
        }
        if (effect.contains("unbreaking")) {
            int currentUnbreaking = (Integer)stack.getOrDefault(CastingDataComponents.UNBREAKING, (Object)0);
            return currentUnbreaking >= (Integer)EquipmentModifierConfig.maxUnbreakingAmount.get();
        }
        if (effect.contains("repairing")) {
            int currentRepairing = (Integer)stack.getOrDefault(CastingDataComponents.REPAIRING, (Object)0);
            return currentRepairing >= (Integer)EquipmentModifierConfig.maxRepairingAmount.get();
        }
        if (effect.contains("torch_placing")) {
            return (Boolean)stack.getOrDefault(CastingDataComponents.TORCH_PLACING, (Object)false);
        }
        if (effect.contains("auto_smelt")) {
            return (Boolean)stack.getOrDefault(CastingDataComponents.AUTO_SMELT, (Object)false);
        }
        if (effect.contains("looting")) {
            int currentLooting = (Integer)stack.getOrDefault(CastingDataComponents.LOOTING, (Object)0);
            return currentLooting >= (Integer)EquipmentModifierConfig.maxLootingAmount.get();
        }
        if (effect.contains("sharpness")) {
            int currentSharpness = (Integer)stack.getOrDefault(CastingDataComponents.SHARPNESS, (Object)0);
            return currentSharpness >= (Integer)EquipmentModifierConfig.maxSharpnessAmount.get();
        }
        if (effect.contains("beheading")) {
            return (Boolean)stack.getOrDefault(CastingDataComponents.BEHEADING, (Object)false);
        }
        if (effect.contains("lifesteal")) {
            int currentLifesteal = (Integer)stack.getOrDefault(CastingDataComponents.LIFESTEAL, (Object)0);
            return currentLifesteal >= (Integer)EquipmentModifierConfig.maxLifestealAmount.get();
        }
        if (effect.contains("protection")) {
            int currentProtection = (Integer)stack.getOrDefault(CastingDataComponents.PROTECTION, (Object)0);
            return currentProtection >= (Integer)EquipmentModifierConfig.maxProtectionAmount.get();
        }
        if (effect.contains("knockback")) {
            int currentKnockback = (Integer)stack.getOrDefault(CastingDataComponents.KNOCKBACK, (Object)0);
            return currentKnockback >= (Integer)EquipmentModifierConfig.maxKnockbackAmount.get();
        }
        if (effect.contains("ignite")) {
            int currentKnockback = (Integer)stack.getOrDefault(CastingDataComponents.IGNITE, (Object)0);
            return currentKnockback >= (Integer)EquipmentModifierConfig.maxIgniteAmount.get();
        }
        if (effect.contains("excavation")) {
            int currentKnockback = (Integer)stack.getOrDefault(CastingDataComponents.EXCAVATION, (Object)0);
            return currentKnockback >= (Integer)EquipmentModifierConfig.maxExcavationAmount.get();
        }
        if (effect.contains("teleporting")) {
            int currentTeleporting = (Integer)stack.getOrDefault(CastingDataComponents.TELEPORTING, (Object)0);
            return currentTeleporting >= (Integer)EquipmentModifierConfig.maxTeleportationAmount.get();
        }
        if (effect.contains("magnet")) {
            int currentTeleporting = (Integer)stack.getOrDefault(CastingDataComponents.MAGNET, (Object)0);
            return currentTeleporting >= (Integer)EquipmentModifierConfig.maxMagnetAmount.get();
        }
        if (effect.contains("step_assist")) {
            int currentEfficiency = (Integer)stack.getOrDefault(CastingDataComponents.STEP_ASSIST, (Object)0);
            return currentEfficiency >= (Integer)EquipmentModifierConfig.maxStepAssistAmount.get();
        }
        if (effect.contains("night_vision")) {
            return (Boolean)stack.getOrDefault(CastingDataComponents.NIGHT_VISION, (Object)false);
        }
        if (effect.contains("water_breathing")) {
            return (Boolean)stack.getOrDefault(CastingDataComponents.WATER_BREATHING, (Object)false);
        }
        if (effect.contains("speed")) {
            int currentTeleporting = (Integer)stack.getOrDefault(CastingDataComponents.SPEED, (Object)0);
            return currentTeleporting >= (Integer)EquipmentModifierConfig.maxSpeedAmount.get();
        }
        if (effect.contains("water_walker")) {
            return (Boolean)stack.getOrDefault(CastingDataComponents.WATER_WALKER, (Object)false);
        }
        if (effect.contains("lava_walker")) {
            return (Boolean)stack.getOrDefault(CastingDataComponents.LAVA_WALKER, (Object)false);
        }
        return false;
    }

    public static ItemStack copyAndApplyEffect(ItemStack stack, String effect) {
        int currentEfficiency;
        ItemStack copy = stack.copy();
        if (effect.contains("equipment_level")) {
            currentEfficiency = (Integer)copy.getOrDefault(CastingDataComponents.EQUIPMENT_LEVEL, (Object)0);
            int newToolLevel = Math.min(currentEfficiency + 1, (Integer)EquipmentModifierConfig.maxEquipmentLevel.get());
            copy.set(CastingDataComponents.EQUIPMENT_LEVEL, (Object)newToolLevel);
        }
        if (effect.contains("fortune")) {
            int currentFortune = (Integer)copy.getOrDefault(CastingDataComponents.FORTUNE, (Object)0);
            int newFortune = Math.min(currentFortune + 1, (Integer)EquipmentModifierConfig.maxFortuneAmount.get());
            copy.set(CastingDataComponents.FORTUNE, (Object)newFortune);
        }
        if (effect.contains("efficiency")) {
            currentEfficiency = (Integer)copy.getOrDefault(CastingDataComponents.EFFICIENCY, (Object)0);
            int newEfficiency = Math.min(currentEfficiency + 1, (Integer)EquipmentModifierConfig.maxEfficiencyAmount.get());
            copy.set(CastingDataComponents.EFFICIENCY, (Object)newEfficiency);
        }
        if (effect.contains("silk_touch")) {
            boolean isSilkTouch = (Boolean)copy.getOrDefault(CastingDataComponents.SILK_TOUCH, (Object)false);
            copy.set(CastingDataComponents.SILK_TOUCH, (Object)(!isSilkTouch ? 1 : 0));
        }
        if (effect.contains("unbreaking")) {
            int currentUnbreaking = (Integer)copy.getOrDefault(CastingDataComponents.UNBREAKING, (Object)0);
            int newUnbreaking = Math.min(currentUnbreaking + 1, (Integer)EquipmentModifierConfig.maxUnbreakingAmount.get());
            copy.set(CastingDataComponents.UNBREAKING, (Object)newUnbreaking);
        }
        if (effect.contains("repairing")) {
            int currentRepairing = (Integer)copy.getOrDefault(CastingDataComponents.REPAIRING, (Object)0);
            int newRepairing = Math.min(currentRepairing + 1, (Integer)EquipmentModifierConfig.maxRepairingAmount.get());
            copy.set(CastingDataComponents.REPAIRING, (Object)newRepairing);
        }
        if (effect.contains("torch_placing")) {
            boolean isTorchPlacing = (Boolean)copy.getOrDefault(CastingDataComponents.TORCH_PLACING, (Object)false);
            copy.set(CastingDataComponents.TORCH_PLACING, (Object)(!isTorchPlacing ? 1 : 0));
        }
        if (effect.contains("auto_smelt")) {
            boolean isAutoSmelt = (Boolean)copy.getOrDefault(CastingDataComponents.AUTO_SMELT, (Object)false);
            copy.set(CastingDataComponents.AUTO_SMELT, (Object)(!isAutoSmelt ? 1 : 0));
        }
        if (effect.contains("looting")) {
            int currentLooting = (Integer)copy.getOrDefault(CastingDataComponents.LOOTING, (Object)0);
            int newLooting = Math.min(currentLooting + 1, (Integer)EquipmentModifierConfig.maxLootingAmount.get());
            copy.set(CastingDataComponents.LOOTING, (Object)newLooting);
        }
        if (effect.contains("sharpness")) {
            int currentSharpness = (Integer)copy.getOrDefault(CastingDataComponents.SHARPNESS, (Object)0);
            int newSharpness = Math.min(currentSharpness + 1, (Integer)EquipmentModifierConfig.maxSharpnessAmount.get());
            copy.set(CastingDataComponents.SHARPNESS, (Object)newSharpness);
        }
        if (effect.contains("beheading")) {
            boolean isBeheading = (Boolean)copy.getOrDefault(CastingDataComponents.BEHEADING, (Object)false);
            copy.set(CastingDataComponents.BEHEADING, (Object)(!isBeheading ? 1 : 0));
        }
        if (effect.contains("lifesteal")) {
            int currentLifesteal = (Integer)copy.getOrDefault(CastingDataComponents.LIFESTEAL, (Object)0);
            int newLifesteal = Math.min(currentLifesteal + 1, (Integer)EquipmentModifierConfig.maxLifestealAmount.get());
            copy.set(CastingDataComponents.LIFESTEAL, (Object)newLifesteal);
        }
        if (effect.contains("protection")) {
            int currentProtection = (Integer)copy.getOrDefault(CastingDataComponents.PROTECTION, (Object)0);
            int newProtection = Math.min(currentProtection + 1, (Integer)EquipmentModifierConfig.maxProtectionAmount.get());
            copy.set(CastingDataComponents.PROTECTION, (Object)newProtection);
        }
        if (effect.contains("knockback")) {
            int currentKnockback = (Integer)copy.getOrDefault(CastingDataComponents.KNOCKBACK, (Object)0);
            int newKnockback = Math.min(currentKnockback + 1, (Integer)EquipmentModifierConfig.maxKnockbackAmount.get());
            copy.set(CastingDataComponents.KNOCKBACK, (Object)newKnockback);
        }
        if (effect.contains("ignite")) {
            int currentIgnite = (Integer)copy.getOrDefault(CastingDataComponents.IGNITE, (Object)0);
            int newIgnite = Math.min(currentIgnite + 1, (Integer)EquipmentModifierConfig.maxIgniteAmount.get());
            copy.set(CastingDataComponents.IGNITE, (Object)newIgnite);
        }
        if (effect.contains("excavation")) {
            int currentExcavation = (Integer)copy.getOrDefault(CastingDataComponents.EXCAVATION, (Object)0);
            int newExcavation = Math.min(currentExcavation + 1, (Integer)EquipmentModifierConfig.maxExcavationAmount.get());
            copy.set(CastingDataComponents.EXCAVATION, (Object)newExcavation);
        }
        if (effect.contains("teleporting")) {
            int currentTeleporting = (Integer)copy.getOrDefault(CastingDataComponents.TELEPORTING, (Object)0);
            int newTeleporting = Math.min(currentTeleporting + 1, (Integer)EquipmentModifierConfig.maxTeleportationAmount.get());
            copy.set(CastingDataComponents.TELEPORTING, (Object)newTeleporting);
        }
        if (effect.contains("magnet")) {
            int currentMagnet = (Integer)copy.getOrDefault(CastingDataComponents.MAGNET, (Object)0);
            int newMagnet = Math.min(currentMagnet + 1, (Integer)EquipmentModifierConfig.maxMagnetAmount.get());
            copy.set(CastingDataComponents.MAGNET, (Object)newMagnet);
        }
        if (effect.contains("step_assist")) {
            int currentStepAssist = (Integer)copy.getOrDefault(CastingDataComponents.STEP_ASSIST, (Object)0);
            int newStepAssist = Math.min(currentStepAssist + 1, (Integer)EquipmentModifierConfig.maxStepAssistAmount.get());
            copy.set(CastingDataComponents.STEP_ASSIST, (Object)newStepAssist);
        }
        if (effect.contains("night_vision")) {
            boolean isNightVision = (Boolean)copy.getOrDefault(CastingDataComponents.NIGHT_VISION, (Object)false);
            copy.set(CastingDataComponents.NIGHT_VISION, (Object)(!isNightVision ? 1 : 0));
        }
        if (effect.contains("water_breathing")) {
            boolean isWaterBreathing = (Boolean)copy.getOrDefault(CastingDataComponents.WATER_BREATHING, (Object)false);
            copy.set(CastingDataComponents.WATER_BREATHING, (Object)(!isWaterBreathing ? 1 : 0));
        }
        if (effect.contains("speed")) {
            int currentSpeed = (Integer)copy.getOrDefault(CastingDataComponents.SPEED, (Object)0);
            int newSpeed = Math.min(currentSpeed + 1, (Integer)EquipmentModifierConfig.maxSpeedAmount.get());
            copy.set(CastingDataComponents.SPEED, (Object)newSpeed);
        }
        if (effect.contains("water_walker")) {
            boolean isWaterWalker = (Boolean)copy.getOrDefault(CastingDataComponents.WATER_WALKER, (Object)false);
            copy.set(CastingDataComponents.WATER_WALKER, (Object)(!isWaterWalker ? 1 : 0));
        }
        if (effect.contains("lava_walker")) {
            boolean isLavaWalker = (Boolean)copy.getOrDefault(CastingDataComponents.LAVA_WALKER, (Object)false);
            copy.set(CastingDataComponents.LAVA_WALKER, (Object)(!isLavaWalker ? 1 : 0));
        }
        if (effect.contains("flight")) {
            boolean isFlight = (Boolean)copy.getOrDefault(CastingDataComponents.FLIGHT, (Object)false);
            copy.set(CastingDataComponents.FLIGHT, (Object)(!isFlight ? 1 : 0));
        }
        return copy;
    }

    public static boolean hasEnoughFreeModifiers(ItemStack stack, String effectToApply) {
        if (!stack.has((DataComponentType)CastingDataComponents.EQUIPMENT_LEVEL.get())) {
            return true;
        }
        DataComponentType<?> effectComponent = ValidToolTypesForToolModifiers.getDataComponentFromString(effectToApply);
        assert (effectComponent != null);
        if (stack.has(effectComponent)) {
            return true;
        }
        int toolLevel = (Integer)stack.getOrDefault((DataComponentType)CastingDataComponents.EQUIPMENT_LEVEL.get(), (Object)0);
        int modifierCount = 0;
        List<String> modifiers = ValidToolTypesForToolModifiers.VALID_MODIFIERS.get("all_modifiers");
        for (String modifier : modifiers) {
            DataComponentType<?> component;
            if (modifier.equals(effectToApply) || (component = ValidToolTypesForToolModifiers.getDataComponentFromString(modifier)) == null || !stack.has(component)) continue;
            ++modifierCount;
        }
        return toolLevel > modifierCount;
    }

    public static double getExperienceModifierLevel(int toolLevel) {
        return (float)toolLevel * ((Float)EquipmentModifierConfig.experienceMultiplierPerLevel.get()).floatValue();
    }
}

