/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting;

import com.benbenlaw.casting.block.CastingBlocks;
import com.benbenlaw.casting.block.entity.CastingBlockEntities;
import com.benbenlaw.casting.block.entity.client.MultiblockCoolantTankBlockEntityRenderer;
import com.benbenlaw.casting.block.entity.client.MultiblockFuelTankBlockEntityRenderer;
import com.benbenlaw.casting.block.entity.client.TankBlockEntityRenderer;
import com.benbenlaw.casting.config.BeheadingConfig;
import com.benbenlaw.casting.config.CastingConfig;
import com.benbenlaw.casting.config.EquipmentModifierConfig;
import com.benbenlaw.casting.fluid.CastingFluids;
import com.benbenlaw.casting.item.CastingCreativeModeTab;
import com.benbenlaw.casting.item.CastingDataComponents;
import com.benbenlaw.casting.item.CastingItems;
import com.benbenlaw.casting.item.EquipmentModifierItems;
import com.benbenlaw.casting.network.CastingMessages;
import com.benbenlaw.casting.recipe.CastingRecipes;
import com.benbenlaw.casting.screen.CastingMenuTypes;
import com.benbenlaw.casting.screen.EquipmentModifierScreen;
import com.benbenlaw.casting.screen.MixerScreen;
import com.benbenlaw.casting.screen.SmelterScreen;
import com.benbenlaw.casting.screen.SolidifierScreen;
import com.benbenlaw.casting.screen.multiblock.MultiblockControllerScreen;
import com.benbenlaw.casting.screen.multiblock.MultiblockCoolantTankScreen;
import com.benbenlaw.casting.screen.multiblock.MultiblockFuelTankScreen;
import com.benbenlaw.casting.screen.multiblock.MultiblockMixerScreen;
import com.benbenlaw.casting.screen.multiblock.MultiblockSolidifierScreen;
import com.benbenlaw.casting.screen.multiblock.MultiblockValveScreen;
import com.benbenlaw.casting.util.CastingColorHandler;
import com.benbenlaw.core.fluid.FluidDeferredRegister;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;

@Mod(value="casting")
public class Casting {
    public static final String MOD_ID = "casting";

    public Casting(IEventBus modEventBus, ModContainer modContainer) {
        CastingItems.ITEMS.register(modEventBus);
        CastingCreativeModeTab.CREATIVE_MODE_TABS.register(modEventBus);
        EquipmentModifierItems.ITEMS.register(modEventBus);
        CastingDataComponents.COMPONENTS.register(modEventBus);
        CastingBlocks.BLOCKS.register(modEventBus);
        CastingBlockEntities.BLOCK_ENTITIES.register(modEventBus);
        CastingFluids.FLUIDS.register(modEventBus);
        modEventBus.addListener(this::registerCapabilities);
        CastingMenuTypes.MENUS.register(modEventBus);
        CastingRecipes.TYPES.register(modEventBus);
        CastingRecipes.SERIALIZER.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)EquipmentModifierConfig.SPEC, "bbl/casting/tool_modifiers.toml");
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BeheadingConfig.SPEC, "bbl/casting/beheading.toml");
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CastingConfig.SPEC, "bbl/casting/common.toml");
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.register((Object)new CastingColorHandler());
        }
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::beheadingSetup);
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        CastingBlockEntities.registerCapabilities(event);
    }

    @SubscribeEvent
    public void beheadingSetup(FMLClientSetupEvent event) {
    }

    public void commonSetup(RegisterPayloadHandlersEvent event) {
        CastingMessages.registerNetworking(event);
    }

    @EventBusSubscriber(modid="casting", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)CastingBlockEntities.MULTIBLOCK_FUEL_TANK_BLOCK_ENTITY.get(), MultiblockFuelTankBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)CastingBlockEntities.MULTIBLOCK_COOLANT_TANK_BLOCK_ENTITY.get(), MultiblockCoolantTankBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)CastingBlockEntities.TANK_BLOCK_ENTITY.get(), TankBlockEntityRenderer::new);
        }

        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)CastingMenuTypes.MULTIBLOCK_CONTROLLER_MENU.get(), MultiblockControllerScreen::new);
            event.register((MenuType)CastingMenuTypes.MULTIBLOCK_FUEL_TANK_MENU.get(), MultiblockFuelTankScreen::new);
            event.register((MenuType)CastingMenuTypes.MULTIBLOCK_COOLANT_TANK_MENU.get(), MultiblockCoolantTankScreen::new);
            event.register((MenuType)CastingMenuTypes.MULTIBLOCK_SOLIDIFIER_MENU.get(), MultiblockSolidifierScreen::new);
            event.register((MenuType)CastingMenuTypes.MULTIBLOCK_VALVE_MENU.get(), MultiblockValveScreen::new);
            event.register((MenuType)CastingMenuTypes.MULTIBLOCK_MIXER_MENU.get(), MultiblockMixerScreen::new);
            event.register((MenuType)CastingMenuTypes.SMELTER_MENU.get(), SmelterScreen::new);
            event.register((MenuType)CastingMenuTypes.SOLIDIFIER_MENU.get(), SolidifierScreen::new);
            event.register((MenuType)CastingMenuTypes.MIXER_MENU.get(), MixerScreen::new);
            event.register((MenuType)CastingMenuTypes.EQUIPMENT_MODIFIER_MENU.get(), EquipmentModifierScreen::new);
        }

        @SubscribeEvent
        public static void onClientExtensions(RegisterClientExtensionsEvent event) {
            CastingFluids.FLUIDS_MAP.values().forEach(fluid -> {
                FluidDeferredRegister.CoreFluidTypes fluidType = (FluidDeferredRegister.CoreFluidTypes)fluid.getFluidType();
                IClientFluidTypeExtensions extensions = fluidType.getClientExtensions();
                event.registerFluidType(extensions, new FluidType[]{fluidType});
            });
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {});
        }
    }
}

