/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.screen;

import com.benbenlaw.casting.block.CastingBlocks;
import com.benbenlaw.casting.item.CastingItems;
import com.benbenlaw.casting.network.payload.ClearTankPayload;
import com.benbenlaw.casting.network.payload.FluidMoverPayload;
import com.benbenlaw.casting.screen.MixerMenu;
import com.benbenlaw.casting.screen.SolidifierScreen;
import com.benbenlaw.casting.screen.util.FluidStackWidgetBigTank;
import com.benbenlaw.core.util.MouseUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class MixerScreen
extends AbstractContainerScreen<MixerMenu> {
    Level level;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"textures/gui/mixer_gui.png");

    public MixerScreen(MixerMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.level = menu.level;
    }

    protected void init() {
        super.init();
        this.addFluidWidgets();
    }

    public void addFluidWidgets() {
        this.addRenderableOnly((Renderable)new FluidStackWidgetBigTank((Screen)this, ((MixerMenu)this.getMenu()).blockEntity.TANK_1, this.leftPos + 9, this.topPos + 15, 14, 56));
        this.addRenderableOnly((Renderable)new FluidStackWidgetBigTank((Screen)this, ((MixerMenu)this.getMenu()).blockEntity.TANK_2, this.leftPos + 27, this.topPos + 15, 14, 56));
        this.addRenderableOnly((Renderable)new FluidStackWidgetBigTank((Screen)this, ((MixerMenu)this.getMenu()).blockEntity.TANK_3, this.leftPos + 45, this.topPos + 15, 14, 56));
        this.addRenderableOnly((Renderable)new FluidStackWidgetBigTank((Screen)this, ((MixerMenu)this.getMenu()).blockEntity.TANK_4, this.leftPos + 63, this.topPos + 15, 14, 56));
        this.addRenderableOnly((Renderable)new FluidStackWidgetBigTank((Screen)this, ((MixerMenu)this.getMenu()).blockEntity.TANK_5, this.leftPos + 81, this.topPos + 15, 14, 56));
        this.addRenderableOnly((Renderable)new FluidStackWidgetBigTank((Screen)this, ((MixerMenu)this.getMenu()).blockEntity.TANK_6, this.leftPos + 99, this.topPos + 15, 14, 56));
        this.addRenderableOnly((Renderable)new FluidStackWidgetBigTank((Screen)this, ((MixerMenu)this.getMenu()).blockEntity.OUTPUT_TANK, this.leftPos + 153, this.topPos + 15, 14, 56));
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        this.renderProgressBars(guiGraphics);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderProgressBars(guiGraphics);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderWarning(guiGraphics, mouseX, mouseY);
        this.renderNoWhisks(guiGraphics, mouseX, mouseY, this.leftPos, this.topPos);
        this.renderWhisks(guiGraphics, mouseX, mouseY, this.leftPos, this.topPos);
    }

    private void renderNoWhisks(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        int whiskTotal = ((MixerMenu)this.menu).blockEntity.totalWhisksAbove;
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)126, (int)55, (int)16, (int)16) && whiskTotal == 0) {
            guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)"Place Mixer Whisks above the mixer to speed up!").withStyle(ChatFormatting.RED), mouseX, mouseY);
        }
    }

    private void renderWhisks(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        int whiskTotal = ((MixerMenu)this.menu).blockEntity.totalWhisksAbove;
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)126, (int)55, (int)16, (int)16) && whiskTotal > 0) {
            guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)("Ticks Per Recipe: " + ((MixerMenu)this.menu).blockEntity.maxProgress)).withStyle(ChatFormatting.WHITE), mouseX, mouseY);
        }
        guiGraphics.renderItemDecorations(this.font, new ItemStack((ItemLike)CastingBlocks.MIXER_WHISK.get(), whiskTotal), x + 126, y + 55);
        guiGraphics.renderFakeItem(new ItemStack((ItemLike)CastingBlocks.MIXER_WHISK.get(), whiskTotal), this.leftPos + 126, this.topPos + 55);
    }

    private void renderWhiskAmount(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)126, (int)55, (int)16, (int)16)) {
            guiGraphics.drawString(this.font, ((MixerMenu)this.menu).blockEntity.maxProgress + " ticks", this.leftPos + 126, this.topPos + 27, 0x3F3F3F, false);
        }
    }

    private void renderProgressBars(GuiGraphics guiGraphics) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x + 122, y + 34, 176, 30, ((MixerMenu)this.menu).getScaledProgress(), 16);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean handled = super.mouseClicked(mouseX, mouseY, mouseButton);
        ItemStack heldItem = ((MixerMenu)this.menu).getCarried();
        boolean isHoldingBucket = heldItem.is(CastingItems.FLUID_MOVER);
        int tankWidth = 14;
        int tankHeight = 56;
        for (int i = 1; i <= 6; ++i) {
            int tankX = this.leftPos + 9 + (i - 1) * 18;
            int tankY = this.topPos + 15;
            if (!MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX, (int)tankY, (int)tankWidth, (int)tankHeight)) continue;
            boolean hasShiftDown = SolidifierScreen.hasShiftDown();
            if (isHoldingBucket) {
                PacketDistributor.sendToServer((CustomPacketPayload)new FluidMoverPayload(((MixerMenu)this.menu).blockEntity.getBlockPos(), i), (CustomPacketPayload[])new CustomPacketPayload[0]);
                continue;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new ClearTankPayload(((MixerMenu)this.menu).blockEntity.getBlockPos(), hasShiftDown, i), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        int tank7X = this.leftPos + 153;
        int tank7Y = this.topPos + 15;
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tank7X, (int)tank7Y, (int)tankWidth, (int)tankHeight)) {
            boolean hasShiftDown = SolidifierScreen.hasShiftDown();
            if (isHoldingBucket) {
                PacketDistributor.sendToServer((CustomPacketPayload)new FluidMoverPayload(((MixerMenu)this.menu).blockEntity.getBlockPos(), 7), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                PacketDistributor.sendToServer((CustomPacketPayload)new ClearTankPayload(((MixerMenu)this.menu).blockEntity.getBlockPos(), hasShiftDown, 7), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        return handled;
    }

    private void renderWarning(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int tankX_1 = this.leftPos + 9;
        int tankY_1 = this.topPos + 15;
        int tankX_2 = this.leftPos + 27;
        int tankY_2 = this.topPos + 15;
        int tankX_3 = this.leftPos + 45;
        int tankY_3 = this.topPos + 15;
        int tankX_4 = this.leftPos + 63;
        int tankY_4 = this.topPos + 15;
        int tankX_5 = this.leftPos + 81;
        int tankY_5 = this.topPos + 15;
        int tankX_6 = this.leftPos + 99;
        int tankY_6 = this.topPos + 15;
        int tankX_7 = this.leftPos + 153;
        int tankY_7 = this.topPos + 15;
        int tankWidth = 14;
        int tankHeight = 56;
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX_1, (int)tankY_1, (int)tankWidth, (int)tankHeight) && SolidifierScreen.hasShiftDown()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.casting.warning").withStyle(ChatFormatting.RED), mouseX, mouseY - 14);
        }
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX_2, (int)tankY_2, (int)tankWidth, (int)tankHeight) && SolidifierScreen.hasShiftDown()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.casting.warning").withStyle(ChatFormatting.RED), mouseX, mouseY - 14);
        }
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX_3, (int)tankY_3, (int)tankWidth, (int)tankHeight) && SolidifierScreen.hasShiftDown()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.casting.warning").withStyle(ChatFormatting.RED), mouseX, mouseY - 14);
        }
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX_4, (int)tankY_4, (int)tankWidth, (int)tankHeight) && SolidifierScreen.hasShiftDown()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.casting.warning").withStyle(ChatFormatting.RED), mouseX, mouseY - 14);
        }
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX_5, (int)tankY_5, (int)tankWidth, (int)tankHeight) && SolidifierScreen.hasShiftDown()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.casting.warning").withStyle(ChatFormatting.RED), mouseX, mouseY - 14);
        }
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX_6, (int)tankY_6, (int)tankWidth, (int)tankHeight) && SolidifierScreen.hasShiftDown()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.casting.warning").withStyle(ChatFormatting.RED), mouseX, mouseY - 14);
        }
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX_7, (int)tankY_7, (int)tankWidth, (int)tankHeight) && SolidifierScreen.hasShiftDown()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.casting.warning").withStyle(ChatFormatting.RED), mouseX, mouseY - 14);
        }
    }
}

