/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.screen.controller;

import com.benbenlaw.casting.block.CastingBlocks;
import com.benbenlaw.casting.block.entity.ControllerBlockEntity;
import com.benbenlaw.casting.screen.CastingMenuTypes;
import com.benbenlaw.opolisutilities.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

/*
 * Exception performing whole class analysis ignored.
 */
public class ControllerMenu
extends AbstractContainerMenu {
    protected ControllerBlockEntity blockEntity;
    protected Level level;
    protected ContainerData data;
    protected Player player;
    protected BlockPos blockPos;
    protected ItemStackHandler handler;
    public final int TE_INVENTORY_SLOT_COUNT = 16;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;

    public ControllerMenu(int containerID, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerID, inventory, extraData.readBlockPos(), (ContainerData)new SimpleContainerData(30));
    }

    public ControllerMenu(int containerID, Inventory inventory, BlockPos blockPos, ContainerData data) {
        super((MenuType)CastingMenuTypes.CONTROLLER_MENU.get(), containerID);
        this.player = inventory.player;
        this.blockPos = blockPos;
        this.level = inventory.player.level();
        this.data = data;
        this.blockEntity = (ControllerBlockEntity)this.level.getBlockEntity(blockPos);
        assert (this.blockEntity != null);
        this.handler = this.blockEntity.getItemStackHandler();
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        int totalSlots = this.handler.getSlots();
        for (int slot = 0; slot < totalSlots; ++slot) {
            int row = slot / 5;
            int col = slot % 5;
            int x = 12 + col * 19;
            int y = 16 + row * 19;
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.handler, slot, x, y));
            System.out.println("Adding slot " + slot + " at (" + x + ", " + y + ")");
        }
        this.addDataSlots(data);
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public int getScaledProgress(int slotIndex) {
        int progress = this.data.get(slotIndex);
        int maxProgress = this.blockEntity.maxProgress[slotIndex];
        int progressBarWidth = 19;
        return maxProgress != 0 && progress != 0 ? progress * progressBarWidth / maxProgress : 0;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 52, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 52) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(@NotNull Player player) {
        if (player.getItemInHand(player.getUsedItemHand()).is((Holder)ModItems.PORTABLE_GUI)) {
            return true;
        }
        return ControllerMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.blockPos), (Player)player, (Block)((Block)CastingBlocks.CONTROLLER.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 86 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 144));
        }
    }
}

