/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.block.entity.multiblock;

import com.benbenlaw.casting.block.CastingBlocks;
import com.benbenlaw.casting.block.entity.CastingBlockEntities;
import com.benbenlaw.casting.block.entity.multiblock.MultiblockControllerBlockEntity;
import com.benbenlaw.casting.block.multiblock.MultiblockValveBlock;
import com.benbenlaw.casting.screen.multiblock.MultiblockFuelTankMenu;
import com.benbenlaw.casting.util.MultiFluidTankSharedCapacity;
import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import com.benbenlaw.core.block.entity.handler.IInventoryHandlingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiblockValveBlockEntity
extends SyncableBlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    public final ContainerData data = new ContainerData(this){

        public int get(int p_39284_) {
            return 0;
        }

        public void set(int p_39285_, int p_39286_) {
        }

        public int getCount() {
            return 0;
        }
    };
    public String selectedFluidString;
    public MultiblockControllerBlockEntity controller;
    public BlockPos controllerPos;

    public MultiblockValveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CastingBlockEntities.MULTIBLOCK_VALVE_BLOCK_ENTITY.get(), pos, state);
    }

    public void setHandler(ItemStackHandler itemStackHandler) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            this.controller.itemHandler.setStackInSlot(i, itemStackHandler.getStackInSlot(i));
        }
    }

    public ItemStackHandler getItemStackHandler() {
        if (this.controller == null && this.controllerPos != null && this.level != null) {
            this.controller = (MultiblockControllerBlockEntity)this.level.getBlockEntity(this.controllerPos);
        }
        assert (this.controller != null);
        return this.controller.itemHandler;
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        BlockEntity be;
        if (this.controller == null && this.controllerPos != null && this.level != null && (be = this.level.getBlockEntity(this.controllerPos)) instanceof MultiblockControllerBlockEntity) {
            MultiblockControllerBlockEntity controllerEntity;
            this.controller = controllerEntity = (MultiblockControllerBlockEntity)be;
        }
        if (this.controller != null) {
            return this.controller.controllerItemHandler;
        }
        return null;
    }

    public IFluidHandler getFilteredFluidHandler(Direction side) {
        return new IFluidHandler(){

            private MultiblockControllerBlockEntity getCurrentController() {
                return MultiblockValveBlockEntity.this.getController();
            }

            private IFluidHandler getOriginalHandler() {
                MultiblockControllerBlockEntity controller = this.getCurrentController();
                return controller != null ? controller.fluidHandler : null;
            }

            public int getTanks() {
                IFluidHandler handler = this.getOriginalHandler();
                return handler != null ? handler.getTanks() : 0;
            }

            @NotNull
            public FluidStack getFluidInTank(int tank) {
                IFluidHandler handler = this.getOriginalHandler();
                return handler != null ? handler.getFluidInTank(tank) : FluidStack.EMPTY;
            }

            public int getTankCapacity(int tank) {
                IFluidHandler handler = this.getOriginalHandler();
                return handler != null ? handler.getTankCapacity(tank) : 0;
            }

            private boolean isFiltering() {
                return MultiblockValveBlockEntity.this.selectedFluidString != null && !MultiblockValveBlockEntity.this.selectedFluidString.equals("minecraft:empty");
            }

            private boolean isSelectedFluid(FluidStack stack) {
                if (stack.isEmpty()) {
                    return false;
                }
                if (!this.isFiltering()) {
                    return true;
                }
                String fluidName = stack.getFluid().toString();
                return fluidName.equals(MultiblockValveBlockEntity.this.selectedFluidString);
            }

            public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
                return this.isSelectedFluid(stack);
            }

            private void setWorkingState() {
                BlockState state = MultiblockValveBlockEntity.this.getBlockState();
                if (!((Boolean)state.getValue((Property)MultiblockValveBlock.WORKING)).booleanValue()) {
                    assert (MultiblockValveBlockEntity.this.level != null);
                    MultiblockValveBlockEntity.this.level.setBlock(MultiblockValveBlockEntity.this.getBlockPos(), (BlockState)state.setValue((Property)MultiblockValveBlock.WORKING, (Comparable)Boolean.valueOf(true)), 3);
                }
            }

            private boolean isEnabled() {
                BlockState state = MultiblockValveBlockEntity.this.getBlockState();
                return (Boolean)state.getValue((Property)MultiblockValveBlock.ENABLED);
            }

            public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
                if (!this.isEnabled() || resource.isEmpty() || !this.isSelectedFluid(resource)) {
                    return 0;
                }
                IFluidHandler handler = this.getOriginalHandler();
                if (handler == null) {
                    return 0;
                }
                int filled = handler.fill(resource, action);
                if (filled > 0) {
                    this.setWorkingState();
                }
                return filled;
            }

            @NotNull
            public FluidStack drain(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
                if (!this.isEnabled() || resource.isEmpty() || !this.isSelectedFluid(resource)) {
                    return FluidStack.EMPTY;
                }
                IFluidHandler handler = this.getOriginalHandler();
                if (handler == null) {
                    return FluidStack.EMPTY;
                }
                FluidStack drained = handler.drain(resource, action);
                if (!drained.isEmpty()) {
                    this.setWorkingState();
                }
                return drained;
            }

            @NotNull
            public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
                if (!this.isEnabled()) {
                    return FluidStack.EMPTY;
                }
                IFluidHandler handler = this.getOriginalHandler();
                if (handler == null) {
                    return FluidStack.EMPTY;
                }
                if (!this.isFiltering()) {
                    FluidStack drained = handler.drain(maxDrain, action);
                    if (!drained.isEmpty()) {
                        this.setWorkingState();
                    }
                    return drained;
                }
                if (handler instanceof MultiFluidTankSharedCapacity) {
                    MultiFluidTankSharedCapacity multiTank = (MultiFluidTankSharedCapacity)handler;
                    for (int tank = 0; tank < multiTank.getTanks(); ++tank) {
                        FluidStack drained;
                        FluidStack stackInTank = multiTank.getFluidInTank(tank);
                        if (!this.isSelectedFluid(stackInTank) || (drained = multiTank.drain(tank, maxDrain, action)).isEmpty()) continue;
                        this.setWorkingState();
                        return drained;
                    }
                }
                return FluidStack.EMPTY;
            }
        };
    }

    @NotNull
    public Component getDisplayName() {
        return ((Block)CastingBlocks.MULTIBLOCK_FUEL_TANK.get()).getName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new MultiblockFuelTankMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public void tick() {
        assert (this.level != null);
        if (this.controller != null && this.controller.isRemoved()) {
            this.controller = null;
        }
        if (!this.level.isClientSide()) {
            this.sync();
            BlockState state = this.getBlockState();
            if (((Boolean)state.getValue((Property)MultiblockValveBlock.WORKING)).booleanValue()) {
                this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)MultiblockValveBlock.WORKING, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    public IFluidHandler getFluidHandlerCapability(Direction side) {
        return this.getFilteredFluidHandler(side);
    }

    public void setControllerBlockEntity(MultiblockControllerBlockEntity entity) {
        this.controller = entity;
    }

    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
        this.controller = null;
        if (this.level != null) {
            this.setChanged();
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void setSelectedFluid(String fluid) {
        this.selectedFluidString = fluid;
    }

    private MultiblockControllerBlockEntity getController() {
        BlockEntity be;
        if (this.controller != null && this.controller.isRemoved()) {
            this.controller = null;
        }
        if (this.controller == null && this.controllerPos != null && this.level != null && (be = this.level.getBlockEntity(this.controllerPos)) instanceof MultiblockControllerBlockEntity) {
            MultiblockControllerBlockEntity controllerEntity;
            this.controller = controllerEntity = (MultiblockControllerBlockEntity)be;
        }
        return this.controller;
    }

    public void refreshController() {
        if (this.level != null && this.controllerPos != null) {
            MultiblockControllerBlockEntity controllerEntity;
            BlockEntity be = this.level.getBlockEntity(this.controllerPos);
            this.controller = be instanceof MultiblockControllerBlockEntity ? (controllerEntity = (MultiblockControllerBlockEntity)be) : null;
        }
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        if (this.selectedFluidString == null) {
            this.selectedFluidString = "minecraft:empty";
        } else {
            compoundTag.putString("selectedFluidString", this.selectedFluidString);
        }
        if (this.controllerPos != null) {
            compoundTag.putInt("controllerPosX", this.controllerPos.getX());
            compoundTag.putInt("controllerPosY", this.controllerPos.getY());
            compoundTag.putInt("controllerPosZ", this.controllerPos.getZ());
        }
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        BlockEntity be;
        this.selectedFluidString = compoundTag.contains("selectedFluidString") ? compoundTag.getString("selectedFluidString") : "minecraft:empty";
        this.controllerPos = compoundTag.contains("controllerPosX") && compoundTag.contains("controllerPosY") && compoundTag.contains("controllerPosZ") ? new BlockPos(compoundTag.getInt("controllerPosX"), compoundTag.getInt("controllerPosY"), compoundTag.getInt("controllerPosZ")) : null;
        if (this.controllerPos != null && this.level != null && (be = this.level.getBlockEntity(this.controllerPos)) instanceof MultiblockControllerBlockEntity) {
            MultiblockControllerBlockEntity controllerEntity;
            this.controller = controllerEntity = (MultiblockControllerBlockEntity)be;
        }
        super.loadAdditional(compoundTag, provider);
    }

    public boolean onPlayerUse(Player player, InteractionHand hand) {
        MultiblockControllerBlockEntity controllerBlockEntity = this.getController();
        if (controllerBlockEntity != null) {
            return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)controllerBlockEntity.fluidHandler);
        }
        System.out.println("Controller is null, cannot interact with fluid handler");
        return false;
    }
}

