/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.data;

import com.benbenlaw.casting.data.CastingBlockStatesProvider;
import com.benbenlaw.casting.data.CastingBlockTags;
import com.benbenlaw.casting.data.CastingFluidTags;
import com.benbenlaw.casting.data.CastingItemModelProvider;
import com.benbenlaw.casting.data.CastingItemTags;
import com.benbenlaw.casting.data.CastingLangProvider;
import com.benbenlaw.casting.data.CastingLootTableProvider;
import com.benbenlaw.casting.data.CastingRecipeProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="casting", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new CastingRecipeProvider(packOutput, event.getLookupProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(CastingLootTableProvider::new, LootContextParamSets.BLOCK)), event.getLookupProvider()));
        CastingBlockTags blockTags = new CastingBlockTags(packOutput, lookupProvider, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        CastingItemTags itemTags = new CastingItemTags(packOutput, lookupProvider, blockTags, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)itemTags);
        CastingFluidTags fluidTags = new CastingFluidTags(packOutput, lookupProvider, "casting", event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)fluidTags);
        generator.addProvider(event.includeClient(), (DataProvider)new CastingItemModelProvider(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new CastingBlockStatesProvider(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new CastingLangProvider(packOutput, event.getExistingFileHelper()));
    }
}

