/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.data.recipes;

import com.benbenlaw.casting.recipe.CoolantRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoolantRecipeBuilder
implements RecipeBuilder {
    protected String group;
    protected FluidStack fluid;
    protected int duration;
    protected final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public CoolantRecipeBuilder(FluidStack fluid, int duration) {
        this.fluid = fluid;
        this.duration = duration;
    }

    public static CoolantRecipeBuilder coolantRecipesBuilder(FluidStack fluid, int duration) {
        return new CoolantRecipeBuilder(fluid, duration);
    }

    @NotNull
    public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    @NotNull
    public RecipeBuilder group(@Nullable String groupName) {
        this.group = groupName;
        return this;
    }

    public Item getResult() {
        return ItemStack.EMPTY.getItem();
    }

    public void save(@NotNull RecipeOutput recipeOutput) {
        this.save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"casting", (String)("coolant/" + BuiltInRegistries.FLUID.getKey((Object)this.fluid.getFluid()).getPath())));
    }

    public void save(@NotNull RecipeOutput recipeOutput, @NotNull ResourceLocation id) {
        Advancement.Builder builder = Advancement.Builder.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        CoolantRecipe coolantRecipe = new CoolantRecipe(this.fluid, this.duration);
        recipeOutput.accept(id, (Recipe)coolantRecipe, builder.build(id.withPrefix("recipes/coolant/")));
    }
}

