/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.item;

import com.benbenlaw.casting.config.EquipmentModifierConfig;
import com.benbenlaw.casting.item.EquipmentModifierItem;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public enum EquipmentModifier {
    SILK_TOUCH("silk_touch", (Codec<?>)Codec.BOOL, ByteBufCodecs.BOOL, () -> 1),
    EFFICIENCY("efficiency", (Codec<?>)Codec.INT, ByteBufCodecs.INT, (Supplier<Integer>)EquipmentModifierConfig.maxEfficiencyAmount),
    FORTUNE("fortune", (Codec<?>)Codec.INT, ByteBufCodecs.INT, (Supplier<Integer>)EquipmentModifierConfig.maxFortuneAmount),
    UNBREAKING("unbreaking", (Codec<?>)Codec.INT, ByteBufCodecs.INT, (Supplier<Integer>)EquipmentModifierConfig.maxUnbreakingAmount),
    REPAIRING("repairing", (Codec<?>)Codec.INT, ByteBufCodecs.INT, (Supplier<Integer>)EquipmentModifierConfig.maxRepairingAmount),
    TORCH_PLACING("torch_placing", (Codec<?>)Codec.BOOL, ByteBufCodecs.BOOL, () -> 1),
    AUTO_SMELT("auto_smelt", (Codec<?>)Codec.BOOL, ByteBufCodecs.BOOL, () -> 1),
    LOOTING("looting", (Codec<?>)Codec.INT, ByteBufCodecs.INT, (Supplier<Integer>)EquipmentModifierConfig.maxLootingAmount),
    SHARPNESS("sharpness", (Codec<?>)Codec.INT, ByteBufCodecs.INT, (Supplier<Integer>)EquipmentModifierConfig.maxSharpnessAmount),
    BEHEADING("beheading", (Codec<?>)Codec.BOOL, ByteBufCodecs.BOOL, () -> 1),
    LIFESTEAL("lifesteal", (Codec<?>)Codec.INT, ByteBufCodecs.INT, (Supplier<Integer>)EquipmentModifierConfig.maxLifestealAmount),
    KNOCKBACK("knockback", (Codec<?>)Codec.INT, ByteBufCodecs.INT, (Supplier<Integer>)EquipmentModifierConfig.maxKnockbackAmount),
    IGNITE("ignite", (Codec<?>)Codec.INT, ByteBufCodecs.INT, (Supplier<Integer>)EquipmentModifierConfig.maxIgniteAmount),
    EXCAVATION("excavation", (Codec<?>)Codec.INT, ByteBufCodecs.INT, (Supplier<Integer>)EquipmentModifierConfig.maxExcavationAmount),
    TELEPORTING("teleporting", (Codec<?>)Codec.INT, ByteBufCodecs.INT, (Supplier<Integer>)EquipmentModifierConfig.maxTeleportationAmount),
    MAGNET("magnet", (Codec<?>)Codec.INT, ByteBufCodecs.INT, (Supplier<Integer>)EquipmentModifierConfig.maxMagnetAmount),
    PROTECTION("protection", (Codec<?>)Codec.INT, ByteBufCodecs.INT, (Supplier<Integer>)EquipmentModifierConfig.maxProtectionAmount),
    STEP_ASSIST("step_assist", (Codec<?>)Codec.INT, ByteBufCodecs.INT, (Supplier<Integer>)EquipmentModifierConfig.maxStepAssistAmount),
    NIGHT_VISION("night_vision", (Codec<?>)Codec.BOOL, ByteBufCodecs.BOOL, () -> 1),
    WATER_BREATHING("water_breathing", (Codec<?>)Codec.BOOL, ByteBufCodecs.BOOL, () -> 1),
    SPEED("speed", (Codec<?>)Codec.INT, ByteBufCodecs.INT, (Supplier<Integer>)EquipmentModifierConfig.maxSpeedAmount),
    WATER_WALKER("water_walker", (Codec<?>)Codec.BOOL, ByteBufCodecs.BOOL, () -> 1),
    LAVA_WALKER("lava_walker", (Codec<?>)Codec.BOOL, ByteBufCodecs.BOOL, () -> 1),
    FLIGHT("flight", (Codec<?>)Codec.BOOL, ByteBufCodecs.BOOL, () -> 1),
    FEATHER_FALLING("feather_falling", (Codec<?>)Codec.INT, ByteBufCodecs.INT, (Supplier<Integer>)EquipmentModifierConfig.maxFeatherFallingAmount),
    SOULBOUND("soulbound", (Codec<?>)Codec.BOOL, ByteBufCodecs.BOOL, () -> 1),
    JETS("jets", (Codec<?>)Codec.INT, ByteBufCodecs.INT, (Supplier<Integer>)EquipmentModifierConfig.maxJetsAmount),
    EQUIPMENT_LEVEL("equipment_level", (Codec<?>)Codec.INT, ByteBufCodecs.INT, (Supplier<Integer>)EquipmentModifierConfig.maxEquipmentLevel);

    public final String id;
    public final Codec<?> codec;
    public final Object networkCodec;
    public final Supplier<Integer> maxLevel;
    public final String tooltipKey;
    public static final DeferredRegister<Item> ITEMS;
    public DeferredHolder<Item, EquipmentModifierItem> item;
    public static final DeferredRegister<DataComponentType<?>> COMPONENTS;
    public DeferredHolder<DataComponentType<?>, ?> dataComponent;
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> EQUIPMENT_EXPERIENCE;
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> TOGGLEABLE_MODIFIERS;

    private EquipmentModifier(String id, Codec<?> codec, Object networkCodec, Supplier<Integer> maxLevel) {
        this.id = id;
        this.codec = codec;
        this.networkCodec = networkCodec;
        this.maxLevel = maxLevel;
        this.tooltipKey = "tooltips.casting.information." + id;
    }

    public static void registerAllItemModifiers() {
        for (EquipmentModifier modifier : EquipmentModifier.values()) {
            modifier.item = ITEMS.register(modifier.id, () -> new EquipmentModifierItem(new Item.Properties(), modifier.tooltipKey, modifier.maxLevel.get()));
        }
    }

    public static void registerAllDataComponents() {
        for (EquipmentModifier modifier : EquipmentModifier.values()) {
            if (modifier.codec == Codec.BOOL || modifier.networkCodec == ByteBufCodecs.BOOL) {
                modifier.dataComponent = COMPONENTS.register(modifier.id, () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
                continue;
            }
            if (modifier.codec == Codec.INT || modifier.networkCodec == ByteBufCodecs.INT) {
                modifier.dataComponent = COMPONENTS.register(modifier.id, () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
                continue;
            }
            throw new IllegalArgumentException("Unsupported codec type for modifier: " + modifier.id);
        }
    }

    static {
        ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"casting");
        COMPONENTS = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"casting");
        EQUIPMENT_EXPERIENCE = COMPONENTS.register("equipment_experience", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
        TOGGLEABLE_MODIFIERS = COMPONENTS.register("toggleable_modifiers", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    }
}

