/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.item;

import com.benbenlaw.casting.item.CastingDataComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class FluidMoverItem
extends Item {
    public FluidMoverItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack itemStack, @NotNull Item.TooltipContext context, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            if (itemStack.has(CastingDataComponents.FLUID_TYPE)) {
                String fluidAsString = (String)itemStack.get(CastingDataComponents.FLUID_TYPE);
                int fluidAmount = (Integer)itemStack.get(CastingDataComponents.FLUID_AMOUNT);
                assert (fluidAsString != null);
                FluidType fluid = ((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)fluidAsString))).getFluidType();
                components.add((Component)Component.literal((String)"Contains: ").append(fluidAmount + "mb ").append((Component)Component.translatable((String)fluid.getDescriptionId())).withStyle(ChatFormatting.GREEN));
            }
        } else {
            components.add((Component)Component.translatable((String)"tooltips.blocks.with_fluid.shift").withStyle(ChatFormatting.BLUE));
        }
        super.appendHoverText(itemStack, context, components, flag);
    }
}

