/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.multiblock;

import com.benbenlaw.casting.multiblock.MultiblockData;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class CoreMultiblockDetector {
    public static MultiblockData findMultiblock(Level level, BlockPos controllerPos, Block controllerBlock, Predicate<BlockState> wallBlocks, Predicate<BlockState> floorBlocks, Predicate<BlockState> validExtraBlocks, boolean hollow, boolean optionalCorners, int maxVolume, int radius, int maxHeight) {
        List<BlockPos> notAirBlocks;
        BlockPos.MutableBlockPos top = controllerPos.mutable().move(Direction.UP);
        while (top.getY() < level.getMaxBuildHeight() && wallBlocks.test(level.getBlockState((BlockPos)top))) {
            top.move(Direction.UP);
        }
        top.move(Direction.DOWN);
        BlockState controllerState = level.getBlockState(controllerPos);
        if (controllerState.isAir()) {
            return null;
        }
        Direction controllerDirection = (Direction)controllerState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        ArrayList<BlockPos> extraValidBlocks = new ArrayList<BlockPos>();
        Pair<BlockPos, BlockPos> topCorners = CoreMultiblockDetector.findEdges(level, controllerPos, controllerBlock, controllerDirection.getClockWise(), top.immutable(), wallBlocks, validExtraBlocks, optionalCorners, radius, extraValidBlocks);
        if (topCorners == null) {
            return null;
        }
        if (floorBlocks == null) {
            return null;
        }
        BlockPos.MutableBlockPos bottomCorner = ((BlockPos)topCorners.getFirst()).relative(controllerDirection.getOpposite()).relative(controllerDirection.getCounterClockWise()).mutable();
        int height = 0;
        while (height++ < maxHeight && !CoreMultiblockDetector.getExtraBlocks(floorBlocks, wallBlocks).test(level.getBlockState((BlockPos)bottomCorner.move(Direction.DOWN)))) {
        }
        if (!floorBlocks.test(level.getBlockState((BlockPos)bottomCorner))) {
            return null;
        }
        List<BlockPos> notFloorBlocks = BlockPos.betweenClosedStream((BlockPos)((BlockPos)topCorners.getFirst()).relative(controllerDirection.getOpposite()).relative(controllerDirection.getCounterClockWise()).below(height), (BlockPos)((BlockPos)topCorners.getSecond()).relative(controllerDirection).relative(controllerDirection.getClockWise()).below(height)).filter(pos -> !floorBlocks.test(level.getBlockState(pos))).toList();
        if (!notFloorBlocks.isEmpty()) {
            return null;
        }
        for (int slice = 1; slice <= height; ++slice) {
            Pair<BlockPos, BlockPos> corners;
            if (optionalCorners && slice == height || (corners = CoreMultiblockDetector.findEdges(level, controllerPos, controllerBlock, controllerDirection.getClockWise(), top.immutable().below(slice), wallBlocks, validExtraBlocks, optionalCorners, radius, extraValidBlocks)) != null) continue;
            return null;
        }
        int volume = (int)BlockPos.betweenClosedStream((BlockPos)((BlockPos)topCorners.getFirst()).relative(controllerDirection.getOpposite()).relative(controllerDirection.getCounterClockWise()), (BlockPos)((BlockPos)topCorners.getSecond()).relative(controllerDirection).relative(controllerDirection.getClockWise()).below(height - 1)).count();
        if (volume > maxVolume) {
            return null;
        }
        if (hollow && !(notAirBlocks = BlockPos.betweenClosedStream((BlockPos)((BlockPos)topCorners.getFirst()).relative(controllerDirection.getOpposite()).relative(controllerDirection.getCounterClockWise()), (BlockPos)((BlockPos)topCorners.getSecond()).relative(controllerDirection).relative(controllerDirection.getClockWise()).below(height - 1)).filter(pos -> !level.getBlockState(pos).isAir()).toList()).isEmpty()) {
            return null;
        }
        Set<BlockPos> allBlockPositions = BlockPos.betweenClosedStream((BlockPos)((BlockPos)topCorners.getFirst()).relative(Objects.requireNonNull(controllerDirection.getOpposite())).relative(controllerDirection.getCounterClockWise()).below(height - 1), (BlockPos)((BlockPos)topCorners.getSecond()).relative(controllerDirection).relative(controllerDirection.getClockWise()).below(height - 1)).map(BlockPos::immutable).collect(Collectors.toSet());
        allBlockPositions.add(controllerPos);
        return new MultiblockData(controllerPos, topCorners, extraValidBlocks, allBlockPositions, height, volume);
    }

    private static Predicate<BlockState> getExtraBlocks(Predicate<BlockState> floorBlocks, Predicate<BlockState> wallBlocks) {
        return floorBlocks != null ? floorBlocks : wallBlocks;
    }

    private static Pair<BlockPos, BlockPos> findEdges(Level level, BlockPos controllerPos, Block controllerBlock, Direction direction, BlockPos startPos, Predicate<BlockState> validBlocks, Predicate<BlockState> validExtraBlocks, boolean optionalCorners, int radius, List<BlockPos> extraValidBlocks) {
        BlockPos firstCorner = new BlockPos((Vec3i)startPos);
        BlockPos secondCorner = new BlockPos((Vec3i)startPos);
        BlockPos.MutableBlockPos pointer = new BlockPos.MutableBlockPos(startPos.getX(), startPos.getY(), startPos.getZ());
        int turns = 0;
        int maxSize = radius;
        while (turns <= 4 && maxSize-- > 0 && validBlocks.test(level.getBlockState((BlockPos)pointer)) && (turns == 0 || !pointer.equals((Object)startPos))) {
            BlockPos nextPos = pointer.relative(direction);
            BlockState nextBlockState = level.getBlockState(nextPos);
            if (turns < 4 && !validBlocks.test(nextBlockState)) {
                BlockPos cornerCheck = pointer.relative(direction.getClockWise());
                if (optionalCorners && !validBlocks.test(level.getBlockState(cornerCheck))) {
                    pointer.move(direction);
                }
                if (turns == 0) {
                    firstCorner = pointer.immutable();
                }
                if (turns == 2) {
                    secondCorner = pointer.immutable();
                }
                direction = direction.getClockWise();
                ++turns;
            }
            pointer.move(direction);
            BlockState targetState = level.getBlockState((BlockPos)pointer);
            if (validExtraBlocks.test(targetState)) {
                extraValidBlocks.add(pointer.immutable());
            }
            if (!targetState.is(controllerBlock) || pointer.equals((Object)controllerPos)) continue;
            return null;
        }
        if (turns == 4 && pointer.immutable().equals((Object)startPos)) {
            return Pair.of((Object)firstCorner, (Object)secondCorner);
        }
        return null;
    }
}

