/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public record SolidifierRecipe(SizedIngredient mold, SizedIngredient output, FluidStack fluid) implements Recipe<RecipeInput>
{
    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.createWithCapacity((int)1);
        ingredients.add((Object)this.mold.ingredient());
        return ingredients;
    }

    public boolean matches(@NotNull RecipeInput container, @NotNull Level level) {
        return this.mold.test(container.getItem(0));
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput container, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public FluidStack getFluidStack() {
        return this.fluid.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<SolidifierRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<SolidifierRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SizedIngredient.FLAT_CODEC.fieldOf("mold").forGetter(SolidifierRecipe::mold), (App)SizedIngredient.FLAT_CODEC.fieldOf("output").forGetter(SolidifierRecipe::output), (App)FluidStack.CODEC.fieldOf("fluid").forGetter(SolidifierRecipe::fluid)).apply((Applicative)instance, Serializer::createSolidifierRecipe));
        private static final StreamCodec<RegistryFriendlyByteBuf, SolidifierRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<SolidifierRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, SolidifierRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static SolidifierRecipe read(RegistryFriendlyByteBuf buffer) {
            SizedIngredient mold = (SizedIngredient)SizedIngredient.STREAM_CODEC.decode((Object)buffer);
            SizedIngredient output = (SizedIngredient)SizedIngredient.STREAM_CODEC.decode((Object)buffer);
            FluidStack fluid = (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buffer);
            return new SolidifierRecipe(mold, output, fluid);
        }

        private static void write(RegistryFriendlyByteBuf buffer, SolidifierRecipe recipe) {
            SizedIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.mold);
            SizedIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            FluidStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.fluid);
        }

        static SolidifierRecipe createSolidifierRecipe(SizedIngredient mold, SizedIngredient output, FluidStack fluid) {
            return new SolidifierRecipe(mold, output, fluid);
        }
    }

    public static class Type
    implements RecipeType<SolidifierRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

