/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.block.custom;

import com.benbenlaw.casting.block.entity.CastingBlockEntities;
import com.benbenlaw.casting.block.entity.ControllerBlockEntity;
import com.benbenlaw.casting.item.CastingDataComponents;
import com.benbenlaw.casting.screen.SmelterMenu;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControllerBlock
extends BaseEntityBlock {
    public static final MapCodec<ControllerBlock> CODEC = ControllerBlock.simpleCodec(ControllerBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    @NotNull
    public BlockState rotate(BlockState blockState, Rotation pRotation) {
        return (BlockState)((BlockState)blockState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)blockState.getValue((Property)FACING)))).setValue((Property)POWERED, (Comparable)((Boolean)blockState.getValue((Property)POWERED)));
    }

    @NotNull
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return (BlockState)pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING))).setValue((Property)POWERED, (Comparable)((Boolean)pState.getValue((Property)POWERED)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, POWERED});
    }

    public ControllerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.getBlock() != pNewState.getBlock() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof ControllerBlockEntity) {
            ((ControllerBlockEntity)blockEntity).drops();
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (!level.isClientSide()) {
            ControllerBlockEntity controllerBlockEntity = (ControllerBlockEntity)level.getBlockEntity(blockPos);
            if (controllerBlockEntity instanceof ControllerBlockEntity) {
                ContainerData data = controllerBlockEntity.data;
                player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new SmelterMenu(windowId, playerInventory, blockPos, data), (Component)Component.translatable((String)"block.casting.controller")), buf -> buf.writeBlockPos(blockPos));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity entity, ItemStack itemStack) {
        super.setPlacedBy(level, blockPos, blockState, entity, itemStack);
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof ControllerBlockEntity) {
            int outputFluidAmount;
            Fluid outputFluid;
            String outputFluidAsString;
            ControllerBlockEntity controllerBlockEntity = (ControllerBlockEntity)blockEntity;
            if (itemStack.has(CastingDataComponents.OUTPUT_FLUID_1) && itemStack.has(CastingDataComponents.OUTPUT_FLUID_AMOUNT_1)) {
                outputFluidAsString = (String)itemStack.get(CastingDataComponents.OUTPUT_FLUID_1);
                outputFluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)outputFluidAsString));
                outputFluidAmount = (Integer)itemStack.get(CastingDataComponents.OUTPUT_FLUID_AMOUNT_1);
                controllerBlockEntity.setOutputFluid1(new FluidStack(outputFluid, outputFluidAmount));
            }
            if (itemStack.has(CastingDataComponents.OUTPUT_FLUID_2) && itemStack.has(CastingDataComponents.OUTPUT_FLUID_AMOUNT_2)) {
                outputFluidAsString = (String)itemStack.get(CastingDataComponents.OUTPUT_FLUID_2);
                outputFluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)outputFluidAsString));
                outputFluidAmount = (Integer)itemStack.get(CastingDataComponents.OUTPUT_FLUID_AMOUNT_2);
                controllerBlockEntity.setOutputFluid2(new FluidStack(outputFluid, outputFluidAmount));
            }
            if (itemStack.has(CastingDataComponents.OUTPUT_FLUID_3) && itemStack.has(CastingDataComponents.OUTPUT_FLUID_AMOUNT_3)) {
                outputFluidAsString = (String)itemStack.get(CastingDataComponents.OUTPUT_FLUID_3);
                outputFluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)outputFluidAsString));
                outputFluidAmount = (Integer)itemStack.get(CastingDataComponents.OUTPUT_FLUID_AMOUNT_3);
                controllerBlockEntity.setOutputFluid3(new FluidStack(outputFluid, outputFluidAmount));
            }
            if (itemStack.has(CastingDataComponents.OUTPUT_FLUID_4) && itemStack.has(CastingDataComponents.OUTPUT_FLUID_AMOUNT_4)) {
                outputFluidAsString = (String)itemStack.get(CastingDataComponents.OUTPUT_FLUID_4);
                outputFluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)outputFluidAsString));
                outputFluidAmount = (Integer)itemStack.get(CastingDataComponents.OUTPUT_FLUID_AMOUNT_4);
                controllerBlockEntity.setOutputFluid4(new FluidStack(outputFluid, outputFluidAmount));
            }
        }
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity entity, ItemStack stack) {
        if (entity instanceof ControllerBlockEntity) {
            ControllerBlockEntity controllerBlockEntity = (ControllerBlockEntity)entity;
            ItemStack itemStackWithFluids = new ItemStack((ItemLike)this);
            if (controllerBlockEntity.getOutputFluid1().getFluid() != Fluids.EMPTY && controllerBlockEntity.getOutputFluid1().getAmount() > 0) {
                itemStackWithFluids.set(CastingDataComponents.OUTPUT_FLUID_1, (Object)controllerBlockEntity.getOutputFluid1().getFluid().getFluidType().toString());
                itemStackWithFluids.set(CastingDataComponents.OUTPUT_FLUID_AMOUNT_1, (Object)controllerBlockEntity.getOutputFluid1().getAmount());
            }
            if (controllerBlockEntity.getOutputFluid2().getFluid() != Fluids.EMPTY && controllerBlockEntity.getOutputFluid2().getAmount() > 0) {
                itemStackWithFluids.set(CastingDataComponents.OUTPUT_FLUID_2, (Object)controllerBlockEntity.getOutputFluid2().getFluid().getFluidType().toString());
                itemStackWithFluids.set(CastingDataComponents.OUTPUT_FLUID_AMOUNT_2, (Object)controllerBlockEntity.getOutputFluid2().getAmount());
            }
            if (controllerBlockEntity.getOutputFluid3().getFluid() != Fluids.EMPTY && controllerBlockEntity.getOutputFluid3().getAmount() > 0) {
                itemStackWithFluids.set(CastingDataComponents.OUTPUT_FLUID_3, (Object)controllerBlockEntity.getOutputFluid3().getFluid().getFluidType().toString());
                itemStackWithFluids.set(CastingDataComponents.OUTPUT_FLUID_AMOUNT_3, (Object)controllerBlockEntity.getOutputFluid3().getAmount());
            }
            if (controllerBlockEntity.getOutputFluid4().getFluid() != Fluids.EMPTY && controllerBlockEntity.getOutputFluid4().getAmount() > 0) {
                itemStackWithFluids.set(CastingDataComponents.OUTPUT_FLUID_4, (Object)controllerBlockEntity.getOutputFluid4().getFluid().getFluidType().toString());
                itemStackWithFluids.set(CastingDataComponents.OUTPUT_FLUID_AMOUNT_4, (Object)controllerBlockEntity.getOutputFluid4().getAmount());
            }
            ControllerBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)itemStackWithFluids);
        } else {
            ControllerBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)this.asItem().getDefaultInstance());
        }
        super.playerDestroy(level, player, pos, state, entity, stack);
    }

    public void appendHoverText(ItemStack itemStack, @NotNull Item.TooltipContext context, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            FluidType outputFluid;
            int outputFluidAmount;
            String outputFluidAsString;
            if (itemStack.has(CastingDataComponents.OUTPUT_FLUID_1) && itemStack.has(CastingDataComponents.OUTPUT_FLUID_AMOUNT_1)) {
                outputFluidAsString = (String)itemStack.get(CastingDataComponents.OUTPUT_FLUID_1);
                outputFluidAmount = (Integer)itemStack.get(CastingDataComponents.OUTPUT_FLUID_AMOUNT_1);
                outputFluid = ((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)outputFluidAsString))).getFluidType();
                components.add((Component)Component.literal((String)"Tank 1 Contains: ").append(outputFluidAmount + "mb ").append((Component)Component.translatable((String)outputFluid.getDescriptionId())).withStyle(ChatFormatting.GREEN));
            }
            if (itemStack.has(CastingDataComponents.OUTPUT_FLUID_2) && itemStack.has(CastingDataComponents.OUTPUT_FLUID_AMOUNT_2)) {
                outputFluidAsString = (String)itemStack.get(CastingDataComponents.OUTPUT_FLUID_2);
                outputFluidAmount = (Integer)itemStack.get(CastingDataComponents.OUTPUT_FLUID_AMOUNT_2);
                outputFluid = ((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)outputFluidAsString))).getFluidType();
                components.add((Component)Component.literal((String)"Tank 2 Contains: ").append(outputFluidAmount + "mb ").append((Component)Component.translatable((String)outputFluid.getDescriptionId())).withStyle(ChatFormatting.GREEN));
            }
            if (itemStack.has(CastingDataComponents.OUTPUT_FLUID_3) && itemStack.has(CastingDataComponents.OUTPUT_FLUID_AMOUNT_3)) {
                outputFluidAsString = (String)itemStack.get(CastingDataComponents.OUTPUT_FLUID_3);
                outputFluidAmount = (Integer)itemStack.get(CastingDataComponents.OUTPUT_FLUID_AMOUNT_3);
                outputFluid = ((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)outputFluidAsString))).getFluidType();
                components.add((Component)Component.literal((String)"Tank 3 Contains: ").append(outputFluidAmount + "mb ").append((Component)Component.translatable((String)outputFluid.getDescriptionId())).withStyle(ChatFormatting.GREEN));
            }
            if (itemStack.has(CastingDataComponents.OUTPUT_FLUID_4) && itemStack.has(CastingDataComponents.OUTPUT_FLUID_AMOUNT_4)) {
                outputFluidAsString = (String)itemStack.get(CastingDataComponents.OUTPUT_FLUID_4);
                outputFluidAmount = (Integer)itemStack.get(CastingDataComponents.OUTPUT_FLUID_AMOUNT_4);
                outputFluid = ((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)outputFluidAsString))).getFluidType();
                components.add((Component)Component.literal((String)"Tank 4 Contains: ").append(outputFluidAmount + "mb ").append((Component)Component.translatable((String)outputFluid.getDescriptionId())).withStyle(ChatFormatting.GREEN));
            }
        } else if (itemStack.has(CastingDataComponents.OUTPUT_FLUID_1)) {
            components.add((Component)Component.translatable((String)"tooltips.bblcore.shift").withStyle(ChatFormatting.YELLOW));
        }
        super.appendHoverText(itemStack, context, components, flag);
    }

    public void animateTick(BlockState p_221253_, Level p_221254_, BlockPos p_221255_, RandomSource p_221256_) {
        if (((Boolean)p_221253_.getValue((Property)POWERED)).booleanValue()) {
            double d0 = (double)p_221255_.getX() + 0.5;
            double d1 = p_221255_.getY();
            double d2 = (double)p_221255_.getZ() + 0.5;
            if (p_221256_.nextDouble() < 0.1) {
                p_221254_.playLocalSound(d0, d1, d2, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)p_221253_.getValue((Property)FACING);
            Direction.Axis direction$axis = direction.getAxis();
            double d3 = 0.52;
            double d4 = p_221256_.nextDouble() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.getStepX() * 0.52 : d4;
            double d6 = p_221256_.nextDouble() * 6.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.52 : d4;
            p_221254_.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            p_221254_.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ControllerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        return ControllerBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)CastingBlockEntities.CONTROLLER_BLOCK_ENTITY.get()), (world, blockPos, thisBlockState, blockEntity) -> blockEntity.tick());
    }
}

