/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.block.entity.multiblock;

import com.benbenlaw.casting.block.CastingBlocks;
import com.benbenlaw.casting.block.entity.CastingBlockEntities;
import com.benbenlaw.casting.block.entity.multiblock.MultiblockControllerBlockEntity;
import com.benbenlaw.casting.block.multiblock.MultiblockMixerBlock;
import com.benbenlaw.casting.recipe.MixingRecipe;
import com.benbenlaw.casting.screen.multiblock.MultiblockFuelTankMenu;
import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import com.benbenlaw.core.recipe.NoInventoryRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiblockMixerBlockEntity
extends SyncableBlockEntity
implements MenuProvider {
    public final ContainerData data;
    public String selectedFluidString;
    public MultiblockControllerBlockEntity controller;
    public BlockPos controllerPos;
    public List<String> availableAlloys = new ArrayList<String>();

    public MultiblockMixerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CastingBlockEntities.MULTIBLOCK_MIXER_BLOCK_ENTITY.get(), pos, state);
        this.data = new ContainerData(this){

            public int get(int p_39284_) {
                return 0;
            }

            public void set(int p_39285_, int p_39286_) {
            }

            public int getCount() {
                return 0;
            }
        };
    }

    @NotNull
    public Component getDisplayName() {
        return ((Block)CastingBlocks.MULTIBLOCK_FUEL_TANK.get()).getName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new MultiblockFuelTankMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public void tick() {
        assert (this.level != null);
        if (this.controller != null && this.controller.isRemoved()) {
            this.controller.fluidHandler = null;
            this.controller = null;
            return;
        }
        if (!this.level.isClientSide()) {
            this.sync();
            if (this.controller != null) {
                this.findMixerRecipes();
                this.craftAlloy();
            }
        }
    }

    public void findMixerRecipes() {
        assert (this.level != null);
        this.availableAlloys.clear();
        if (this.controller == null) {
            return;
        }
        for (RecipeHolder recipeHolder : this.level.getRecipeManager().getRecipesFor((RecipeType)MixingRecipe.Type.INSTANCE, (RecipeInput)NoInventoryRecipe.INSTANCE, this.level)) {
            MixingRecipe recipe = (MixingRecipe)recipeHolder.value();
            List<FluidStack> recipeFluids = recipe.getAllFluids();
            List<FluidStack> controllerFluids = this.controller.fluidHandler.getFluids();
            boolean allFluidsPresent = true;
            for (FluidStack requiredFluid : recipeFluids) {
                boolean found = false;
                for (FluidStack controllerFluid : controllerFluids) {
                    if (!FluidStack.isSameFluid((FluidStack)controllerFluid, (FluidStack)requiredFluid) || controllerFluid.getAmount() < requiredFluid.getAmount()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                allFluidsPresent = false;
                break;
            }
            if (!allFluidsPresent) continue;
            this.availableAlloys.add(recipe.outputFluid().getFluid().toString());
        }
    }

    public void craftAlloy() {
        BlockState currentState;
        if (!((Boolean)this.getBlockState().getValue((Property)MultiblockMixerBlock.ENABLED)).booleanValue()) {
            return;
        }
        boolean didCraft = false;
        assert (this.level != null);
        for (RecipeHolder recipeHolder : this.level.getRecipeManager().getRecipesFor((RecipeType)MixingRecipe.Type.INSTANCE, (RecipeInput)NoInventoryRecipe.INSTANCE, this.level)) {
            MixingRecipe recipe = (MixingRecipe)recipeHolder.value();
            List<FluidStack> recipeFluids = recipe.getAllFluids();
            List<FluidStack> controllerFluids = this.controller.fluidHandler.getFluids();
            boolean canCraft = true;
            if (!recipe.outputFluid().getFluid().toString().contains(this.selectedFluidString)) continue;
            for (FluidStack requiredFluid : recipeFluids) {
                boolean found = false;
                for (FluidStack controllerFluid : controllerFluids) {
                    if (!FluidStack.isSameFluid((FluidStack)controllerFluid, (FluidStack)requiredFluid) || controllerFluid.getAmount() < requiredFluid.getAmount()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                canCraft = false;
                break;
            }
            if (!canCraft) continue;
            for (FluidStack requiredFluid : recipeFluids) {
                this.controller.fluidHandler.drain(requiredFluid, IFluidHandler.FluidAction.EXECUTE);
            }
            this.controller.fluidHandler.fill(recipe.outputFluid(), IFluidHandler.FluidAction.EXECUTE);
            didCraft = true;
            break;
        }
        if ((Boolean)(currentState = this.getBlockState()).getValue((Property)MultiblockMixerBlock.WORKING) != didCraft) {
            this.level.setBlock(this.worldPosition, (BlockState)currentState.setValue((Property)MultiblockMixerBlock.WORKING, (Comparable)Boolean.valueOf(didCraft)), 3);
        }
    }

    public void setControllerBlockEntity(MultiblockControllerBlockEntity entity) {
        this.controller = entity;
    }

    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
    }

    public void setSelectedFluid(String fluid) {
        this.selectedFluidString = fluid;
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        if (this.selectedFluidString == null) {
            this.selectedFluidString = "minecraft:empty";
        } else {
            compoundTag.putString("selectedFluidString", this.selectedFluidString);
        }
        if (this.controllerPos != null) {
            compoundTag.putInt("controllerPosX", this.controllerPos.getX());
            compoundTag.putInt("controllerPosY", this.controllerPos.getY());
            compoundTag.putInt("controllerPosZ", this.controllerPos.getZ());
        }
        ListTag availableAlloysTag = new ListTag();
        for (String alloy : this.availableAlloys) {
            availableAlloysTag.add((Object)StringTag.valueOf((String)alloy));
        }
        compoundTag.put("availableAlloys", (Tag)availableAlloysTag);
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.selectedFluidString = compoundTag.contains("selectedFluidString") ? compoundTag.getString("selectedFluidString") : "minecraft:empty";
        this.controllerPos = compoundTag.contains("controllerPosX") && compoundTag.contains("controllerPosY") && compoundTag.contains("controllerPosZ") ? new BlockPos(compoundTag.getInt("controllerPosX"), compoundTag.getInt("controllerPosY"), compoundTag.getInt("controllerPosZ")) : null;
        this.availableAlloys.clear();
        if (compoundTag.contains("availableAlloys")) {
            ListTag availableAlloysTag = compoundTag.getList("availableAlloys", 8);
            for (Tag tag : availableAlloysTag) {
                if (!(tag instanceof StringTag)) continue;
                StringTag stringTag = (StringTag)tag;
                this.availableAlloys.add(stringTag.getAsString());
            }
        }
        super.loadAdditional(compoundTag, provider);
    }

    public boolean onPlayerUse(Player player, InteractionHand hand) {
        if (this.controller != null) {
            return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.controller.fluidHandler);
        }
        return false;
    }
}

