/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.data;

import com.benbenlaw.casting.fluid.CastingFluids;
import com.benbenlaw.casting.item.CastingItems;
import com.benbenlaw.casting.item.EquipmentModifierItems;
import com.benbenlaw.core.fluid.FluidDeferredRegister;
import com.benbenlaw.core.fluid.FluidRegistryObject;
import java.util.Map;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.loaders.DynamicFluidContainerModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

public class CastingItemModelProvider
extends ItemModelProvider {
    public CastingItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "casting", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem(CastingItems.BLACK_BRICK);
        this.simpleItem(CastingItems.FLUID_MOVER);
        this.simpleItem(CastingItems.BLOCK_MOLD);
        this.simpleItem(CastingItems.GEAR_MOLD);
        this.simpleItem(CastingItems.INGOT_MOLD);
        this.simpleItem(CastingItems.NUGGET_MOLD);
        this.simpleItem(CastingItems.PLATE_MOLD);
        this.simpleItem(CastingItems.ROD_MOLD);
        this.simpleItem(CastingItems.GEM_MOLD);
        this.simpleItem(CastingItems.DUST_MOLD);
        this.simpleItem(CastingItems.BALL_MOLD);
        this.simpleItem(CastingItems.WIRE_MOLD);
        this.simpleItem(CastingItems.REPAIRING_MOLD);
        this.simpleItem(EquipmentModifierItems.AUTO_SMELT);
        this.simpleItem(EquipmentModifierItems.BEHEADING);
        this.simpleItem(EquipmentModifierItems.EFFICIENCY);
        this.simpleItem(EquipmentModifierItems.EXCAVATION);
        this.simpleItem(EquipmentModifierItems.FORTUNE);
        this.simpleItem(EquipmentModifierItems.IGNITE);
        this.simpleItem(EquipmentModifierItems.KNOCKBACK);
        this.simpleItem(EquipmentModifierItems.LIFESTEAL);
        this.simpleItem(EquipmentModifierItems.LOOTING);
        this.simpleItem(EquipmentModifierItems.MAGNET);
        this.simpleItem(EquipmentModifierItems.PROTECTION);
        this.simpleItem(EquipmentModifierItems.REPAIRING);
        this.simpleItem(EquipmentModifierItems.SHARPNESS);
        this.simpleItem(EquipmentModifierItems.SILK_TOUCH);
        this.simpleItem(EquipmentModifierItems.STEP_ASSIST);
        this.simpleItem(EquipmentModifierItems.TELEPORTING);
        this.simpleItem(EquipmentModifierItems.TORCH_PLACING);
        this.simpleItem(EquipmentModifierItems.UNBREAKING);
        this.simpleItem(EquipmentModifierItems.WATER_WALKER);
        this.simpleItem(EquipmentModifierItems.LAVA_WALKER);
        this.simpleItem(EquipmentModifierItems.SPEED);
        this.simpleItem(EquipmentModifierItems.WATER_BREATHING);
        this.simpleItem(EquipmentModifierItems.NIGHT_VISION);
        this.simpleItem(EquipmentModifierItems.FLIGHT);
        for (Map.Entry<String, FluidRegistryObject<FluidDeferredRegister.CoreFluidTypes, BaseFlowingFluid.Source, BaseFlowingFluid.Flowing, LiquidBlock, BucketItem>> entry : CastingFluids.FLUIDS_MAP.entrySet()) {
            String fluidName = entry.getKey();
            FluidRegistryObject<FluidDeferredRegister.CoreFluidTypes, BaseFlowingFluid.Source, BaseFlowingFluid.Flowing, LiquidBlock, BucketItem> fluid = entry.getValue();
            this.simpleBucketItem(fluidName + "_bucket", fluid.getFluid());
        }
    }

    private void simpleBucketItem(String name, Fluid fluid) {
        ((DynamicFluidContainerModelBuilder)((ItemModelBuilder)this.withExistingParent(name, ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"item/bucket"))).customLoader(DynamicFluidContainerModelBuilder::begin)).fluid(fluid);
    }

    private void simpleItem(DeferredItem<Item> item) {
        ((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"casting", (String)("item/" + item.getId().getPath())));
    }

    private ItemModelBuilder simpleBlockItem(DeferredBlock<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"casting", (String)("item/" + item.getId().getPath())));
    }

    public String getName() {
        return "casting Item Models";
    }
}

