/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.event;

import com.benbenlaw.casting.config.EquipmentModifierConfig;
import com.benbenlaw.casting.item.CastingDataComponents;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="casting")
public class ArmorEvents {
    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        boolean isWaterBreathing;
        Player player = event.getEntity();
        Level level = player.level();
        if (level.isClientSide()) {
            return;
        }
        boolean isStepAssist = player.getItemBySlot(EquipmentSlot.FEET).getComponents().keySet().contains(CastingDataComponents.STEP_ASSIST.get());
        int totalSpeedLevel = 0;
        if (player.getItemBySlot(EquipmentSlot.FEET).getComponents().keySet().contains(CastingDataComponents.SPEED.get())) {
            totalSpeedLevel += ((Integer)player.getItemBySlot(EquipmentSlot.FEET).getComponents().getOrDefault((DataComponentType)CastingDataComponents.SPEED.get(), (Object)0)).intValue();
        }
        if (player.getItemBySlot(EquipmentSlot.LEGS).getComponents().keySet().contains(CastingDataComponents.SPEED.get())) {
            totalSpeedLevel += ((Integer)player.getItemBySlot(EquipmentSlot.LEGS).getComponents().getOrDefault((DataComponentType)CastingDataComponents.SPEED.get(), (Object)0)).intValue();
        }
        if (totalSpeedLevel > 0) {
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 22, totalSpeedLevel, false, false));
        }
        if (isStepAssist && !player.isShiftKeyDown()) {
            int stepAssistLevel = (Integer)player.getItemBySlot(EquipmentSlot.FEET).getComponents().getOrDefault((DataComponentType)CastingDataComponents.STEP_ASSIST.get(), (Object)0);
            Objects.requireNonNull(player.getAttribute(Attributes.STEP_HEIGHT)).setBaseValue((double)stepAssistLevel);
        } else {
            Objects.requireNonNull(player.getAttribute(Attributes.STEP_HEIGHT)).setBaseValue(0.6);
        }
        for (ItemStack armorItem : player.getArmorSlots()) {
            if (!armorItem.getComponents().keySet().contains(CastingDataComponents.MAGNET.get())) continue;
            int range = (Integer)armorItem.getComponents().getOrDefault((DataComponentType)CastingDataComponents.MAGNET.get(), (Object)0);
            AABB box = player.getBoundingBox().inflate((double)range);
            List items = level.getEntitiesOfClass(ItemEntity.class, box, item -> !item.hasPickUpDelay() && item.getItem().getCount() > 0);
            for (ItemEntity itemEntity : items) {
                if (itemEntity.hasPickUpDelay()) continue;
                ItemStack stack = itemEntity.getItem();
                boolean success = player.getInventory().add(stack);
                if (success || stack.isEmpty()) {
                    itemEntity.remove(Entity.RemovalReason.DISCARDED);
                    if (!(level instanceof ServerLevel)) continue;
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), 10, 0.1, 0.1, 0.1, 0.1);
                    continue;
                }
                itemEntity.setItem(stack);
            }
        }
        boolean isNightVision = player.getItemBySlot(EquipmentSlot.HEAD).getComponents().keySet().contains(CastingDataComponents.NIGHT_VISION.get());
        if (isNightVision) {
            player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 22, 0, false, false));
            if (player.tickCount % (Integer)EquipmentModifierConfig.timeForDamageOnNightVision.get() == 0) {
                player.getItemBySlot(EquipmentSlot.HEAD).hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.HEAD);
            }
        }
        if ((isWaterBreathing = player.getItemBySlot(EquipmentSlot.HEAD).getComponents().keySet().contains(CastingDataComponents.WATER_BREATHING.get())) && player.isUnderWater()) {
            player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 22, 0, false, false));
            if (player.tickCount % (Integer)EquipmentModifierConfig.timeForDamageOnWaterBreathing.get() == 0) {
                player.getItemBySlot(EquipmentSlot.HEAD).hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.HEAD);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        boolean isLavaWalker;
        Player player = event.getEntity();
        Level level = player.level();
        if (!player.level().isClientSide()) {
            boolean isFlight = player.getItemBySlot(EquipmentSlot.CHEST).getComponents().keySet().contains(CastingDataComponents.FLIGHT.get());
            if (isFlight) {
                if (!(player.isCreative() || player.isSpectator() || player.getAbilities().mayfly)) {
                    player.addTag("casting_flight");
                    player.getAbilities().mayfly = true;
                    player.onUpdateAbilities();
                }
            } else if (!player.isCreative() && !player.isSpectator() && player.getAbilities().mayfly && player.getTags().contains("casting_flight")) {
                player.removeTag("casting_flight");
                player.getAbilities().mayfly = false;
                player.onUpdateAbilities();
            }
        }
        boolean isWaterWalker = player.getItemBySlot(EquipmentSlot.FEET).getComponents().keySet().contains(CastingDataComponents.WATER_WALKER.get());
        float playerBob = player.bob;
        if (isWaterWalker && !player.isShiftKeyDown()) {
            boolean isAtWaterSurface;
            BlockPos pos = player.blockPosition();
            BlockState currentBlock = level.getBlockState(pos);
            BlockState aboveBlock = level.getBlockState(pos.above());
            boolean bl = isAtWaterSurface = currentBlock.is(Blocks.WATER) && !aboveBlock.is(Blocks.WATER);
            if (isAtWaterSurface) {
                double surfaceY = (double)pos.getY() + 1.0;
                double playerY = player.getY();
                boolean isBob = false;
                double newY = playerY + (surfaceY - playerY) * 0.1;
                player.setPos(player.getX(), newY, player.getZ());
                if (newY >= surfaceY - 0.5 && newY < surfaceY) {
                    isBob = true;
                    player.setDeltaMovement(player.getDeltaMovement().x, 0.0, player.getDeltaMovement().z);
                    player.setOnGround(true);
                }
                if (isBob) {
                    float f = Math.min(0.1f, (float)player.getDeltaMovement().horizontalDistance());
                    playerBob += (f - playerBob) * 0.7f;
                    player.bob = playerBob;
                }
            }
        }
        if ((isLavaWalker = player.getItemBySlot(EquipmentSlot.FEET).getComponents().keySet().contains(CastingDataComponents.LAVA_WALKER.get())) && !player.isShiftKeyDown()) {
            boolean isAtLavaSurface;
            BlockPos pos = player.blockPosition();
            BlockState currentBlock = level.getBlockState(pos);
            BlockState aboveBlock = level.getBlockState(pos.above());
            boolean bl = isAtLavaSurface = currentBlock.is(Blocks.LAVA) && !aboveBlock.is(Blocks.LAVA);
            if (isAtLavaSurface) {
                double surfaceY = (double)pos.getY() + 1.0;
                double playerY = player.getY();
                if (playerY >= surfaceY - 0.5 && playerY < surfaceY) {
                    if (Math.abs(playerY - surfaceY) > 0.001) {
                        player.setPos(player.getX(), surfaceY, player.getZ());
                    }
                    player.setDeltaMovement(player.getDeltaMovement().x, 0.0, player.getDeltaMovement().z);
                    player.setOnGround(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDamage(LivingDamageEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Level level = player.level();
        if (level.isClientSide()) {
            return;
        }
        float originalDamage = event.getOriginalDamage();
        float totalReduction = 0.0f;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack armor;
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR || (armor = player.getItemBySlot(slot)).isEmpty() || !armor.getComponents().keySet().contains(CastingDataComponents.PROTECTION.get())) continue;
            int protectionLevel = (Integer)armor.getComponents().getOrDefault((DataComponentType)CastingDataComponents.PROTECTION.get(), (Object)0);
            totalReduction += (float)protectionLevel * ((Float)EquipmentModifierConfig.percentageOfProtectionDamagePerProtectionLevel.get()).floatValue();
        }
        totalReduction = Math.min(totalReduction, 0.8f);
        event.setNewDamage(originalDamage * (1.0f - totalReduction));
    }

    @SubscribeEvent
    public static void onPlayerDamage(LivingDamageEvent.Post event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Level level = player.level();
        if (level.isClientSide()) {
            return;
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            boolean isUnbreaking;
            ItemStack armor;
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR || (armor = player.getItemBySlot(slot)).isEmpty() || !(isUnbreaking = armor.getComponents().keySet().contains(CastingDataComponents.UNBREAKING.get()))) continue;
            int unbreakingLevel = (Integer)armor.getComponents().getOrDefault((DataComponentType)CastingDataComponents.UNBREAKING.get(), (Object)0);
            float chance = (float)unbreakingLevel * 0.1f;
            if (!(level.getRandom().nextFloat() < chance)) continue;
            armor.setDamageValue(armor.getDamageValue() - 1);
        }
    }

    public static void popOutTheItem(Level level, BlockPos blockPos, ItemStack itemStack) {
        Vec3 vec3 = Vec3.atLowerCornerWithOffset((Vec3i)blockPos, (double)0.5, (double)1.1, (double)0.5).offsetRandom(level.random, 0.7f);
        ItemStack itemstack1 = itemStack.copy();
        ItemEntity itementity = new ItemEntity(level, vec3.x(), vec3.y(), vec3.z(), itemstack1);
        itementity.setDefaultPickUpDelay();
        level.addFreshEntity((Entity)itementity);
    }

    public static Holder<Enchantment> toHolder(Level level, ResourceKey<Enchantment> enchantment) {
        return level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(enchantment);
    }
}

