/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.screen.util;

import com.benbenlaw.casting.block.entity.ControllerBlockEntity;
import com.benbenlaw.casting.block.entity.SolidifierBlockEntity;
import com.benbenlaw.core.screen.util.CoreWidget;
import com.benbenlaw.core.util.MouseUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

@Deprecated(since="2.0.0")
public class FuelTankFluidStackWidget
extends CoreWidget {
    private final Screen screen;
    private final FluidTank getFluid;
    private BlockEntity blockEntity;

    public FuelTankFluidStackWidget(Screen screen, FluidTank getFluid, BlockEntity blockEntity, int pX, int pY, int pWidth, int pHeight) {
        super(pX, pY, pWidth, pHeight);
        this.screen = screen;
        this.getFluid = getFluid;
        this.blockEntity = blockEntity;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        FluidTank fluidTank = this.getFluid;
        if (!fluidTank.getFluid().isEmpty()) {
            AbstractTexture texture;
            FluidStack fluidStack = fluidTank.getFluid();
            IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            ResourceLocation still = props.getStillTexture(fluidStack);
            if (still != null && (texture = minecraft.getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS)) instanceof TextureAtlas) {
                TextureAtlas atlas = (TextureAtlas)texture;
                TextureAtlasSprite sprite = atlas.getSprite(still);
                int color = props.getTintColor();
                RenderSystem.setShaderColor((float)((float)FastColor.ARGB32.red((int)color) / 255.0f), (float)((float)FastColor.ARGB32.green((int)color) / 255.0f), (float)((float)FastColor.ARGB32.blue((int)color) / 255.0f), (float)((float)FastColor.ARGB32.alpha((int)color) / 255.0f));
                RenderSystem.enableBlend();
                int stored = fluidTank.getFluidAmount();
                float capacity = fluidTank.getCapacity();
                float filledVolume = (float)stored / capacity;
                int renderableHeight = (int)(filledVolume * (float)this.height);
                int atlasWidth = (int)((float)sprite.contents().width() / (sprite.getU1() - sprite.getU0()));
                int atlasHeight = (int)((float)sprite.contents().height() / (sprite.getV1() - sprite.getV0()));
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0f, (float)(this.height - 16), 0.0f);
                int i = 0;
                while ((double)i < Math.ceil((float)renderableHeight / 16.0f)) {
                    int drawingHeight = Math.min(16, renderableHeight - 16 * i);
                    int notDrawingHeight = 16 - drawingHeight;
                    guiGraphics.blit(TextureAtlas.LOCATION_BLOCKS, this.x, this.y + notDrawingHeight, 0, sprite.getU0() * (float)atlasWidth, sprite.getV0() * (float)atlasHeight + (float)notDrawingHeight, this.width, drawingHeight, atlasWidth, atlasHeight);
                    guiGraphics.pose().translate(0.0f, -16.0f, 0.0f);
                    ++i;
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.pose().popPose();
            }
            this.renderToolTip(guiGraphics, mouseX, mouseY);
        }
        RenderSystem.disableDepthTest();
    }

    protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }

    public void renderToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)this.x, (int)this.y, (int)0, (int)0, (int)16, (int)16)) {
            FormattedCharSequence[] tooltipLines;
            Font var10001 = this.screen.getMinecraft().font;
            BlockEntity blockEntity = this.blockEntity;
            if (blockEntity instanceof ControllerBlockEntity) {
                ControllerBlockEntity controllerBlockEntity = (ControllerBlockEntity)blockEntity;
                tooltipLines = new FormattedCharSequence[]{this.getFluid.getFluid().getHoverName().getVisualOrderText(), Component.literal((String)(this.getFluid.getFluidAmount() + "mB / " + this.getFluid.getCapacity() + "mB")).getVisualOrderText(), Component.literal((String)("Fuel Temp: " + controllerBlockEntity.fuelTemp)).getVisualOrderText()};
                guiGraphics.renderTooltip(var10001, Arrays.asList(tooltipLines), mouseX, mouseY);
            }
            if ((tooltipLines = this.blockEntity) instanceof SolidifierBlockEntity) {
                SolidifierBlockEntity solidifierBlockEntity = (SolidifierBlockEntity)tooltipLines;
                tooltipLines = new FormattedCharSequence[]{this.getFluid.getFluid().getHoverName().getVisualOrderText(), Component.literal((String)(this.getFluid.getFluidAmount() + "mB / " + this.getFluid.getCapacity() + "mB")).getVisualOrderText(), Component.literal((String)("Fuel Temp: " + solidifierBlockEntity.fuelTemp)).getVisualOrderText(), Component.literal((String)("Ticks Per Recipe: " + solidifierBlockEntity.maxProgress)).getVisualOrderText()};
                guiGraphics.renderTooltip(var10001, Arrays.asList(tooltipLines), mouseX, mouseY);
            }
        }
    }
}

