/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.block.entity;

import com.benbenlaw.casting.block.entity.CastingBlockEntities;
import com.benbenlaw.casting.config.ModifierSetsConfig;
import com.benbenlaw.casting.item.CastingItems;
import com.benbenlaw.casting.item.EquipmentModifier;
import com.benbenlaw.casting.recipe.EquipmentModifierRecipe;
import com.benbenlaw.casting.recipe.MeltingRecipe;
import com.benbenlaw.casting.screen.EquipmentModifierMenu;
import com.benbenlaw.casting.util.CastingTags;
import com.benbenlaw.casting.util.EquipmentModifierUtils;
import com.benbenlaw.casting.util.SidedInputOutputItemHandler;
import com.benbenlaw.casting.util.ValidToolTypesForToolModifiers;
import com.benbenlaw.core.block.entity.handler.IInventoryHandlingBlockEntity;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EquipmentModifierBlockEntity
extends BlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            EquipmentModifierBlockEntity.this.setChanged();
            EquipmentModifierBlockEntity.this.sync();
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            if (slot == EquipmentModifierBlockEntity.this.UPGRADE_ITEM_SLOT && stack.is(CastingTags.Items.MOLDS)) {
                return 1;
            }
            if (slot == EquipmentModifierBlockEntity.this.TOOL_SLOT) {
                return 1;
            }
            return 64;
        }
    };
    public final FluidTank TANK = new FluidTank(64000){

        protected void onContentsChanged() {
            EquipmentModifierBlockEntity.this.setChanged();
            EquipmentModifierBlockEntity.this.sync();
        }
    };
    private final IFluidHandler fluidHandler = new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return EquipmentModifierBlockEntity.this.TANK.getFluid();
        }

        public int getTankCapacity(int tank) {
            return EquipmentModifierBlockEntity.this.TANK.getCapacity();
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return EquipmentModifierBlockEntity.this.TANK.isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid() == EquipmentModifierBlockEntity.this.TANK.getFluid().getFluid() || EquipmentModifierBlockEntity.this.TANK.isEmpty()) {
                return EquipmentModifierBlockEntity.this.TANK.fill(resource, action);
            }
            return 0;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid() == EquipmentModifierBlockEntity.this.TANK.getFluid().getFluid()) {
                return EquipmentModifierBlockEntity.this.TANK.drain(resource.getAmount(), action);
            }
            return FluidStack.EMPTY;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (EquipmentModifierBlockEntity.this.TANK.getFluidAmount() > 0) {
                return EquipmentModifierBlockEntity.this.TANK.drain(maxDrain, action);
            }
            return FluidStack.EMPTY;
        }
    };
    public final ContainerData data = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> EquipmentModifierBlockEntity.this.progress;
                case 1 -> EquipmentModifierBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    EquipmentModifierBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    EquipmentModifierBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };
    public int progress = 0;
    public int maxProgress = 100;
    public int fuelTemp = 0;
    public int storedTankFluidAmount = 0;
    public int storedTankFluidAmountUsedInRecipe = 0;
    public int TOOL_SLOT = 0;
    public int UPGRADE_ITEM_SLOT = 1;
    public int OUTPUT_SLOT = 2;
    public String errorMessage = "";
    public boolean isLimitMode = false;
    private static Class<?> mekanismPaxelClass;

    public boolean onPlayerUse(Player player, InteractionHand hand) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.TANK);
    }

    public IFluidHandler getFluidHandlerCapability(Direction side) {
        return this.fluidHandler;
    }

    public void sync() {
        ServerLevel serverLevel;
        LevelChunk chunk;
        ChunkSource chunkSource;
        Level level = this.level;
        if (level instanceof ServerLevel && (chunkSource = Objects.requireNonNull((chunk = (serverLevel = (ServerLevel)level).getChunkAt(this.getBlockPos())).getLevel()).getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
            chunkCache.chunkMap.getPlayers(chunk.getPos(), false).forEach(this::syncContents);
        }
    }

    public void setFluid(FluidStack stack) {
        this.TANK.setFluid(stack);
    }

    public void getFluid(FluidStack stack) {
        this.TANK.setFluid(stack);
    }

    public FluidStack getFluidStack() {
        return this.TANK.getFluid();
    }

    public void syncContents(ServerPlayer player) {
        player.connection.send(Objects.requireNonNull(this.getUpdatePacket()));
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return new SidedInputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, side, (direction, slot, stack) -> {
            if (slot == this.TOOL_SLOT) {
                return direction == Direction.UP;
            }
            if (slot == this.UPGRADE_ITEM_SLOT) {
                return direction == Direction.SOUTH || direction == Direction.EAST || direction == Direction.WEST || direction == Direction.NORTH;
            }
            return false;
        }, (direction, slot) -> slot == this.OUTPUT_SLOT);
    }

    public void setHandler(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public EquipmentModifierBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CastingBlockEntities.EQUIPMENT_MODIFIER_BLOCK_ENTITY.get(), pos, state);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.casting.equipment_modifier");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new EquipmentModifierMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public void onLoad() {
        super.onLoad();
        this.setChanged();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, provider);
        return compoundTag;
    }

    public void onDataPacket(@NotNull Connection connection, @NotNull ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.onDataPacket(connection, clientboundBlockEntityDataPacket, provider);
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        compoundTag.putInt("progress", this.progress);
        compoundTag.putInt("maxProgress", this.maxProgress);
        compoundTag.put("tank", (Tag)this.TANK.writeToNBT(provider, new CompoundTag()));
        compoundTag.putInt("fuelTemp", this.fuelTemp);
        compoundTag.putInt("storedTankFluidAmount", this.storedTankFluidAmount);
        compoundTag.putInt("storedTankFluidAmountUsedInRecipe", this.storedTankFluidAmountUsedInRecipe);
        compoundTag.putString("errorMessage", this.errorMessage);
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        this.progress = compoundTag.getInt("progress");
        this.maxProgress = compoundTag.getInt("maxProgress");
        this.TANK.readFromNBT(provider, compoundTag.getCompound("tank"));
        this.fuelTemp = compoundTag.getInt("fuelTemp");
        this.storedTankFluidAmount = compoundTag.getInt("storedTankFluidAmount");
        this.storedTankFluidAmountUsedInRecipe = compoundTag.getInt("storedTankFluidAmountUsedInRecipe");
        this.errorMessage = compoundTag.getString("errorMessage");
        super.loadAdditional(compoundTag, provider);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick() {
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            RecipeInput inventory = new RecipeInput(){

                @NotNull
                public ItemStack getItem(int index) {
                    return EquipmentModifierBlockEntity.this.itemHandler.getStackInSlot(index);
                }

                public int size() {
                    return EquipmentModifierBlockEntity.this.itemHandler.getSlots();
                }
            };
            boolean foundMatch = false;
            ItemStack toolStack = this.itemHandler.getStackInSlot(this.TOOL_SLOT);
            if (!toolStack.isEmpty()) {
                String toolType = this.getToolType(toolStack);
                if (toolType.isEmpty() || !ValidToolTypesForToolModifiers.VALID_MODIFIERS.containsKey(toolType)) {
                    this.resetProgress();
                    return;
                }
                List<EquipmentModifier> validModifiers = ValidToolTypesForToolModifiers.VALID_MODIFIERS.get(toolType);
                if (validModifiers == null) {
                    validModifiers = List.of();
                }
                EquipmentModifierRecipe matchedRecipe = null;
                boolean bothRequired = false;
                boolean itemOnly = false;
                boolean fluidOnly = false;
                boolean repairMode = false;
                if (this.itemHandler.getStackInSlot(this.UPGRADE_ITEM_SLOT).is(CastingItems.REPAIRING_MOLD)) {
                    if (this.itemHandler.getStackInSlot(this.TOOL_SLOT).isEmpty()) {
                        this.resetProgress();
                        return;
                    }
                    ItemStack equipmentStack = this.itemHandler.getStackInSlot(this.TOOL_SLOT);
                    Ingredient getRepairItem = null;
                    Item item = equipmentStack.getItem();
                    if (item instanceof TieredItem) {
                        TieredItem tieredItem = (TieredItem)item;
                        getRepairItem = tieredItem.getTier().getRepairIngredient();
                    } else {
                        item = equipmentStack.getItem();
                        if (item instanceof ArmorItem) {
                            ArmorItem armorItem = (ArmorItem)item;
                            getRepairItem = (Ingredient)((ArmorMaterial)armorItem.getMaterial().value()).repairIngredient().get();
                        }
                    }
                    assert (getRepairItem != null);
                    if (this.itemHandler.getStackInSlot(this.OUTPUT_SLOT).isEmpty()) {
                        for (RecipeHolder recipeHolder : this.level.getRecipeManager().getAllRecipesFor((RecipeType)MeltingRecipe.Type.INSTANCE)) {
                            MeltingRecipe recipe = (MeltingRecipe)recipeHolder.value();
                            for (Ingredient recipeIngredient : recipe.getIngredients()) {
                                for (ItemStack repairStack : getRepairItem.getItems()) {
                                    if (!recipeIngredient.test(repairStack) || !recipeIngredient.test(getRepairItem.getItems()[0]) || !this.hasEnoughRepairFluid(equipmentStack, EquipmentModifierBlockEntity.getResourceCount(equipmentStack), recipe.output())) continue;
                                    ++this.progress;
                                    repairMode = true;
                                    if (this.progress < this.maxProgress) continue;
                                    this.extractFluid(recipe.output(), this.getFluidNeededForRepair(equipmentStack, EquipmentModifierBlockEntity.getResourceCount(equipmentStack), recipe.output()));
                                    this.itemHandler.setStackInSlot(this.TOOL_SLOT, ItemStack.EMPTY);
                                    ItemStack restoredItem = equipmentStack.copy();
                                    restoredItem.setDamageValue(0);
                                    this.itemHandler.setStackInSlot(this.OUTPUT_SLOT, restoredItem);
                                    this.sync();
                                }
                            }
                        }
                    }
                }
                if (!repairMode) {
                    EquipmentModifier modifier;
                    EquipmentModifierRecipe recipe;
                    for (RecipeHolder recipeHolder : this.level.getRecipeManager().getRecipesFor((RecipeType)EquipmentModifierRecipe.Type.INSTANCE, inventory, this.level)) {
                        recipe = (EquipmentModifierRecipe)recipeHolder.value();
                        modifier = EquipmentModifier.valueOf(recipe.effect().toUpperCase(Locale.ROOT));
                        if (!validModifiers.isEmpty() && !validModifiers.contains((Object)modifier)) continue;
                        if (!EquipmentModifierUtils.hasEnoughFreeModifiers(toolStack, modifier)) {
                            this.errorMessage = "not_high_enough_level";
                            continue;
                        }
                        if (!recipe.requiresBothItemAndFluid() || !this.hasEnoughFluid(recipe.upgradeFluid()) || this.itemHandler.getStackInSlot(this.UPGRADE_ITEM_SLOT).getCount() < recipe.upgradeItem().count() || !recipe.upgradeItem().test(this.itemHandler.getStackInSlot(this.UPGRADE_ITEM_SLOT))) continue;
                        matchedRecipe = recipe;
                        bothRequired = true;
                        this.sync();
                        break;
                    }
                    if (matchedRecipe == null) {
                        for (RecipeHolder recipeHolder : this.level.getRecipeManager().getRecipesFor((RecipeType)EquipmentModifierRecipe.Type.INSTANCE, inventory, this.level)) {
                            recipe = (EquipmentModifierRecipe)recipeHolder.value();
                            modifier = EquipmentModifier.valueOf(recipe.effect().toUpperCase(Locale.ROOT));
                            if (!validModifiers.isEmpty() && !validModifiers.contains((Object)modifier)) continue;
                            if (!EquipmentModifierUtils.hasEnoughFreeModifiers(toolStack, modifier)) {
                                this.errorMessage = "not_high_enough_level";
                                this.sync();
                                continue;
                            }
                            if (recipe.requiresBothItemAndFluid()) continue;
                            if (this.itemHandler.getStackInSlot(this.UPGRADE_ITEM_SLOT).getCount() >= recipe.upgradeItem().count() && recipe.upgradeItem().test(this.itemHandler.getStackInSlot(this.UPGRADE_ITEM_SLOT))) {
                                matchedRecipe = recipe;
                                itemOnly = true;
                                break;
                            }
                            if (!this.hasEnoughFluid(recipe.upgradeFluid())) continue;
                            matchedRecipe = recipe;
                            fluidOnly = true;
                            break;
                        }
                    }
                    if (matchedRecipe != null) {
                        EquipmentModifier modifier2 = EquipmentModifier.valueOf(matchedRecipe.effect().toUpperCase(Locale.ROOT));
                        boolean effectMaxed = EquipmentModifierUtils.isEffectAtMax(toolStack, modifier2);
                        if (effectMaxed) {
                            this.errorMessage = "at_max_level";
                            this.sync();
                        } else {
                            if (this.itemHandler.getStackInSlot(this.OUTPUT_SLOT).isEmpty()) {
                                ++this.progress;
                                if (this.progress >= this.maxProgress) {
                                    if (bothRequired || fluidOnly) {
                                        this.extractFluid(matchedRecipe.upgradeFluid(), matchedRecipe.upgradeFluid().getAmount());
                                    }
                                    if (bothRequired || itemOnly) {
                                        this.itemHandler.extractItem(this.UPGRADE_ITEM_SLOT, matchedRecipe.upgradeItem().count(), false);
                                    }
                                    this.itemHandler.setStackInSlot(this.OUTPUT_SLOT, EquipmentModifierUtils.copyAndApplyEffect(toolStack, modifier2));
                                    if (!this.itemHandler.getStackInSlot(this.OUTPUT_SLOT).has((DataComponentType)EquipmentModifier.EQUIPMENT_LEVEL.dataComponent.get())) {
                                        this.itemHandler.getStackInSlot(this.OUTPUT_SLOT).set((DataComponentType)EquipmentModifier.EQUIPMENT_LEVEL.dataComponent.value(), (Object)1);
                                        this.itemHandler.getStackInSlot(this.OUTPUT_SLOT).set(EquipmentModifier.EQUIPMENT_EXPERIENCE, (Object)0);
                                    }
                                    this.itemHandler.setStackInSlot(this.TOOL_SLOT, ItemStack.EMPTY);
                                    this.resetProgress();
                                }
                            }
                            foundMatch = true;
                            this.errorMessage = "";
                            this.sync();
                        }
                    }
                }
                if (!foundMatch && this.errorMessage.isEmpty() && !repairMode) {
                    this.errorMessage = "at_max_level";
                    this.resetProgress();
                }
            } else {
                this.resetProgress();
            }
        }
    }

    private static int getResourceCount(ItemStack item) {
        Item equipmentItem = item.getItem();
        if (mekanismPaxelClass != null && mekanismPaxelClass.isInstance(equipmentItem)) {
            return 7;
        }
        Item item2 = equipmentItem;
        Objects.requireNonNull(item2);
        Item item3 = item2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PickaxeItem.class, AxeItem.class, ShovelItem.class, HoeItem.class, SwordItem.class, ArmorItem.class}, (Object)item3, n)) {
            case 0 -> {
                PickaxeItem ignored = (PickaxeItem)item3;
                yield 3;
            }
            case 1 -> {
                AxeItem ignored = (AxeItem)item3;
                yield 3;
            }
            case 2 -> {
                ShovelItem ignored = (ShovelItem)item3;
                yield 1;
            }
            case 3 -> {
                HoeItem ignored = (HoeItem)item3;
                yield 2;
            }
            case 4 -> {
                SwordItem ignored = (SwordItem)item3;
                yield 2;
            }
            case 5 -> {
                ArmorItem armorItem = (ArmorItem)item3;
                switch (armorItem.getType()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case HELMET: {
                        yield 5;
                    }
                    case CHESTPLATE: {
                        yield 8;
                    }
                    case LEGGINGS: {
                        yield 7;
                    }
                    case BOOTS: {
                        yield 4;
                    }
                    case BODY: 
                }
                yield 10;
            }
            default -> 10000;
        };
    }

    private String getToolType(ItemStack stack) {
        Item item = stack.getItem();
        for (Map.Entry<String, List<String>> entry : ModifierSetsConfig.GROUP_ITEMS_OR_TAGS.entrySet()) {
            String groupKey = entry.getKey();
            List<String> itemOrTagIds = entry.getValue();
            for (String id : itemOrTagIds) {
                ResourceLocation itemId;
                Item configItem;
                String tagId;
                TagKey tag;
                if (!(id.startsWith("#") ? stack.is(tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)(tagId = id.substring(1))))) : (configItem = (Item)BuiltInRegistries.ITEM.get(itemId = ResourceLocation.parse((String)id))) == item)) continue;
                return groupKey;
            }
        }
        if (ModList.get().isLoaded("mekanismtools") && mekanismPaxelClass == null) {
            try {
                mekanismPaxelClass = Class.forName("mekanism.tools.common.item.ItemMekanismPaxel");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (mekanismPaxelClass != null && mekanismPaxelClass.isInstance(item)) {
            return "paxel_modifiers";
        }
        Item item2 = item;
        Objects.requireNonNull(item2);
        Item item3 = item2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PickaxeItem.class, AxeItem.class, ShovelItem.class, HoeItem.class, SwordItem.class, ShearsItem.class, ArmorItem.class}, (Object)item3, n)) {
            case 0 -> {
                PickaxeItem ignored = (PickaxeItem)item3;
                yield "pickaxe_modifiers";
            }
            case 1 -> {
                AxeItem ignored = (AxeItem)item3;
                yield "axe_modifiers";
            }
            case 2 -> {
                ShovelItem ignored = (ShovelItem)item3;
                yield "shovel_modifiers";
            }
            case 3 -> {
                HoeItem ignored = (HoeItem)item3;
                yield "hoe_modifiers";
            }
            case 4 -> {
                SwordItem ignored = (SwordItem)item3;
                yield "sword_modifiers";
            }
            case 5 -> {
                ShearsItem ignored = (ShearsItem)item3;
                yield "shear_modifiers";
            }
            case 6 -> {
                ArmorItem armorItem = (ArmorItem)item3;
                switch (armorItem.getType()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case HELMET: {
                        yield "helmet_modifiers";
                    }
                    case CHESTPLATE: {
                        yield "chestplate_modifiers";
                    }
                    case LEGGINGS: {
                        yield "leggings_modifiers";
                    }
                    case BOOTS: {
                        yield "boots_modifiers";
                    }
                    case BODY: 
                }
                yield "body_modifiers";
            }
            default -> "";
        };
    }

    private void resetProgress() {
        this.progress = 0;
        this.sync();
    }

    private void extractFluid(FluidStack output, int amount) {
        if (this.TANK.getFluidAmount() >= amount && this.TANK.getFluid().getFluid() == output.getFluid()) {
            this.TANK.drain(amount, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    private int getFluidNeededForRepair(ItemStack equipmentStack, int resourceCount, FluidStack repairFluid) {
        int repairAmount = equipmentStack.getDamageValue();
        int fluidAmountPerResourceMelted = repairFluid.getAmount();
        int totalFluidCount = fluidAmountPerResourceMelted * resourceCount;
        float fluidPerDurability = (float)totalFluidCount / (float)equipmentStack.getMaxDamage();
        return Math.round(fluidPerDurability * (float)repairAmount);
    }

    private boolean hasEnoughRepairFluid(ItemStack equipmentStack, int resourceCount, FluidStack repairFluid) {
        int totalFluidNeeded = this.getFluidNeededForRepair(equipmentStack, resourceCount, repairFluid);
        if (totalFluidNeeded == 0) {
            this.errorMessage = "";
            return true;
        }
        if (this.TANK.getFluid().getFluid() != repairFluid.getFluid()) {
            this.errorMessage = "wrong_fluid";
            return false;
        }
        if (this.TANK.getFluidAmount() >= totalFluidNeeded) {
            this.errorMessage = "";
            return true;
        }
        this.errorMessage = "not_enough_fluid";
        return false;
    }

    private boolean hasEnoughFluid(FluidStack output) {
        if (output == null || output.isEmpty()) {
            return false;
        }
        int tankAmount = this.TANK.getFluidAmount();
        if (this.isLimitMode) {
            tankAmount -= 100;
        }
        return tankAmount >= output.getAmount() && this.TANK.getFluid().getFluid() == output.getFluid();
    }
}

