/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.integration.jei;

import com.benbenlaw.casting.block.CastingBlocks;
import com.benbenlaw.casting.integration.jei.CoolantRecipeCategory;
import com.benbenlaw.casting.integration.jei.EquipmentModifierRecipeCategory;
import com.benbenlaw.casting.integration.jei.FuelRecipeCategory;
import com.benbenlaw.casting.integration.jei.MeltingRecipeCategory;
import com.benbenlaw.casting.integration.jei.MixingRecipeCategory;
import com.benbenlaw.casting.integration.jei.SolidifierRecipeCategory;
import com.benbenlaw.casting.recipe.CastingRecipes;
import com.benbenlaw.casting.recipe.CoolantRecipe;
import com.benbenlaw.casting.recipe.EquipmentModifierRecipe;
import com.benbenlaw.casting.recipe.FuelRecipe;
import com.benbenlaw.casting.recipe.MeltingRecipe;
import com.benbenlaw.casting.recipe.MixingRecipe;
import com.benbenlaw.casting.recipe.SolidifierRecipe;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEICastingPlugin
implements IModPlugin {
    public static IDrawableStatic slotDrawable;
    public static RecipeType<MeltingRecipe> MELTING_RECIPE;
    public static RecipeType<SolidifierRecipe> SOLIDIFIER_RECIPE;
    public static RecipeType<FuelRecipe> FUEL_RECIPE;
    public static RecipeType<CoolantRecipe> COOLANT_RECIPE;
    public static RecipeType<MixingRecipe> MIXER_RECIPE;
    public static RecipeType<EquipmentModifierRecipe> EQUIPMENT_MODIFIER_RECIPE;

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"jei_plugin");
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CastingBlocks.MULTIBLOCK_FUEL_TANK.get()), new RecipeType[]{FuelRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CastingBlocks.TANK.get()), new RecipeType[]{FuelRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CastingBlocks.MULTIBLOCK_COOLANT_TANK.get()), new RecipeType[]{CoolantRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CastingBlocks.TANK.get()), new RecipeType[]{CoolantRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CastingBlocks.MULTIBLOCK_SOLIDIFIER.get()), new RecipeType[]{SolidifierRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CastingBlocks.SOLIDIFIER.get()), new RecipeType[]{SolidifierRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CastingBlocks.MULTIBLOCK_CONTROLLER.get()), new RecipeType[]{MeltingRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CastingBlocks.CONTROLLER.get()), new RecipeType[]{MeltingRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CastingBlocks.MULTIBLOCK_MIXER.get()), new RecipeType[]{MixingRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CastingBlocks.MIXER.get()), new RecipeType[]{MixingRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CastingBlocks.EQUIPMENT_MODIFIER.get()), new RecipeType[]{EquipmentModifierRecipeCategory.RECIPE_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new FuelRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CoolantRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SolidifierRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new MeltingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new MixingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new EquipmentModifierRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        slotDrawable = guiHelper.getSlotDrawable();
    }

    public void registerRecipes(IRecipeRegistration registration) {
        assert (Minecraft.getInstance().level != null);
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        registration.addRecipes(FuelRecipeCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(CastingRecipes.FUEL_TYPE.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(CoolantRecipeCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(CastingRecipes.COOLANT_TYPE.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(MeltingRecipeCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(CastingRecipes.MELTING_TYPE.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(SolidifierRecipeCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(CastingRecipes.SOLIDIFIER_TYPE.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(MixingRecipeCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(CastingRecipes.MIXING_TYPE.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(EquipmentModifierRecipeCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(CastingRecipes.EQUIPMENT_MODIFIER_TYPE.get()).stream().map(RecipeHolder::value).toList());
    }

    static {
        MELTING_RECIPE = new RecipeType(MeltingRecipeCategory.UID, MeltingRecipe.class);
        SOLIDIFIER_RECIPE = new RecipeType(SolidifierRecipeCategory.UID, SolidifierRecipe.class);
        FUEL_RECIPE = new RecipeType(FuelRecipeCategory.UID, FuelRecipe.class);
        COOLANT_RECIPE = new RecipeType(CoolantRecipeCategory.UID, CoolantRecipe.class);
        MIXER_RECIPE = new RecipeType(MixingRecipeCategory.UID, MixingRecipe.class);
        EQUIPMENT_MODIFIER_RECIPE = new RecipeType(EquipmentModifierRecipeCategory.UID, EquipmentModifierRecipe.class);
    }
}

