/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class MultiFluidTankSharedCapacity
implements IFluidHandler {
    public final List<FluidStack> fluids = new ArrayList<FluidStack>();
    private final int maxCapacity;
    private int enabledCapacity;
    private int maxFluidTypes = 1;
    private boolean regulationEnabled = false;

    public MultiFluidTankSharedCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
        this.enabledCapacity = maxCapacity;
    }

    public void setEnabledCapacity(int newCapacity) {
        this.enabledCapacity = Math.min(newCapacity, this.maxCapacity);
        int total = this.getTotalFluidAmount();
        if (total > this.enabledCapacity) {
            this.reduceToCapacity();
        }
    }

    public int getEnabledCapacity() {
        return this.enabledCapacity;
    }

    public int getTotalFluidAmount() {
        return this.fluids.stream().mapToInt(FluidStack::getAmount).sum();
    }

    public int getRemainingSpace() {
        return this.enabledCapacity - this.getTotalFluidAmount();
    }

    public int getTanks() {
        return this.fluids.size();
    }

    public FluidStack getFluidInTank(int tank) {
        return tank >= 0 && tank < this.fluids.size() ? this.fluids.get(tank) : FluidStack.EMPTY;
    }

    public void setMaxFluidTypes(int maxFluidTypes) {
        this.maxFluidTypes = Math.max(1, maxFluidTypes);
    }

    public void setRegulationEnabled(boolean enabled) {
        this.regulationEnabled = enabled;
    }

    private void removeExcessFluids() {
        while (this.fluids.size() > this.maxFluidTypes) {
            this.fluids.removeLast();
        }
    }

    private int getCapacityPerFluid() {
        return this.maxFluidTypes == 2 ? this.enabledCapacity : this.enabledCapacity / this.maxFluidTypes;
    }

    public int getTankCapacity(int tank) {
        return this.enabledCapacity;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || resource.getAmount() <= 0) {
            return 0;
        }
        if (!this.regulationEnabled) {
            int spaceLeft = this.getRemainingSpace();
            if (spaceLeft <= 0) {
                return 0;
            }
            for (FluidStack stored : this.fluids) {
                if (!FluidStack.isSameFluidSameComponents((FluidStack)resource, (FluidStack)stored)) continue;
                int fillAmount = Math.min(spaceLeft, resource.getAmount());
                if (fillAmount > 0 && action.execute()) {
                    stored.grow(fillAmount);
                    this.onContentsChanged();
                }
                return fillAmount;
            }
            int fillAmount = Math.min(spaceLeft, resource.getAmount());
            if (fillAmount > 0 && action.execute()) {
                FluidStack toAdd = resource.copy();
                toAdd.setAmount(fillAmount);
                this.fluids.add(toAdd);
                this.onContentsChanged();
            }
            return fillAmount;
        }
        int maxPerFluid = this.enabledCapacity / Math.max(1, this.maxFluidTypes);
        int totalUsed = this.getTotalFluidAmount();
        int spaceLeft = this.enabledCapacity - totalUsed;
        if (spaceLeft <= 0) {
            return 0;
        }
        for (FluidStack stored : this.fluids) {
            if (!FluidStack.isSameFluidSameComponents((FluidStack)resource, (FluidStack)stored)) continue;
            int alreadyStored = stored.getAmount();
            int fluidRoom = Math.max(0, maxPerFluid - alreadyStored);
            int fillAmount = Math.min(Math.min(resource.getAmount(), fluidRoom), spaceLeft);
            if (fillAmount > 0 && action.execute()) {
                stored.grow(fillAmount);
                this.onContentsChanged();
            }
            return fillAmount;
        }
        if (this.fluids.size() >= this.maxFluidTypes) {
            return 0;
        }
        int fillAmount = Math.min(Math.min(resource.getAmount(), maxPerFluid), spaceLeft);
        if (fillAmount > 0 && action.execute()) {
            FluidStack toAdd = resource.copy();
            toAdd.setAmount(fillAmount);
            this.fluids.add(toAdd);
            this.onContentsChanged();
        }
        return fillAmount;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        for (int i = 0; i < this.fluids.size(); ++i) {
            FluidStack stored = this.fluids.get(i);
            if (!FluidStack.isSameFluidSameComponents((FluidStack)resource, (FluidStack)stored)) continue;
            int drainAmount = Math.min(stored.getAmount(), resource.getAmount());
            FluidStack drained = new FluidStack(stored.getFluid(), drainAmount);
            if (action.execute()) {
                stored.shrink(drainAmount);
                if (stored.getAmount() <= 0) {
                    this.fluids.remove(i);
                }
                this.onContentsChanged();
            }
            return drained;
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
        if (this.fluids.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack stored = this.fluids.getFirst();
        int drainAmount = Math.min(stored.getAmount(), maxDrain);
        FluidStack drained = new FluidStack(stored.getFluid(), drainAmount);
        if (action.execute()) {
            stored.shrink(drainAmount);
            if (stored.getAmount() <= 0) {
                this.fluids.removeFirst();
            }
            this.onContentsChanged();
        }
        return drained;
    }

    public List<FluidStack> getFluids() {
        return this.fluids;
    }

    public void clear() {
        this.fluids.clear();
    }

    protected void onContentsChanged() {
    }

    private void reduceToCapacity() {
        int allowed = this.enabledCapacity;
        Iterator<FluidStack> iterator = this.fluids.iterator();
        while (iterator.hasNext()) {
            FluidStack stack = iterator.next();
            if (allowed <= 0) {
                iterator.remove();
                continue;
            }
            if (stack.getAmount() > allowed) {
                stack.setAmount(allowed);
            }
            allowed -= stack.getAmount();
        }
    }

    public FluidStack drain(int tankIndex, int maxDrain, IFluidHandler.FluidAction action) {
        if (tankIndex < 0 || tankIndex >= this.fluids.size()) {
            return FluidStack.EMPTY;
        }
        FluidStack stored = this.fluids.get(tankIndex);
        int drainAmount = Math.min(stored.getAmount(), maxDrain);
        FluidStack drained = new FluidStack(stored.getFluid(), drainAmount);
        if (action.execute()) {
            stored.shrink(drainAmount);
            if (stored.getAmount() <= 0) {
                this.fluids.remove(tankIndex);
            }
            this.onContentsChanged();
        }
        return drained;
    }

    public void readFromNBT(HolderLookup.Provider provider, Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)nbt;
            this.fluids.clear();
            if (compoundTag.contains("Fluids", 9)) {
                ListTag listTag = compoundTag.getList("Fluids", 10);
                for (int i = 0; i < listTag.size(); ++i) {
                    CompoundTag tag = listTag.getCompound(i);
                    this.fluids.add(FluidStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag));
                }
            }
            if (compoundTag.contains("EnabledCapacity")) {
                this.enabledCapacity = compoundTag.getInt("EnabledCapacity");
            }
            if (compoundTag.contains("MaxFluidTypes")) {
                this.maxFluidTypes = compoundTag.getInt("MaxFluidTypes");
            }
            if (compoundTag.contains("RegulationEnabled")) {
                this.regulationEnabled = compoundTag.getBoolean("RegulationEnabled");
            }
            this.reduceToCapacity();
        }
    }

    public Tag writeToNBT(HolderLookup.Provider provider) {
        ListTag fluidList = new ListTag();
        for (FluidStack fluid : this.fluids) {
            if (fluid.isEmpty()) continue;
            fluidList.add((Object)fluid.save(provider));
        }
        CompoundTag tag = new CompoundTag();
        tag.put("Fluids", (Tag)fluidList);
        tag.putInt("EnabledCapacity", this.enabledCapacity);
        tag.putInt("MaxFluidTypes", this.maxFluidTypes);
        tag.putBoolean("RegulationEnabled", this.regulationEnabled);
        return tag;
    }
}

