/*
 * Decompiled with CFR 0.152.
 */
package com.explosionremoverz;

import com.explosionremoverz.ExplosionRemoverZCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class ExplosionRemoverZ
extends JavaPlugin
implements Listener {
    private FileConfiguration config;
    private Logger logger;
    private List<String> blockedExplosions;
    private boolean preventAllExplosions;
    private boolean cancelEvents;
    private boolean preventBlockDamage;
    private boolean preventEntityDamage;
    private boolean notifyAdmins;
    private String notificationMessage;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.logger = this.getLogger();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents(this, this);
        this.logger.info("ExplosionRemoverZ has been enabled!");
        if (this.preventAllExplosions) {
            this.logger.info("All explosions are currently being prevented!");
        } else {
            this.logger.info("Preventing explosions from: " + String.join((CharSequence)", ", this.blockedExplosions));
        }
        this.getCommand("explosionremoverz").setExecutor(new ExplosionRemoverZCommand(this));
    }

    @Override
    public void onDisable() {
        this.logger.info("ExplosionRemoverZ has been disabled!");
    }

    public void loadConfig() {
        this.reloadConfig();
        this.config = this.getConfig();
        this.preventAllExplosions = this.config.getBoolean("prevent-all-explosions", false);
        this.blockedExplosions = this.config.getStringList("blocked-explosions");
        this.cancelEvents = this.config.getBoolean("cancel-events", true);
        this.preventBlockDamage = this.config.getBoolean("prevent-block-damage", true);
        this.preventEntityDamage = this.config.getBoolean("prevent-entity-damage", false);
        this.notifyAdmins = this.config.getBoolean("notify-admins", true);
        this.notificationMessage = this.config.getString("notification-message", "&c[ExplosionRemoverZ] &fBlocked %explosion_type% explosion at %location%");
        if (this.blockedExplosions == null) {
            this.blockedExplosions = new ArrayList<String>();
            this.blockedExplosions.add("CREEPER");
            this.blockedExplosions.add("TNT");
            this.blockedExplosions.add("WITHER");
            this.config.set("blocked-explosions", this.blockedExplosions);
            this.saveConfig();
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        boolean shouldBlock;
        if (event.isCancelled()) {
            return;
        }
        String explosionType = event.getEntityType().toString();
        boolean bl = shouldBlock = this.preventAllExplosions || this.blockedExplosions.contains(explosionType);
        if (shouldBlock) {
            if (this.cancelEvents) {
                event.setCancelled(true);
            } else if (this.preventBlockDamage) {
                event.blockList().clear();
            }
            if (this.notifyAdmins) {
                String location = event.getLocation().getWorld().getName() + " at X:" + event.getLocation().getBlockX() + " Y:" + event.getLocation().getBlockY() + " Z:" + event.getLocation().getBlockZ();
                String message = this.notificationMessage.replace("%explosion_type%", explosionType).replace("%location%", location).replace("&", "\u00a7");
                for (String adminName : this.config.getStringList("admin-notification-list")) {
                    if (adminName.equals("console")) {
                        this.logger.info(message.replace("\u00a7", ""));
                        continue;
                    }
                    if (Bukkit.getPlayer(adminName) == null || !Bukkit.getPlayer(adminName).isOnline()) continue;
                    Bukkit.getPlayer(adminName).sendMessage(message);
                }
            }
        }
    }

    @EventHandler
    public void onExplosionPrime(ExplosionPrimeEvent event) {
        boolean shouldBlock;
        if (event.isCancelled()) {
            return;
        }
        String explosionType = event.getEntity().getType().toString();
        boolean bl = shouldBlock = this.preventAllExplosions || this.blockedExplosions.contains(explosionType);
        if (shouldBlock) {
            if (this.cancelEvents) {
                event.setCancelled(true);
            } else if (this.preventEntityDamage) {
                event.setRadius(0.0f);
            }
        }
    }
}

