/*
 * Decompiled with CFR 0.152.
 */
package com.explosionremoverz;

import com.explosionremoverz.ExplosionRemoverZ;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class ExplosionRemoverZCommand
implements CommandExecutor,
TabCompleter {
    private final ExplosionRemoverZ plugin;

    public ExplosionRemoverZCommand(ExplosionRemoverZ plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("explosionremoverz.admin")) {
            sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            this.showHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.plugin.loadConfig();
                sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "ExplosionRemoverZ configuration reloaded successfully.");
                break;
            }
            case "info": {
                this.showInfo(sender);
                break;
            }
            case "help": {
                this.showHelp(sender);
                break;
            }
            default: {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Unknown command. Use '/explosionremoverz help' for a list of commands.");
            }
        }
        return true;
    }

    private void showInfo(CommandSender sender) {
        sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + "---- ExplosionRemoverZ Info ----");
        sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Version: " + this.plugin.getDescription().getVersion());
        sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Author: Mateitaa1");
        sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Wanna support me? Check out my other plugins :) https://modrinth.com/organization/survivalcraft");
        sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Status: " + (this.plugin.isEnabled() ? String.valueOf((Object)ChatColor.GREEN) + "Enabled" : String.valueOf((Object)ChatColor.RED) + "Disabled"));
        sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Use '/explosionremoverz help' for commands.");
    }

    private void showHelp(CommandSender sender) {
        sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + "---- ExplosionRemoverZ Help ----");
        sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/explosionremoverz reload " + String.valueOf((Object)ChatColor.WHITE) + "- Reload the configuration");
        sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/explosionremoverz info " + String.valueOf((Object)ChatColor.WHITE) + "- Show plugin information");
        sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/explosionremoverz help " + String.valueOf((Object)ChatColor.WHITE) + "- Show this help message");
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> commands = Arrays.asList("reload", "info", "help");
            for (String cmd : commands) {
                if (!cmd.startsWith(args[0].toLowerCase())) continue;
                completions.add(cmd);
            }
        }
        return completions;
    }
}

