/*
 * Decompiled with CFR 0.152.
 */
package com.explosionremoverz;

import com.explosionremoverz.ExplosionRemoverZCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class ExplosionRemoverZ
extends JavaPlugin
implements Listener {
    private FileConfiguration config;
    private Logger logger;
    private List<String> blockedEntityExplosions;
    private List<String> blockedBlockExplosions;
    private List<String> worldWhitelist;
    private boolean preventAllExplosions;
    private boolean cancelEvents;
    private boolean preventBlockDamage;
    private boolean preventEntityDamage;
    private boolean notifyAdmins;
    private String notificationMessage;
    private boolean logToConsole;
    private boolean debugMode;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.logger = this.getLogger();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents(this, this);
        this.logger.info("ExplosionRemoverZ has been enabled!");
        if (this.preventAllExplosions) {
            this.logger.info("ALL explosions are being prevented!");
        } else {
            if (!this.blockedEntityExplosions.isEmpty()) {
                this.logger.info("Preventing entity explosions: " + String.join((CharSequence)", ", this.blockedEntityExplosions));
            }
            if (!this.blockedBlockExplosions.isEmpty()) {
                this.logger.info("Preventing block explosions: " + String.join((CharSequence)", ", this.blockedBlockExplosions));
            }
        }
        this.getCommand("explosionremoverz").setExecutor(new ExplosionRemoverZCommand(this));
    }

    @Override
    public void onDisable() {
        this.logger.info("ExplosionRemoverZ has been disabled!");
    }

    public void loadConfig() {
        this.reloadConfig();
        this.config = this.getConfig();
        this.preventAllExplosions = this.config.getBoolean("prevent-all-explosions", false);
        this.blockedEntityExplosions = this.config.getStringList("blocked-entity-explosions");
        this.blockedBlockExplosions = this.config.getStringList("blocked-block-explosions");
        this.worldWhitelist = this.config.getStringList("world-whitelist");
        this.cancelEvents = this.config.getBoolean("cancel-events", true);
        this.preventBlockDamage = this.config.getBoolean("prevent-block-damage", true);
        this.preventEntityDamage = this.config.getBoolean("prevent-entity-damage", false);
        this.notifyAdmins = this.config.getBoolean("notify-admins", true);
        this.notificationMessage = this.config.getString("notification-message", "&c[ExplosionRemoverZ] &fBlocked %explosion_type% explosion at %location%");
        this.logToConsole = this.config.getBoolean("log-to-console", true);
        this.debugMode = this.config.getBoolean("debug-mode", false);
        if (this.blockedEntityExplosions == null || this.blockedEntityExplosions.isEmpty()) {
            this.blockedEntityExplosions = new ArrayList<String>();
            this.blockedEntityExplosions.add("CREEPER");
            this.blockedEntityExplosions.add("TNT");
            this.blockedEntityExplosions.add("PRIMED_TNT");
            this.blockedEntityExplosions.add("WITHER");
            this.blockedEntityExplosions.add("WITHER_SKULL");
            this.blockedEntityExplosions.add("FIREBALL");
            this.blockedEntityExplosions.add("SMALL_FIREBALL");
            this.blockedEntityExplosions.add("DRAGON_FIREBALL");
            this.blockedEntityExplosions.add("ENDER_CRYSTAL");
            this.blockedEntityExplosions.add("END_CRYSTAL");
            this.blockedEntityExplosions.add("MINECART_TNT");
            this.blockedEntityExplosions.add("TNT_MINECART");
            this.config.set("blocked-entity-explosions", this.blockedEntityExplosions);
            this.saveConfig();
        }
        if (this.blockedBlockExplosions == null || this.blockedBlockExplosions.isEmpty()) {
            String[] bedTypes;
            this.blockedBlockExplosions = new ArrayList<String>();
            this.blockedBlockExplosions.add("RESPAWN_ANCHOR");
            this.blockedBlockExplosions.add("BED");
            this.blockedBlockExplosions.add("TNT");
            for (String bedType : bedTypes = new String[]{"BLACK_BED", "BLUE_BED", "BROWN_BED", "CYAN_BED", "GRAY_BED", "GREEN_BED", "LIGHT_BLUE_BED", "LIGHT_GRAY_BED", "LIME_BED", "MAGENTA_BED", "ORANGE_BED", "PINK_BED", "PURPLE_BED", "RED_BED", "WHITE_BED", "YELLOW_BED"}) {
                this.blockedBlockExplosions.add(bedType);
            }
            this.config.set("blocked-block-explosions", this.blockedBlockExplosions);
            this.saveConfig();
        }
    }

    private boolean isWorldEnabled(String worldName) {
        return this.worldWhitelist.isEmpty() || this.worldWhitelist.contains(worldName);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityExplode(EntityExplodeEvent event) {
        Creeper creeper;
        boolean shouldBlock;
        if (event.isCancelled() || !this.isWorldEnabled(event.getLocation().getWorld().getName())) {
            return;
        }
        Entity entity = event.getEntity();
        EntityType entityType = entity.getType();
        String explosionType = entityType.toString();
        boolean bl = shouldBlock = this.preventAllExplosions || this.blockedEntityExplosions.contains(explosionType);
        if (entityType == EntityType.CREEPER && entity instanceof Creeper && (creeper = (Creeper)entity).isPowered()) {
            explosionType = "CHARGED_CREEPER";
            shouldBlock = true;
        }
        if (shouldBlock) {
            if (this.cancelEvents) {
                event.setCancelled(true);
            } else {
                if (this.preventBlockDamage) {
                    event.blockList().clear();
                }
                if (this.preventEntityDamage) {
                    event.setYield(0.0f);
                }
            }
            if (this.notifyAdmins) {
                this.sendNotification(explosionType, event.getLocation());
            }
            if (this.debugMode) {
                this.logger.info("Blocked " + explosionType + " explosion at " + this.locationToString(event.getLocation()));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onExplosionPrime(ExplosionPrimeEvent event) {
        boolean shouldBlock;
        if (event.isCancelled() || !this.isWorldEnabled(event.getEntity().getLocation().getWorld().getName())) {
            return;
        }
        EntityType entityType = event.getEntity().getType();
        String explosionType = entityType.toString();
        boolean bl = shouldBlock = this.preventAllExplosions || this.blockedEntityExplosions.contains(explosionType);
        if (shouldBlock) {
            if (this.cancelEvents) {
                event.setCancelled(true);
            } else if (this.preventEntityDamage) {
                event.setRadius(0.0f);
            }
            if (this.debugMode) {
                this.logger.info("Blocked " + explosionType + " prime at " + this.locationToString(event.getEntity().getLocation()));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockExplode(BlockExplodeEvent event) {
        boolean shouldBlock;
        if (event.isCancelled() || !this.isWorldEnabled(event.getBlock().getWorld().getName())) {
            return;
        }
        Material blockType = event.getExplodedBlockState().getType();
        String explosionType = blockType.toString();
        boolean bl = shouldBlock = this.preventAllExplosions || this.blockedBlockExplosions.contains(explosionType);
        if (this.isBed(blockType)) {
            explosionType = "BED";
            boolean bl2 = shouldBlock = this.preventAllExplosions || this.blockedBlockExplosions.contains("BED");
        }
        if (shouldBlock) {
            if (this.cancelEvents) {
                event.setCancelled(true);
            } else if (this.preventBlockDamage) {
                event.blockList().clear();
            }
            if (this.notifyAdmins) {
                this.sendNotification(explosionType, event.getBlock().getLocation());
            }
            if (this.debugMode) {
                this.logger.info("Blocked " + explosionType + " block explosion at " + this.locationToString(event.getBlock().getLocation()));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getClickedBlock() == null) {
            return;
        }
        Block block = event.getClickedBlock();
        Material blockType = block.getType();
        if (!this.isWorldEnabled(block.getWorld().getName())) {
            return;
        }
        boolean shouldBlock = false;
        String explosionType = "";
        World.Environment worldEnv = block.getWorld().getEnvironment();
        if (this.isBed(blockType) && worldEnv != World.Environment.NORMAL) {
            shouldBlock = this.preventAllExplosions || this.blockedBlockExplosions.contains("BED");
            explosionType = "BED";
        } else if (blockType == Material.RESPAWN_ANCHOR && worldEnv != World.Environment.NETHER) {
            shouldBlock = this.preventAllExplosions || this.blockedBlockExplosions.contains("RESPAWN_ANCHOR");
            explosionType = "RESPAWN_ANCHOR";
        }
        if (shouldBlock) {
            event.setCancelled(true);
            event.getPlayer().sendMessage("\u00a7cExplosion prevented!");
            if (this.debugMode) {
                this.logger.info("Blocked " + explosionType + " interaction by " + event.getPlayer().getName());
            }
        }
    }

    private boolean isBed(Material material) {
        String name = material.toString();
        return name.contains("BED") && !name.contains("BEDROCK");
    }

    private void sendNotification(String explosionType, Location location) {
        if (!this.notifyAdmins) {
            return;
        }
        String locationStr = location.getWorld().getName() + " at X:" + location.getBlockX() + " Y:" + location.getBlockY() + " Z:" + location.getBlockZ();
        String message = this.notificationMessage.replace("%explosion_type%", explosionType).replace("%location%", locationStr).replace("&", "\u00a7");
        List<String> adminList = this.config.getStringList("admin-notification-list");
        for (String adminName : adminList) {
            if (adminName.equals("console")) {
                if (!this.logToConsole) continue;
                this.logger.info(message.replace("\u00a7", ""));
                continue;
            }
            Player player = Bukkit.getPlayer(adminName);
            if (player == null || !player.isOnline()) continue;
            player.sendMessage(message);
        }
    }

    private String locationToString(Location location) {
        return location.getWorld().getName() + " " + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ();
    }

    public FileConfiguration getConfiguration() {
        return this.config;
    }
}

