/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 *
 * Copyright © 2025 Jaxydog
 *
 * This file is part of Permission to Maim.
 *
 * Permission to Maim is free software: you can redistribute it and/or modify it under the terms of the GNU Affero
 * General Public License as published by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Permission to Maim is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Affero General Public License along with Permission to Maim. If not, see
 * <https://www.gnu.org/licenses/>.
 */

package dev.jaxydog.ptm.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import dev.jaxydog.ptm.api.PtmPlayerConfig;
import dev.jaxydog.ptm.inject.client.PtmPlayerEntityModel;
import dev.jaxydog.ptm.inject.client.PtmPlayerEntityRenderState;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_11890;
import net.minecraft.class_11901;
import net.minecraft.class_5617;
import net.minecraft.class_591;
import net.minecraft.class_922;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(EnvType.CLIENT)
@Mixin(class_1007.class)
public abstract class PlayerEntityRendererMixin<AvatarLikeEntity extends class_11890 & class_11901>
    extends class_922<AvatarLikeEntity, class_10055, class_591>
{

    public PlayerEntityRendererMixin(
        final @NotNull class_5617.class_5618 ctx,
        final @NotNull class_591 model,
        final float shadowRadius
    )
    {
        super(ctx, model, shadowRadius);
    }

    @ModifyReturnValue(method = "method_72996", at = @At("RETURN"))
    private static @NotNull class_591 new_markArmorModels(final class_591 original) {
        ((PtmPlayerEntityModel) original).ptm$setArmorModel(true);

        return original;
    }

    @SuppressWarnings("RedundantCast")
    @Inject(
        method = "updateRenderState(Lnet/minecraft/entity/PlayerLikeEntity;" +
            "Lnet/minecraft/client/render/entity/state/PlayerEntityRenderState;F)V",
        at = @At("TAIL")
    )
    private void updateRenderState_updatePtmPlayerConfig(
        final @NotNull class_11890 playerLikeEntity,
        final @NotNull class_10055 renderState,
        final float f,
        final @NotNull CallbackInfo ci
    )
    {
        ((PtmPlayerEntityRenderState) renderState).ptm$setPtmPlayerConfig(PtmPlayerConfig.get(playerLikeEntity));
    }

}
