/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 *
 * Copyright © 2025 Jaxydog
 *
 * This file is part of Permission to Maim.
 *
 * Permission to Maim is free software: you can redistribute it and/or modify it under the terms of the GNU Affero
 * General Public License as published by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Permission to Maim is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Affero General Public License along with Permission to Maim. If not, see
 * <https://www.gnu.org/licenses/>.
 */

package dev.jaxydog.ptm.mixin.client;

import dev.jaxydog.ptm.api.PtmModelPart;
import dev.jaxydog.ptm.inject.client.PtmGameOptions;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_353;
import net.minecraft.class_437;
import net.minecraft.class_440;
import net.minecraft.class_4667;
import net.minecraft.class_5676;
import net.minecraft.class_7842;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import java.util.Objects;
import java.util.function.IntSupplier;

@Environment(EnvType.CLIENT)
@Mixin(class_440.class)
public abstract class SkinOptionsScreenMixin
    extends class_4667
{

    public SkinOptionsScreenMixin(
        final @NotNull class_437 parent,
        final @NotNull class_315 gameOptions,
        final @NotNull class_2561 title
    )
    {
        super(parent, gameOptions, title);
    }

    @Unique
    private @NotNull class_353.class_354 createHeader(final @NotNull class_2561 text) {
        final IntSupplier bodyWidth = () -> Objects.requireNonNull(this.field_51824).method_25368();

        return new class_353.class_354(List.of(new class_7842(text, this.field_22793)), this) {

            @Override
            public void method_25343(
                final @NotNull class_332 context,
                final int mouseX,
                final int mouseY,
                final boolean hovered,
                final float deltaTicks
            )
            {
                final @NotNull class_7842 widget = (class_7842) this.field_18214.getFirst();

                widget.method_53533(21);
                widget.method_48229((bodyWidth.getAsInt() / 2) - (widget.method_25368() / 2), this.method_73382());
                widget.method_25394(context, mouseX, mouseY, deltaTicks);
            }
        };
    }

    @Inject(method = "addOptions", at = @At("HEAD"))
    private void addOptions_addVanillaHeader(final @NotNull CallbackInfo ci) {
        Objects.requireNonNull(this.field_51824).method_25321(this.createHeader(class_2561.method_43471("options.ptm.vanillaTitle")));
    }

    @SuppressWarnings("RedundantCast")
    @Inject(method = "addOptions", at = @At("TAIL"))
    private void addOptions_addPtmButtons(final @NotNull CallbackInfo ci) {
        Objects.requireNonNull(this.field_51824).method_25321(this.createHeader(class_2561.method_43471("options.ptm.title")));

        final @NotNull PtmGameOptions ptmGameOptions = (PtmGameOptions) this.field_21336;
        final @NotNull List<class_339> widgetList = new ObjectArrayList<>(PtmModelPart.values().length);

        for (final @NotNull PtmModelPart modelPart : PtmModelPart.values()) {
            final boolean isEnabled = ptmGameOptions.ptm$isModelPartEnabled(modelPart);

            widgetList.add(class_5676.method_32613(isEnabled).method_57720(
                modelPart.getOptionText(),
                (button, enabled) -> ptmGameOptions.ptm$setModelPartEnabled(modelPart, enabled)
            ));
        }

        widgetList.add(class_5676.method_32613(ptmGameOptions.ptm$isFloatingArmorHidden()).method_57720(
            class_2561.method_43471("options.ptm.hideFloatingArmor"),
            (button, hidden) -> ptmGameOptions.ptm$setFloatingArmorHidden(hidden)
        ));

        widgetList.add(class_5676.method_32613(ptmGameOptions.ptm$isModEnabled()).method_57720(
            class_2561.method_43471("options.ptm.modEnabled"),
            (button, enabled) -> ptmGameOptions.ptm$setModEnabled(enabled)
        ));

        Objects.requireNonNull(this.field_51824).method_58227(widgetList);
    }

}
