/*
 * Decompiled with CFR 0.152.
 */
package dev.jaxydog.ptm.mixin.client;

import dev.jaxydog.ptm.api.PtmModelPart;
import dev.jaxydog.ptm.api.PtmPlayerConfig;
import dev.jaxydog.ptm.api.PtmSyncPlayerConfigPayload;
import dev.jaxydog.ptm.inject.client.PtmGameOptions;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_11890;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_315.class})
public abstract class GameOptionsMixin
implements PtmGameOptions {
    @Unique
    private final Set<PtmModelPart> enabledPtmModelParts = EnumSet.allOf(PtmModelPart.class);
    @Unique
    private AtomicBoolean hideFloatingArmor = new AtomicBoolean(true);
    @Unique
    private AtomicBoolean modEnabled = new AtomicBoolean(true);
    @Shadow
    protected class_310 field_1863;

    @Override
    public boolean ptm$isModEnabled() {
        if (Objects.isNull(this.modEnabled)) {
            this.modEnabled = new AtomicBoolean(true);
        }
        return this.modEnabled.getPlain();
    }

    @Override
    public void ptm$setModEnabled(boolean enabled) {
        if (Objects.nonNull(this.modEnabled)) {
            this.modEnabled.setPlain(enabled);
        } else {
            this.modEnabled = new AtomicBoolean(enabled);
        }
    }

    @Override
    public boolean ptm$isFloatingArmorHidden() {
        if (Objects.isNull(this.hideFloatingArmor)) {
            this.hideFloatingArmor = new AtomicBoolean(true);
        }
        return this.hideFloatingArmor.getPlain();
    }

    @Override
    public void ptm$setFloatingArmorHidden(boolean hidden) {
        if (Objects.nonNull(this.hideFloatingArmor)) {
            this.hideFloatingArmor.setPlain(hidden);
        } else {
            this.hideFloatingArmor = new AtomicBoolean(hidden);
        }
    }

    @Override
    public boolean ptm$isModelPartEnabled(@NotNull PtmModelPart modelPart) {
        return this.enabledPtmModelParts.contains((Object)modelPart);
    }

    @Override
    @NotNull
    public PtmPlayerConfig ptm$getPlayerConfig() {
        return PtmPlayerConfig.fromEnabledPartSet(this.enabledPtmModelParts, this.ptm$isFloatingArmorHidden(), this.ptm$isModEnabled());
    }

    @Override
    public void ptm$setModelPartEnabled(@NotNull PtmModelPart modelPart, boolean enabled) {
        if (enabled) {
            this.enabledPtmModelParts.add(modelPart);
        } else {
            this.enabledPtmModelParts.remove((Object)modelPart);
        }
    }

    @Inject(method={"accept"}, at={@At(value="TAIL")})
    private void accept_loadEnabledPtmModelParts(@NotNull class_315.class_5823 visitor, @NotNull CallbackInfo ci) {
        boolean savedModEnabled = visitor.method_33684("%s.modEnabled".formatted("ptm"), this.ptm$isModEnabled());
        if (this.ptm$isModEnabled() != savedModEnabled) {
            this.ptm$setModEnabled(savedModEnabled);
        }
        boolean savedHideFloatingArmor = visitor.method_33684("%s.hideFloatingArmor".formatted("ptm"), this.ptm$isFloatingArmorHidden());
        if (this.ptm$isFloatingArmorHidden() != savedHideFloatingArmor) {
            this.ptm$setFloatingArmorHidden(savedHideFloatingArmor);
        }
        for (PtmModelPart modelPart : PtmModelPart.values()) {
            boolean savedValue;
            String optionsKey = "%s.modelPart_%s".formatted("ptm", modelPart.getName());
            boolean localValue = this.enabledPtmModelParts.contains((Object)modelPart);
            if (localValue == (savedValue = visitor.method_33684(optionsKey, localValue))) continue;
            this.ptm$setModelPartEnabled(modelPart, savedValue);
        }
    }

    @Inject(method={"sendClientSettings"}, at={@At(value="TAIL")})
    private void sendClientSettings_updatePtmPlayerConfig(@NotNull CallbackInfo ci) {
        if (Objects.nonNull(this.field_1863.field_1724)) {
            PtmPlayerConfig ptmPlayerConfig = this.ptm$getPlayerConfig();
            PtmPlayerConfig.set((class_11890)this.field_1863.field_1724, ptmPlayerConfig);
            ClientPlayNetworking.send((class_8710)new PtmSyncPlayerConfigPayload(ptmPlayerConfig));
        }
    }
}

