/*
 * Decompiled with CFR 0.152.
 */
package dev.jaxydog.ptm.mixin.client;

import dev.jaxydog.ptm.api.PtmModelPart;
import dev.jaxydog.ptm.api.PtmPlayerConfig;
import dev.jaxydog.ptm.api.PtmSyncPlayerConfigPayload;
import dev.jaxydog.ptm.inject.client.PtmGameOptions;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_315.class})
public abstract class GameOptionsMixin
implements PtmGameOptions {
    @Unique
    private final Set<PtmModelPart> enabledPtmModelParts = EnumSet.allOf(PtmModelPart.class);
    @Unique
    private AtomicBoolean hideFloatingArmor = new AtomicBoolean(true);
    @Shadow
    protected class_310 field_1863;

    @Override
    public boolean ptm$isFloatingArmorHidden() {
        if (this.hideFloatingArmor == null) {
            this.hideFloatingArmor = new AtomicBoolean(true);
        }
        return this.hideFloatingArmor.getPlain();
    }

    @Override
    public void ptm$setFloatingArmorHidden(boolean hidden) {
        this.hideFloatingArmor.setPlain(hidden);
    }

    @Override
    public boolean ptm$isModelPartEnabled(@NotNull PtmModelPart modelPart) {
        return this.enabledPtmModelParts.contains((Object)modelPart);
    }

    @Override
    @NotNull
    public PtmPlayerConfig ptm$getPlayerConfig() {
        return PtmPlayerConfig.fromEnabledPartSet(this.enabledPtmModelParts, this.ptm$isFloatingArmorHidden());
    }

    @Override
    public void ptm$setModelPartEnabled(@NotNull PtmModelPart modelPart, boolean enabled) {
        if (enabled) {
            this.enabledPtmModelParts.add(modelPart);
        } else {
            this.enabledPtmModelParts.remove((Object)modelPart);
        }
    }

    @Inject(method={"accept"}, at={@At(value="TAIL")})
    private void accept_loadEnabledPtmModelParts(@NotNull class_315.class_5823 visitor, @NotNull CallbackInfo ci) {
        boolean savedHideFloatingArmor = visitor.method_33684("%s.hideFloatingArmor".formatted("ptm"), this.ptm$isFloatingArmorHidden());
        if (this.ptm$isFloatingArmorHidden() != savedHideFloatingArmor) {
            this.ptm$setFloatingArmorHidden(savedHideFloatingArmor);
        }
        for (PtmModelPart modelPart : PtmModelPart.values()) {
            boolean savedValue;
            String optionsKey = "%s.modelPart_%s".formatted("ptm", modelPart.getName());
            boolean localValue = this.enabledPtmModelParts.contains((Object)modelPart);
            if (localValue == (savedValue = visitor.method_33684(optionsKey, localValue))) continue;
            this.ptm$setModelPartEnabled(modelPart, savedValue);
        }
    }

    @Inject(method={"sendClientSettings"}, at={@At(value="TAIL")})
    private void sendClientSettings_updatePtmPlayerConfig(@NotNull CallbackInfo ci) {
        if (Objects.nonNull(this.field_1863.field_1724)) {
            PtmPlayerConfig ptmPlayerConfig = this.ptm$getPlayerConfig();
            PtmPlayerConfig.set((class_1657)this.field_1863.field_1724, ptmPlayerConfig);
            ClientPlayNetworking.send((class_8710)new PtmSyncPlayerConfigPayload(ptmPlayerConfig));
        }
    }
}

